/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.util;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.ui.PartInitException;

public class LocationUtil {
    public static final String PROPERTY_NAME_ROOTDIR = Common_ConfigurationFactory.eINSTANCE.createHyadesRootDirectroyCategory().getName();

    public static void createNew(IFile file, String name, String description, String hostname) throws Exception {
        Resource resource = LocationUtil.createResource(file);
        CFGLocation location = LocationUtil.createLocation(name, description, hostname);
        resource.getContents().add((Object)location);
        EMFUtil.save(resource);
    }

    public static CFGLocation createLocation(String name, String description, String hostname) {
        CFGLocation location = ConfigurationUtil.createLocation((String)name, (String)description, (String)hostname);
        LocationUtil.setLocationRootDir(location);
        return location;
    }

    public static Resource createResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("location");
        return factory.createResource(uri);
    }

    public static String getFileExtension() {
        return "location";
    }

    public static void openEditor(IFile file) throws PartInitException {
        if (!file.getFileExtension().equals(LocationUtil.getFileExtension())) {
            return;
        }
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)file, (String)"org.eclipse.hyades.test.ui.editor.LocationEditorPart", (boolean)false);
        }
    }

    public static void setLocationRootDir(CFGLocation location) {
        CFGPropertyGroup propGroup = ConfigurationUtil.searchPropertyGroupById((List)location.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.location.attributes");
        if (propGroup == null) {
            propGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            propGroup.setPropertyGroupID("org.eclipse.hyades.test.configuration.location.attributes");
            location.getPropertyGroups().add((Object)propGroup);
        }
        BVRProperty[] properties = ConfigurationUtil.searchPropertiesByName((List)propGroup.getProperties(), (String)PROPERTY_NAME_ROOTDIR, (boolean)false);
        CFGComparableProperty property = null;
        if (properties == null || properties.length < 1) {
            property = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            property.setName(PROPERTY_NAME_ROOTDIR);
            property.setOperator("=");
            propGroup.getProperties().add((Object)property);
        } else {
            property = (CFGComparableProperty)properties[0];
        }
        if (property.getValue() == null) {
            String workspaceRootDir = LocationUtil.getWorkspaceRootDir();
            property.setValue(workspaceRootDir);
        }
    }

    protected static String getWorkspaceRootDir() {
        String workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        if (workspaceRoot.endsWith(File.separator)) {
            workspaceRoot = workspaceRoot.substring(0, workspaceRoot.length() - File.separator.length());
        }
        return workspaceRoot;
    }
}

