/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public class TestSuiteNewWizard
extends HyadesNewWizard {
    public TestSuiteNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_TST_SUITE_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newtestsuite_wiz.gif"));
        IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("TestSuiteNewWizard");
        }
        this.setDialogSettings(settings);
    }

    protected String getType() {
        return "org.eclipse.hyades.testSuite.generic";
    }

    protected String getFileExtension() {
        return "testsuite";
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_TST_SUITE_GEN_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_TST_SUITE_GEN_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_TST_SUITE_GEN_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile file) throws Exception {
        Resource resource = this.createResource(file);
        resource.getContents().add((Object)this.createEObject());
        EMFUtil.save(resource);
        return true;
    }

    protected EObject createEObject() {
        TPFTestSuite testSuite = Common_TestprofileFactory.eINSTANCE.createTPFTestSuite();
        testSuite.setType(this.getType());
        testSuite.setName(this.getLocationPage().getItemName());
        String description = this.getAttributeWizardPage().getItemDescription();
        if (description != null && description.trim().length() > 0) {
            testSuite.setDescription(description);
        }
        if (testSuite.getBehavior() == null) {
            TPFBehavior behavior = Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
            testSuite.setBehavior(behavior);
        }
        return testSuite;
    }

    protected Resource createResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("testsuite");
        return factory.createResource(uri);
    }

    protected void openEditor(IFile file) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)file, (String)"org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart", (boolean)false);
        }
    }
}

