/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.file;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.internal.execution.file.FileServiceConstants;
import org.eclipse.hyades.internal.execution.file.IFileServer;
import org.eclipse.hyades.internal.execution.file.IFileServerParameters;
import org.eclipse.hyades.internal.execution.local.common.Constants;

class FileServerLegacy
implements Runnable,
FileServiceConstants,
Constants,
IFileServer {
    private int port;
    private ServerSocket serverSocket;
    private IConnectionHandler connHandler;
    private int serverStatus = 0;
    private int errorType = 0;
    private int initStatus = 0;

    FileServerLegacy() {
    }

    public void init(IFileServerParameters ifsp) {
        this.connHandler = (IConnectionHandler)ifsp.getConnectionHandler();
        this.port = ifsp.getPort();
    }

    public synchronized void run() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.initStatus = 1;
            this.notifyAll();
            while (true) {
                Socket newSocket = this.serverSocket.accept();
                this.connHandler.connectionAccepted(newSocket);
            }
        }
        catch (BindException be) {
            this.serverStatus = -1;
            this.errorType = -10;
            this.initStatus = 1;
            this.notifyAll();
        }
        catch (IOException e) {
            this.serverStatus = -1;
            this.errorType = -9;
            this.initStatus = 1;
            this.notifyAll();
        }
    }

    public synchronized int getFileServerStatus() {
        block2: {
            long timeout = 5000L;
            if (this.initStatus == 1) break block2;
            try {
                this.wait(5000L);
            }
            catch (InterruptedException e) {}
        }
        return this.serverStatus;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public synchronized void quit() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {}
    }
}

