/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.ConsoleNotStartedException;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RAString;

public class LaunchProcessCommand
extends CommandElement
implements Constants {
    protected RAString _args = new RAString("");
    protected RAString _exe = new RAString("");
    protected RAString _location = new RAString("");
    protected long _consoleIP = 0L;
    protected long _consolePort = 0L;
    protected Vector _environment = new Vector();
    protected Vector _agents = new Vector();

    public LaunchProcessCommand() {
        this._tag = 16L;
    }

    public void addAgent(String name) {
        this._agents.addElement(new RAString(name));
    }

    public void addEnvironmentVariable(String name, String value) {
        this._environment.addElement(new RAString(name + "=" + value));
    }

    public String getArgs() {
        if (this._args != null) {
            return this._args.getData();
        }
        return null;
    }

    public String getExe() {
        if (this._exe != null) {
            return this._exe.getData();
        }
        return null;
    }

    public int getSize() {
        int size = 16 + this._exe.getSize() + this._args.getSize() + this._location.getSize() + 8;
        int i = 0;
        while (i < this._agents.size()) {
            size += ((RAString)this._agents.elementAt(i)).getSize();
            ++i;
        }
        int i2 = 0;
        while (i2 < this._environment.size()) {
            size += ((RAString)this._environment.elementAt(i2)).getSize();
            ++i2;
        }
        return size;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = offset;
        this._context = Message.readRALongFromBuffer(buffer, current);
        this._consoleIP = Message.readRALongFromBuffer(buffer, current += 4);
        this._consolePort = Message.readRALongFromBuffer(buffer, current += 4);
        current += 4;
        current = Message.readRAStringFromBuffer(buffer, current, this._exe);
        current = Message.readRAStringFromBuffer(buffer, current, this._args);
        current = Message.readRAStringFromBuffer(buffer, current, this._location);
        long listLength = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        int i = 0;
        while ((long)i < listLength) {
            RAString envVar = null;
            current = Message.readRAStringFromBuffer(buffer, current, envVar);
            this._agents.addElement(envVar);
            ++i;
        }
        listLength = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        int i2 = 0;
        while ((long)i2 < listLength) {
            RAString envVar = null;
            current = Message.readRAStringFromBuffer(buffer, current, envVar);
            this._environment.addElement(envVar);
            ++i2;
        }
        return current;
    }

    public void setArgs(String args) {
        this._args = new RAString(args);
    }

    public void setConsole(Console console) throws ConsoleNotStartedException {
        this._consoleIP = console.getIP();
        this._consolePort = console.getPort();
    }

    public void setExe(String exe) {
        this._exe = new RAString(exe);
    }

    public void setLocation(String location) {
        this._location = new RAString(location);
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = Message.writeRALongToBuffer(buffer, current, this._tag);
        current = Message.writeRALongToBuffer(buffer, current, this._context);
        current = Message.writeRALongToBuffer(buffer, current, this._consoleIP);
        current = Message.writeRALongToBuffer(buffer, current, this._consolePort);
        current = Message.writeRAStringToBuffer(buffer, current, this._exe);
        current = Message.writeRAStringToBuffer(buffer, current, this._args);
        current = Message.writeRAStringToBuffer(buffer, current, this._location);
        current = Message.writeRALongToBuffer(buffer, current, this._environment.size());
        int i = 0;
        while (i < this._environment.size()) {
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this._environment.elementAt(i));
            ++i;
        }
        current = Message.writeRALongToBuffer(buffer, current, this._agents.size());
        int i2 = 0;
        while (i2 < this._agents.size()) {
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this._agents.elementAt(i2));
            ++i2;
        }
        return current;
    }
}

