/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.extensions;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;

public abstract class JDBCHelper {
    protected Connection connection;
    protected boolean debug = false;
    protected String driver;
    protected Driver driverInstance;
    protected Writer file;
    private Properties properties;
    protected String protocol;
    protected boolean toFileOnly = false;
    protected DatabaseType type;
    protected String urlString;

    public JDBCHelper(DatabaseType type) {
        String s;
        this.type = type;
        try {
            s = System.getProperties().getProperty("JDBCHelper.debug");
            this.debug = Boolean.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            s = System.getProperties().getProperty("JDBCHelper.toFileOnly");
            this.toFileOnly = Boolean.valueOf(s);
        }
        catch (Exception e) {}
    }

    public void close() throws SQLException {
        if (!this.getConnection().getAutoCommit()) {
            this.getConnection().commit();
        }
        this.getConnection().close();
    }

    public void commitTransaction() throws Exception {
        if (this.toFileOnly) {
            return;
        }
        if (!this.getConnection().getAutoCommit()) {
            this.getConnection().commit();
        }
    }

    public PreparedStatement createPreparedStatement(String statement) throws Exception {
        if (this.toFileOnly) {
            return null;
        }
        return this.getConnection().prepareStatement(statement);
    }

    public Statement createStatement() throws Exception {
        if (this.toFileOnly) {
            return null;
        }
        return this.getConnection().createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws Exception {
        if (this.toFileOnly) {
            return null;
        }
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws Exception {
        if (this.toFileOnly) {
            return null;
        }
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public synchronized void execute(Statement sqlStatement, String statement) throws Exception {
        if (this.debug) {
            System.out.println(statement);
        }
        if (this.toFileOnly) {
            this.writeToFile(statement);
        } else {
            try {
                sqlStatement.execute(statement);
            }
            catch (Exception e) {
                LoadersUtils.log((Throwable)e, (String)("------------ JDBCHelper.execute sqlString=" + statement));
                sqlStatement.close();
                throw e;
            }
        }
        sqlStatement.close();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized int[] executeBatchedPreparedStatement(PreparedStatement sqlStatement) throws Exception {
        block5: {
            if (this.debug) {
                LoadersUtils.log((String)sqlStatement.toString());
            }
            if (this.toFileOnly) {
                this.writeToFile(this.printPreparedStatementParameters(sqlStatement));
                return new int[0];
            }
            res = null;
            try {
                res = sqlStatement.executeBatch();
                break block5;
            }
            catch (BatchUpdateException e) {
                LoadersUtils.log((Throwable)e, (String)"------------ JDBCHelper.executeBatchedPreparedStatement");
                e1 /* !! */  = e;
                i = 1;
                ** while ((e1 /* !! */  = e1 /* !! */ .getNextException()) != null)
            }
lbl-1000:
            // 1 sources

            {
                LoadersUtils.log((Throwable)e1 /* !! */ , (String)("------------ " + i++ + "-------------"));
                continue;
            }
lbl17:
            // 1 sources

            sqlStatement.close();
            throw e;
        }
        return res;
    }

    public synchronized boolean executePreparedStatement(PreparedStatement sqlStatement) throws Exception {
        boolean res = true;
        if (this.debug) {
            System.out.println(sqlStatement);
        }
        if (this.toFileOnly) {
            this.writeToFile(this.printPreparedStatementParameters(sqlStatement));
            return true;
        }
        try {
            res = sqlStatement.execute();
        }
        catch (Exception e) {
            LoadersUtils.log((Throwable)e, (String)"------------ JDBCHelper.executePreparedStatement");
            sqlStatement.close();
            throw e;
        }
        sqlStatement.close();
        return res;
    }

    public synchronized ResultSet executeQuery(Statement sqlStatement, String statement) throws Exception {
        ResultSet res = null;
        if (this.debug) {
            System.out.println(statement);
        }
        if (this.toFileOnly) {
            this.writeToFile(statement);
        } else {
            try {
                res = sqlStatement.executeQuery(statement);
            }
            catch (Exception e) {
                LoadersUtils.log((Throwable)e, (String)("------------ JDBCHelper.executeQuery sqlString=" + statement));
                sqlStatement.close();
                throw e;
            }
        }
        return res;
    }

    public synchronized void executeStatement(String statement) throws Exception {
        if (this.debug) {
            System.out.println(statement);
        }
        if (this.toFileOnly) {
            this.writeToFile(statement);
        } else {
            Statement s = this.getConnection().createStatement();
            this.execute(s, statement);
            s.close();
        }
    }

    public synchronized void executeUpdate(Statement sqlStatement, String statement) throws Exception {
        if (this.debug) {
            System.out.println(statement);
        }
        if (this.toFileOnly) {
            this.writeToFile(statement);
        } else {
            try {
                sqlStatement.executeUpdate(statement);
            }
            catch (Exception e) {
                LoadersUtils.log((Throwable)e, (String)("------------ JDBCHelper.executeUpdate sqlString=" + statement));
                sqlStatement.close();
                throw e;
            }
            sqlStatement.close();
        }
    }

    public synchronized void executeUpdateStatement(String statement) throws Exception {
        if (this.debug) {
            System.out.println(statement);
        }
        if (this.toFileOnly) {
            this.writeToFile(statement);
        } else {
            Statement s = this.getConnection().createStatement();
            this.executeUpdate(s, statement);
            s.close();
        }
    }

    public void executeUpdateStatements(List statements) throws Exception {
        int i = 0;
        int l = statements.size();
        while (i < l) {
            SQLStatement statement = (SQLStatement)statements.get(i);
            this.executeUpdateStatement(statement.getStatement());
            ++i;
        }
    }

    public void executeUpdateStatements(String[] statements) throws Exception {
        int i = 0;
        while (i < statements.length) {
            this.executeUpdateStatement(statements[i]);
            ++i;
        }
    }

    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.openForExistingDB("Hyades", this.properties);
            }
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
        return this.connection;
    }

    public DatabaseType getDatabaseType() {
        return this.type;
    }

    protected String getLocation(Properties properties) {
        String location = properties.getProperty("location");
        location = location == null || location.length() == 0 ? "" : "//" + location + "/";
        return location;
    }

    public Driver loadJDBCDriver() throws Exception {
        if (this.driverInstance != null) {
            return this.driverInstance;
        }
        return this.loadJDBCDriverSpecial();
    }

    protected Driver loadJDBCDriverSpecial() throws Exception {
        if (this.driverInstance != null) {
            return this.driverInstance;
        }
        DriverClassLoader cl = new DriverClassLoader(new URL[]{new URL(this.urlString)}, this.getClass().getClassLoader());
        Class<?> driverClass = Class.forName(this.driver, true, cl);
        Enumeration<Driver> enum1 = DriverManager.getDrivers();
        while (enum1.hasMoreElements()) {
            Driver element = enum1.nextElement();
            if (element.getClass() != driverClass) continue;
            this.driverInstance = element;
        }
        if (this.driverInstance == null) {
            this.driverInstance = (Driver)driverClass.newInstance();
            DriverManager.registerDriver(this.driverInstance);
        }
        return this.driverInstance;
    }

    public void openForExistingDB(String name, Properties properties) throws Exception {
        this.loadJDBCDriver();
        if (!this.toFileOnly) {
            this.connection = this.driverInstance.connect(this.protocol + this.getLocation(properties) + name, properties);
        }
    }

    public void openForNewDB(String name, Properties properties) throws Exception {
        this.loadJDBCDriver();
        this.connection = this.driverInstance.connect(this.protocol + this.getLocation(properties) + name + ";create=true", properties);
    }

    private String printPreparedStatementParameters(PreparedStatement statement) throws Exception {
        String res = statement.toString();
        boolean first = true;
        try {
            res = res + ": PreparedStatement.resultSetMetaData=";
            ResultSetMetaData metaData = statement.getMetaData();
            if (metaData == null) {
                res = res + metaData;
            } else {
                int i = 0;
                while (i < metaData.getColumnCount()) {
                    if (first) {
                        first = false;
                    } else {
                        res = res + ", ";
                    }
                    res = res + "col" + i + "=" + metaData.getTableName(i) + "." + metaData.getColumnLabel(i);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public void rollbackTransaction() throws Exception {
        if (!this.getConnection().getAutoCommit()) {
            this.getConnection().rollback();
        }
    }

    public void setAutoCommit(boolean value) throws Exception {
        if (this.toFileOnly) {
            return;
        }
        this.getConnection().setAutoCommit(value);
    }

    public void setHoldability(int hold_cursors_over_commit) throws Exception {
        if (this.toFileOnly) {
            return;
        }
        try {
            this.getConnection().setHoldability(hold_cursors_over_commit);
        }
        catch (Exception e) {}
    }

    public boolean shutdown() {
        boolean exceptionThrown = false;
        try {
            DriverManager.getConnection(this.protocol + ";shutdown=true");
        }
        catch (SQLException exception) {
            exceptionThrown = true;
        }
        return exceptionThrown;
    }

    protected void writeToFile(String sqlString) {
        try {
            if (this.file == null) {
                this.file = new FileWriter("/JDBCHelper_toFile_" + new Date().getTime() + ".sql");
            }
            this.file.write(sqlString + "\n");
            this.file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void setProperties(Properties properties) {
        if (this.properties != null && this.properties.equals(properties)) {
            return;
        }
        this.properties = properties;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new DBCollectedExceptions(e);
            }
            this.connection = null;
            this.getConnection();
        }
    }

    public class DriverClassLoader
    extends URLClassLoader {
        public DriverClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }
    }
}

