/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;

public class ClassQuery
extends QueryStatement {
    protected ClassMetadata metadata;
    protected int[] ids;
    protected boolean getAllObjects;
    protected boolean includeContainment;

    public ClassQuery(DatabaseType dbType, EClass eClass, ClassMetadata metadata, int[] ids, DBMap map, boolean getAllObjects, boolean includeContainment) {
        super(dbType, map, (EModelElement)eClass);
        this.metadata = metadata;
        this.ids = ids;
        this.getAllObjects = getAllObjects;
        this.includeContainment = includeContainment;
    }

    protected void createSelectFrom() {
        this.statement.append("SELECT ");
        this.statement.append(this.addQuotes(this.getIdColumnName()));
        this.statement.append(", ");
        this.statement.append(this.addQuotes("Is_EMF_Proxy"));
        List attributeColumns = this.metadata.getClassTableColumns();
        int i = 0;
        int l = attributeColumns.size();
        while (i < l) {
            Column column = (Column)attributeColumns.get(i);
            this.statement.append(", ");
            this.statement.append(this.addQuotes(column.getName()));
            ++i;
        }
        if (this.getAllObjects) {
            List columns = this.metadata.getReferenceClassTableColumns();
            int i2 = 0;
            int l2 = columns.size();
            while (i2 < l2) {
                Column column = (Column)columns.get(i2);
                EReference reference = this.dbMap.getReference(column);
                if (reference != null && reference.isContainment() && !this.includeContainment) {
                    if (reference.isMany()) {
                        ++i2;
                    }
                } else {
                    this.statement.append(", ");
                    this.statement.append(this.addQuotes(column.getName()));
                }
                ++i2;
            }
        }
        this.statement.append(" FROM ");
        this.statement.append(this.addQuotes(this.table.getName()));
    }

    protected String getIdColumnName() {
        return this.metadata.getPrimaryKey().getName();
    }

    protected void createWhereClause(int begin) {
        this.statement.append(" WHERE ");
        this.statement.append(this.addQuotes(this.getIdColumnName()));
        this.statement.append(" IN (");
        int i = begin;
        while (i < this.ids.length) {
            String id = "" + this.ids[i];
            if (this.statement.length() + id.length() > this.dbType.getMaximumSQLLength()) {
                this.initial = i;
                break;
            }
            if (i != begin) {
                this.statement.append(", ");
            }
            this.statement.append(this.ids[i]);
            ++i;
        }
        this.statement.append(")");
    }
}

