/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBResource;
import org.eclipse.hyades.resources.database.internal.Database;
import org.eclipse.hyades.resources.database.internal.InternalDatabase;
import org.eclipse.hyades.resources.database.internal.PagingList;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;

public class DBResourceContentAdapter
extends EContentAdapter
implements Adapter {
    protected DBResource resource;
    protected boolean isLoading;
    protected Map classesToMetadata;
    protected Collection notLoadedClasses;

    public void setTarget(Notifier target) {
        if (this.resource == null && target instanceof DBResource) {
            this.resource = (DBResource)target;
        } else if (target instanceof EObject) {
            this.ignorePagingListsContent((EObject)target);
            return;
        }
        super.setTarget(target);
    }

    protected void setNotLoadedClasses() {
        Map options = this.resource.getDefaultLoadOptions();
        this.notLoadedClasses = (Collection)options.get("NOT_LOADED_CLASSES");
        if (this.notLoadedClasses == null) {
            this.notLoadedClasses = Collections.EMPTY_LIST;
        }
    }

    protected void ignorePagingListsContent(EObject object) {
        List contents = this.getContents(object);
        int i = 0;
        int l = contents.size();
        while (i < l) {
            Notifier notifier = (Notifier)contents.get(i);
            notifier.eAdapters().add((Object)this);
            ++i;
        }
    }

    protected List getContents(EObject object) {
        ArrayList<Object> contents = new ArrayList<Object>();
        EList containments = object.eClass().getEAllContainments();
        int i = 0;
        int l = containments.size();
        while (i < l) {
            EReference containment = (EReference)containments.get(i);
            if (object.eIsSet((EStructuralFeature)containment)) {
                if (!containment.isMany()) {
                    contents.add(object.eGet((EStructuralFeature)containment, false));
                } else if (!this.inNotLoadedClasses(containment.getEReferenceType())) {
                    contents.addAll((List)object.eGet((EStructuralFeature)containment, false));
                }
            }
            ++i;
        }
        return contents;
    }

    protected boolean inNotLoadedClasses(EClass eClass) {
        if (this.notLoadedClasses == null) {
            this.setNotLoadedClasses();
        }
        if (this.notLoadedClasses.isEmpty()) {
            return false;
        }
        if (this.notLoadedClasses.contains(eClass)) {
            return true;
        }
        ClassMetadata metadata = this.getMetadata(eClass);
        EClass[] superclasses = metadata.getAllSuperclasses();
        int i = 0;
        while (i < superclasses.length) {
            if (this.notLoadedClasses.contains(superclasses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ClassMetadata getMetadata(EClass eClass) {
        ClassMetadata metadata;
        if (this.classesToMetadata == null) {
            this.classesToMetadata = new HashMap();
        }
        if ((metadata = (ClassMetadata)this.classesToMetadata.get(eClass)) == null) {
            metadata = new ClassMetadata(eClass, null, new RDBHelper());
            this.classesToMetadata.put(eClass, metadata);
        }
        return metadata;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.isLoading) {
            return;
        }
        int type = notification.getEventType();
        switch (type) {
            case 3: {
                this.processAdd(notification);
                break;
            }
            case 1: {
                this.processSet(notification);
                break;
            }
        }
    }

    protected void processAdd(Notification notification) {
        if (notification.getFeature() == null) {
            return;
        }
        EObject owner = (EObject)notification.getNotifier();
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (feature.isTransient()) {
            return;
        }
        if (owner.eGet(feature) instanceof PagingList) {
            this.updateForPagingListAdd(notification, owner, (EReference)feature);
        } else if (feature.isMany() && this.resource.isInDatabase()) {
            this.updateDatabase(notification, owner);
        }
    }

    protected void updateForPagingListAdd(Notification notification, EObject owner, EReference reference) {
        if (!this.resource.isInDatabase()) {
            this.saveResource();
            if (reference.isContainment()) {
                return;
            }
        }
        this.updateDatabase(notification, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDatabase(Notification notification, EObject owner) {
        try {
            Database database = this.resource.getDatabase();
            synchronized (database) {
                ((InternalDatabase)this.resource.getDatabase()).update(notification);
            }
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveResource() {
        try {
            Database database = this.resource.getDatabase();
            synchronized (database) {
                this.resource.save(null);
            }
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
    }

    protected void processSet(Notification notification) {
        if (notification.getFeature() == null) {
            return;
        }
        if (!this.resource.isInDatabase()) {
            return;
        }
        EObject owner = (EObject)notification.getNotifier();
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (feature.isTransient()) {
            return;
        }
        this.updateDatabase(notification, owner);
    }

    public void setIsLoading(boolean value) {
        this.isLoading = value;
    }
}

