/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;

public class GetIdByURICommand
extends DBCommand {
    protected String uri;
    protected EClass currentSourceType;
    protected int currentSourceId;
    protected EReference currentTargetReference;
    protected int currentTargetIndex;
    protected int currentFragmentIndex;
    protected String fragment;

    public GetIdByURICommand(JDBCHelper helper, DBMap map, String uri) {
        super(helper, map);
        this.uri = uri;
    }

    public Object execute() throws Exception {
        this.currentFragmentIndex = 0;
        this.getRootObjectId();
        if (this.currentTargetReference != null) {
            do {
                StatementFactory factory = StatementFactory.INSTANCE;
                QueryStatement query = factory.createGetTargetIdStatement(this.helper, this.dbMap, this.currentSourceId, this.currentTargetReference, this.currentTargetIndex);
                Statement statement = this.helper.createStatement();
                ResultSet rs = this.helper.executeQuery(statement, query.getStatement());
                while (rs.next()) {
                    this.currentSourceId = rs.getInt(1);
                }
                rs.close();
                statement.close();
            } while (this.processNextObject());
        }
        return new Integer(this.currentSourceId);
    }

    protected void getRootObjectId() throws Exception {
        int i = this.uri.indexOf(35);
        if (i != -1) {
            this.uri = this.uri.substring(0, i);
        }
        URI r = URI.createURI((String)this.uri);
        this.fragment = r.fragment();
        DBCommand c = DBCommandFactory.INSTANCE.createGetTopLevelObjects(this.helper, this.dbMap, r);
        List l = (List)c.execute();
        if (l.size() > 1) {
            this.currentSourceId = (Integer)((ArrayList)l.get(1)).get(0);
            this.currentSourceType = (EClass)l.get(0);
            if (this.fragment != null && this.fragment.startsWith("//")) {
                this.currentFragmentIndex = 2;
                this.processNextObject();
            }
        }
    }

    protected boolean processNextObject() {
        if (this.currentFragmentIndex >= this.fragment.length() - 1) {
            return false;
        }
        this.currentFragmentIndex = this.fragment.indexOf(47, this.currentFragmentIndex);
        int dotIndex = this.fragment.indexOf(46, this.currentFragmentIndex);
        int fEndIndex = dotIndex == -1 ? this.fragment.indexOf(47, this.currentFragmentIndex) : dotIndex;
        if (fEndIndex == -1) {
            fEndIndex = this.fragment.length() - 1;
        }
        String fName = this.fragment.substring(this.currentFragmentIndex, fEndIndex);
        this.currentTargetReference = (EReference)this.currentSourceType.getEStructuralFeature(fName);
        this.currentSourceType = (EClass)this.currentTargetReference.getEType();
        if (dotIndex == -1) {
            this.currentFragmentIndex = fEndIndex;
            this.currentTargetIndex = 0;
        } else {
            this.currentFragmentIndex = this.fragment.indexOf(47, dotIndex + 1);
            if (this.currentFragmentIndex == -1) {
                this.currentFragmentIndex = this.fragment.length() - 1;
            }
            this.currentTargetIndex = Integer.parseInt(this.fragment.substring(dotIndex + 1, this.currentFragmentIndex));
            ++this.currentFragmentIndex;
        }
        return true;
    }
}

