/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;

public class GetIdsOfReferencedObjects
extends DBCommand {
    protected DatabaseType type;
    protected int[] ids;
    protected EReference reference;
    protected boolean order;

    public GetIdsOfReferencedObjects(JDBCHelper helper, DBMap map, DatabaseType type, int[] ids, EReference reference, boolean order) {
        super(helper, map);
        this.type = type;
        this.ids = ids;
        this.reference = reference;
        this.order = order;
    }

    public Object execute() throws Exception {
        String[] queries = this.createQueries();
        if (this.order) {
            return this.executeOrderedQueries(queries);
        }
        return this.executeUnorderedQueries(queries);
    }

    protected int[][] executeOrderedQueries(String[] queries) throws Exception {
        int[][] referencedIds = new int[this.ids.length][];
        int i = 0;
        while (i < queries.length) {
            if (DBCommand.debug) {
                System.out.println(queries[i]);
            }
            Statement queryStatement = this.helper.createStatement();
            ResultSet rs = this.helper.executeQuery(queryStatement, queries[i]);
            ArrayList<Integer> idsForObject = new ArrayList<Integer>();
            int currentId = -1;
            int index = -1;
            while (rs.next()) {
                int source = rs.getInt(1);
                int target = rs.getInt(2);
                if (source != currentId) {
                    currentId = source;
                    if (index != -1) {
                        referencedIds[index] = this.createIds(idsForObject);
                        idsForObject.clear();
                    }
                    index = this.find(currentId, this.ids);
                }
                idsForObject.add(new Integer(target));
            }
            rs.close();
            queryStatement.close();
            if (index != -1) {
                referencedIds[index] = this.createIds(idsForObject);
            }
            ++i;
        }
        return referencedIds;
    }

    protected List executeUnorderedQueries(String[] queries) throws Exception {
        ArrayList<Integer> referencedIds = new ArrayList<Integer>();
        int i = 0;
        while (i < queries.length) {
            if (DBCommand.debug) {
                System.out.println(queries[i]);
            }
            Statement queryStatement = this.helper.createStatement();
            ResultSet rs = this.helper.executeQuery(queryStatement, queries[i]);
            while (rs.next()) {
                int target = rs.getInt(2);
                if (target <= 0) continue;
                referencedIds.add(new Integer(target));
            }
            rs.close();
            queryStatement.close();
            ++i;
        }
        return referencedIds;
    }

    protected String[] createQueries() {
        StatementFactory factory = StatementFactory.INSTANCE;
        QueryStatement query = factory.createGreedyReferenceQuery(this.ids, this.reference, this.dbMap, this.type, this.order);
        String queryString = query.getStatement();
        String[] queryStrings = queryString != null ? new String[]{queryString} : query.getStatements();
        return queryStrings;
    }

    protected int[] createIds(List idsForObject) {
        int[] ids = new int[idsForObject.size()];
        int i = 0;
        int l = idsForObject.size();
        while (i < l) {
            ids[i] = (Integer)idsForObject.get(i);
            ++i;
        }
        return ids;
    }

    protected int find(int id, int[] ids) {
        int i = 0;
        while (i < ids.length) {
            if (id == ids[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

