/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.InsertObjects;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.AttributeQuery;
import org.eclipse.hyades.resources.database.internal.impl.AttributeValueQuery;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.ClassQuery;
import org.eclipse.hyades.resources.database.internal.impl.ContainsQuery;
import org.eclipse.hyades.resources.database.internal.impl.DeleteStatement;
import org.eclipse.hyades.resources.database.internal.impl.GetTargetIdStatement;
import org.eclipse.hyades.resources.database.internal.impl.GreedyReferenceQueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.IndexQuery;
import org.eclipse.hyades.resources.database.internal.impl.IndexStatement;
import org.eclipse.hyades.resources.database.internal.impl.InsertAttributeValues;
import org.eclipse.hyades.resources.database.internal.impl.InsertReferenceStatement;
import org.eclipse.hyades.resources.database.internal.impl.InsertReferences;
import org.eclipse.hyades.resources.database.internal.impl.InsertStatement;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.ReferenceCountQuery;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;
import org.eclipse.hyades.resources.database.internal.impl.SetAttributeStatement;
import org.eclipse.hyades.resources.database.internal.impl.SimpleSearchQueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.TableStatement;
import org.eclipse.hyades.resources.database.internal.impl.TypeConverter;
import org.eclipse.hyades.resources.database.internal.impl.UpdateReferenceStatement;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class StatementFactory {
    public static final StatementFactory INSTANCE = new StatementFactory();

    private StatementFactory() {
    }

    public SQLStatement createTableStatement(DatabaseType dbType, DBMap map, Table table) {
        return new TableStatement(dbType, map, table);
    }

    public InsertStatement createInsertStatement(DatabaseType dbType, Table table, List columns) {
        return new InsertStatement(dbType, table, columns);
    }

    public InsertStatement createInsertObjects(DatabaseType type, ClassMetadata metadata, TypeConverter converter, Map objectsToIds, Map manyReferenceValues, WeakObjectCache cache) {
        return new InsertObjects(type, metadata, converter, objectsToIds, manyReferenceValues, cache);
    }

    public InsertStatement createInsertReferences(DatabaseType type, EReference reference, DBMap map, Map objectsToIds, Set proxies) {
        return new InsertReferences(type, reference, map, objectsToIds, proxies);
    }

    public InsertStatement createInsertAttributeValues(DBMap map, DatabaseType dbType, Map objectsToIds, EAttribute attribute, int type) {
        return new InsertAttributeValues(map, dbType, objectsToIds, attribute, type);
    }

    public QueryStatement createReferenceCountQuery(DatabaseType type, DBMap map, Integer id, EReference reference) {
        return new ReferenceCountQuery(type, map, id, reference);
    }

    public QueryStatement createIndexQuery(DatabaseType type, DBMap map, Integer sourceId, EReference reference, Integer targetId) {
        return new IndexQuery(type, map, sourceId, reference, targetId);
    }

    public QueryStatement createContainsQuery(DatabaseType type, DBMap map, Integer id, EReference reference, Integer referencedId) {
        return new ContainsQuery(type, map, id, reference, referencedId);
    }

    public QueryStatement createAttributeQuery(int[] ids, EAttribute attribute, DBMap map, DatabaseType type) {
        return new AttributeQuery(ids, attribute, map, type);
    }

    public QueryStatement createAttributeValueQuery(DatabaseType type, DBMap map, EClass eClass, List values, List ids) {
        return new AttributeValueQuery(type, map, eClass, values, ids);
    }

    public QueryStatement createClassQuery(DatabaseType type, EClass eClass, ClassMetadata metadata, int[] ids, DBMap map, boolean getAllObjects, boolean includeContainment) {
        return new ClassQuery(type, eClass, metadata, ids, map, getAllObjects, includeContainment);
    }

    public QueryStatement createGreedyReferenceQuery(int[] ids, EReference reference, DBMap map, DatabaseType type, boolean orderFlag) {
        return new GreedyReferenceQueryStatement(ids, reference, map, type, orderFlag);
    }

    public SQLStatement createIndexStatement(DatabaseType dbType, DBMap dbMap, EClass eClass) {
        return new IndexStatement(dbType, dbMap, eClass);
    }

    public SQLStatement createUpdateReferenceStatement(DatabaseType dbType, DBMap dbMap, Integer sourceId, EReference reference, Integer targetId, int position) {
        return new UpdateReferenceStatement(dbType, dbMap, sourceId, reference, targetId, position);
    }

    public SQLStatement createInsertReferenceStatement(DatabaseType dbType, DBMap dbMap, Integer sourceId, EReference reference, Integer targetId, int position) {
        return new InsertReferenceStatement(dbType, dbMap, sourceId, reference, targetId, position);
    }

    public SQLStatement createSetAttributeStatement(DatabaseType dbType, DBMap dbMap, Integer id, EAttribute attribute, Object value) {
        return new SetAttributeStatement(dbType, dbMap, id, attribute, value);
    }

    public SQLStatement createDeleteStatement(DatabaseType dbType, DBMap dbMap, EClass eClass, List ids, DatabaseType type) {
        return new DeleteStatement(dbMap, type, eClass, ids);
    }

    public SQLStatement createSimpleSearchQueryStatement(JDBCHelper helper, DBMap dbMap, SimpleSearchQuery query) {
        return new SimpleSearchQueryStatement(helper, dbMap, query);
    }

    public QueryStatement createGetTargetIdStatement(JDBCHelper helper, DBMap dbMap, int sourceId, EReference reference, int index) {
        return new GetTargetIdStatement(dbMap, helper.getDatabaseType(), sourceId, reference, index);
    }

    public SQLStatement createTimeBasedCorrelationQueryStatement(JDBCHelper helper, DBMap dbMap, SimpleSearchQuery query) {
        return new SimpleSearchQueryStatement(helper, dbMap, query);
    }
}

