/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.hyades.edit.datapool.INamedElement;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class NamedElementPropertySource
implements IPropertySource2 {
    public static final String PROPERTY_SOURCE_NAME = "datapool.propertySource.name";
    public static final String PROPERTY_SOURCE_DESCRIPTION = "datapool.propertySource.description";
    public static final String PROPERTY_SOURCE_ID = "datapool.propertySource.id";
    private INamedElement namedElement;
    private IPropertyDescriptor[] descriptors;

    public NamedElementPropertySource(INamedElement namedElement) {
        if (namedElement == null) {
            throw new IllegalArgumentException();
        }
        this.namedElement = namedElement;
    }

    public INamedElement getNamedElement() {
        return this.namedElement;
    }

    public boolean isPropertyResettable(Object id) {
        return id == null || !id.equals(PROPERTY_SOURCE_ID);
    }

    public Object getEditableValue() {
        return this.namedElement.getName();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new IPropertyDescriptor[3];
            this.descriptors[0] = new TextPropertyDescriptor((Object)PROPERTY_SOURCE_NAME, TestUIPlugin.getString("Word.Name"));
            ((PropertyDescriptor)this.descriptors[0]).setCategory(TestUIPlugin.getString("Word.Attributes"));
            this.descriptors[1] = new TextPropertyDescriptor((Object)PROPERTY_SOURCE_DESCRIPTION, TestUIPlugin.getString("Word.Description"));
            ((PropertyDescriptor)this.descriptors[1]).setCategory(TestUIPlugin.getString("Word.Attributes"));
            this.descriptors[2] = new PropertyDescriptor((Object)PROPERTY_SOURCE_ID, TestUIPlugin.getString("Word.ID"));
            ((PropertyDescriptor)this.descriptors[2]).setCategory(TestUIPlugin.getString("Word.Attributes"));
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (id != null && id.equals(PROPERTY_SOURCE_NAME)) {
            return this.namedElement.getName();
        }
        if (id != null && id.equals(PROPERTY_SOURCE_DESCRIPTION)) {
            return this.namedElement.getDescription() == null ? "" : this.namedElement.getDescription();
        }
        if (id != null && id.equals(PROPERTY_SOURCE_ID)) {
            return this.namedElement.getId();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return id != null && id.equals(PROPERTY_SOURCE_NAME);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (id != null && id.equals(PROPERTY_SOURCE_NAME)) {
            this.namedElement.setName(value.toString());
        } else if (id != null && id.equals(PROPERTY_SOURCE_DESCRIPTION)) {
            this.namedElement.setDescription(value.toString());
        } else if (id != null && id.equals(PROPERTY_SOURCE_ID)) {
            this.namedElement.setId(value.toString());
        }
    }
}

