/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.dialog;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.internal.component.EObjectResourceSelectionViewer;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EObjectResourceSelectionDialog
extends Dialog
implements SelectionListener,
IDoubleClickListener {
    private String[] fileExtensions;
    private String title;
    private EObjectResourceSelectionViewer viewer;
    private Image fileImage;
    private EObject[] selectedEObjects;

    public EObjectResourceSelectionDialog(Shell parentShell, String title, String[] theFileExtensions, Image fileImage) {
        super(parentShell);
        this.title = title;
        this.fileExtensions = theFileExtensions;
        this.fileImage = fileImage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 300;
        gridData.widthHint = 250;
        composite.setLayoutData((Object)gridData);
        this.createViewer(composite);
        return composite;
    }

    protected StructuredViewer createViewer(Composite parent) {
        this.viewer = new EObjectResourceSelectionViewer(parent, ResourcesPlugin.getWorkspace().getRoot(), this.fileExtensions, 67586);
        this.viewer.getViewer().addDoubleClickListener((IDoubleClickListener)this);
        return this.viewer.getViewer();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public EObject[] getSelectedObjects() {
        return this.viewer.getSelectedObjects();
    }

    public IFile[] getSelectedFiles() {
        return this.viewer.getSelectedFiles();
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getViewer() == this.viewer.getViewer()) {
            this.viewer.setSelection();
            this.buttonPressed(0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.viewer.widgetSelected(e);
    }
}

