/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.adapter.NamedElementPropertySource;
import org.eclipse.hyades.test.ui.adapter.PropertySourceLabelProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.TreeSection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.SelectionListenerAction;

public abstract class DatapoolChildrenTreeSection
extends TreeSection
implements MouseListener,
KeyListener {
    private IAction[] buttonActions;
    private ITreeContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private TreeEditor treeEditor;

    public DatapoolChildrenTreeSection(EditorForm editorForm, IAction[] buttonActions, int treeStyle) {
        super(editorForm);
        this.buttonActions = buttonActions;
        String[] buttonLabels = new String[buttonActions.length];
        int i = 0;
        while (i < buttonActions.length) {
            buttonLabels[i] = buttonActions[i].getText();
            ++i;
        }
        super.setTreeStryle(treeStyle);
        super.setButtonLabels(buttonLabels);
    }

    public void dispose() {
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                this.buttonActions[i] = null;
            }
            ++i;
        }
        super.dispose();
    }

    protected void adjustClient(Composite parent) {
        TreeViewer treeViewer = this.getTreeViewer();
        Tree tree = treeViewer.getTree();
        this.treeEditor = new TreeEditor(tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.minimumWidth = 50;
        tree.addMouseListener((MouseListener)this);
        tree.addKeyListener((KeyListener)this);
        treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        treeViewer.setAutoExpandLevel(0);
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                this.getTreePart().setButtonEnabled(i, this.buttonActions[i].isEnabled());
            }
            ++i;
        }
    }

    protected void startTreeItemEditing() {
        Tree tree = this.getTreeViewer().getTree();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length < 1) {
            return;
        }
        Text editor = new Text((Composite)tree, 2048);
        editor.setText(items[0].getText());
        editor.addKeyListener((KeyListener)this);
        editor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DatapoolChildrenTreeSection.this.applyTreeItemEditing();
            }
        });
        editor.selectAll();
        editor.setFocus();
        this.treeEditor.setEditor((Control)editor, items[0]);
    }

    protected String applyTreeItemEditing() {
        String newValue = null;
        Control editor = this.treeEditor.getEditor();
        if (editor == null) {
            return newValue;
        }
        if (editor instanceof Text) {
            newValue = ((Text)editor).getText();
            if (newValue.length() == 0 || newValue.equals(this.treeEditor.getItem().getText())) {
                this.cancelTreeItemEditing();
                return null;
            }
            this.setNewTreeItemName(this.treeEditor.getItem(), newValue);
        }
        editor.dispose();
        this.treeEditor.setEditor(null);
        return newValue;
    }

    public void setNewTreeItemName(TreeItem item, String newName) {
        item.setText(newName);
        if (item.getData() instanceof NamedElementPropertySource) {
            NamedElementPropertySource namedElementPropSrc = (NamedElementPropertySource)item.getData();
            namedElementPropSrc.getNamedElement().setName(newName);
        }
    }

    protected void cancelTreeItemEditing() {
        Control editor = this.treeEditor.getEditor();
        if (editor == null) {
            return;
        }
        editor.dispose();
        this.treeEditor.setEditor(null);
    }

    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new DatapoolChildrenContentProvider();
        }
        return this.contentProvider;
    }

    protected ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new PropertySourceLabelProvider();
        }
        return this.labelProvider;
    }

    public abstract Object[] getChildren(IDatapool var1);

    public abstract Object getParent(Object var1);

    public abstract boolean hasChildren(IDatapool var1);

    public abstract Object[] getElements(IDatapool var1);

    public abstract void inputChanged(Viewer var1, Object var2, Object var3);

    protected void buttonSelected(int index) {
        IStructuredSelection selection = this.getStructuredSelection();
        if (!this.isReadOnly() && index >= 0 && index < this.buttonActions.length) {
            this.buttonActions[index].run();
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
        if (this.buttonActions == null || this.buttonActions.length < 1) {
            return;
        }
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                if (this.buttonActions[i] instanceof SelectionListenerAction) {
                    ((SelectionListenerAction)this.buttonActions[i]).selectionChanged(structuredSelection);
                }
                this.getTreePart().setButtonEnabled(i, this.buttonActions[i].isEnabled());
            }
            ++i;
        }
    }

    protected void selectionChanged(IStructuredSelection structuredSelection) {
        super.selectionChanged(structuredSelection);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.widget instanceof Tree) {
            this.startTreeItemEditing();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.widget instanceof Tree) {
            if (e.keyCode == 0x100000B) {
                this.startTreeItemEditing();
            }
        } else if (e.widget instanceof Text) {
            if (e.character == '\r') {
                this.applyTreeItemEditing();
            } else if (e.character == '\u001b') {
                this.cancelTreeItemEditing();
            }
        }
    }

    class DatapoolChildrenContentProvider
    implements ITreeContentProvider {
        DatapoolChildrenContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDatapool) {
                return DatapoolChildrenTreeSection.this.getChildren((IDatapool)parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return DatapoolChildrenTreeSection.this.getParent(element);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDatapool) {
                return DatapoolChildrenTreeSection.this.hasChildren((IDatapool)element);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IDatapool) {
                return DatapoolChildrenTreeSection.this.getElements((IDatapool)inputElement);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            DatapoolChildrenTreeSection.this.inputChanged(viewer, oldInput, newInput);
        }
    }
}

