/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.EventForm;
import org.eclipse.hyades.test.ui.internal.editor.form.ExecutionForm;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ExecutionEditorExtension
extends BaseEditorExtension {
    private static final int PAGE_OVERVIEW = 0;
    private static final int PAGE_EVENTS = 1;
    public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Execution";
    private ExecutionForm executionForm;
    private EventForm eventsForm;

    public void dispose() {
        this.executionForm.getWidgetFactory().dispose();
        this.executionForm.dispose();
        this.eventsForm.dispose();
        super.dispose();
    }

    public TPFExecutionResult getExecution() {
        return (TPFExecutionResult)this.getHyadesEditorPart().getEditorObject();
    }

    public void createPages() {
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        WidgetFactory widgetFactory = new WidgetFactory();
        this.executionForm = new ExecutionForm(this, widgetFactory);
        hyadesEditorPart.addPage(this.executionForm.createControl());
        hyadesEditorPart.setPageText(0, TestUIPlugin.getString("W_OVERVIEW"));
        this.eventsForm = new EventForm(this, widgetFactory);
        hyadesEditorPart.addPage(this.eventsForm.createControl());
        hyadesEditorPart.setPageText(1, TestUIPlugin.getString("W_EVENTS"));
        this.executionForm.updateTitle();
    }

    public boolean editorFileChanged() {
        block2: {
            this.reload();
            if (this.getHyadesEditorPart().getActivePage() != 1 || !this.getSelection().isEmpty()) break block2;
            try {
                this.setSelection((IStructuredSelection)new StructuredSelection(this.getExecution().getExecutionHistory().getExecutionEvents().get(0)));
            }
            catch (RuntimeException e) {}
        }
        return true;
    }

    public void refreshContent(Object data) {
        this.executionForm.load();
        this.executionForm.updateTitle();
        this.eventsForm.load();
    }

    public IStructuredSelection getSelection() {
        switch (this.getHyadesEditorPart().getActivePage()) {
            case 0: {
                return new StructuredSelection((Object)this.getExecution());
            }
            case 1: {
                return (IStructuredSelection)this.eventsForm.getSelection();
            }
        }
        return StructuredSelection.EMPTY;
    }

    public boolean pageActivated(int index) {
        switch (index) {
            case 0: {
                return this.executionForm.activated();
            }
            case 1: {
                return this.eventsForm.activated();
            }
        }
        return false;
    }

    public void setSelection(IStructuredSelection structuredSelection) {
        Object object;
        if (structuredSelection.size() == 1 && (object = structuredSelection.getFirstElement()) != this.getExecution()) {
            this.getHyadesEditorPart().setActivePage(1);
            this.eventsForm.selectReveal((ISelection)structuredSelection);
        }
    }
}

