/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExecutionResultDetailPage
extends DetailSection.DetailPage
implements IHyperlinkListener {
    private SelectableFormLabel testLink;
    private Label imageLabel;
    private StyledText typeText;
    private StyledText fileText;
    private StyledText verdictText;
    private StyledText startText;
    private StyledText stopText;
    private TPFExecutionResult executionResult;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public void dispose() {
        if (this.testLink != null && !this.testLink.isDisposed()) {
            this.testLink.setData(null);
        }
        this.executionResult = null;
    }

    public Control createControl(Composite parent, FormWidgetFactory factory) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.createTestLink(composite);
        widgetFactory.createLabel(composite, "").setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_VERD"));
        this.verdictText = widgetFactory.createStyledText(composite, 65540);
        this.verdictText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.verdictText.setEditable(false);
        widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_START"));
        this.startText = widgetFactory.createStyledText(composite, 65540);
        this.startText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.startText.setEditable(false);
        widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_STOP"));
        this.stopText = widgetFactory.createStyledText(composite, 65540);
        this.stopText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.stopText.setEditable(false);
        widgetFactory.paintBordersFor(composite);
        return composite;
    }

    protected void createTestLink(Composite parent) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite linkComposite = widgetFactory.createComposite(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        linkComposite.setLayout((Layout)gridLayout);
        linkComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.imageLabel = widgetFactory.createLabel(linkComposite, "");
        this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
        this.testLink = widgetFactory.createSelectableLabel(linkComposite, "");
        this.testLink.setText(TestUIPlugin.getString("NO_TST_TO_INV"));
        this.testLink.setToolTipText(TestUIPlugin.getString("TIP_EXE_TEST"));
        widgetFactory.turnIntoHyperlink((Control)this.testLink, this);
        Composite detailComposite = widgetFactory.createComposite(parent);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        detailComposite.setLayout((Layout)gridLayout);
        detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(detailComposite, TestUIPlugin.getString("L_TYPE"));
        this.typeText = widgetFactory.createStyledText(detailComposite, 65540);
        this.typeText.setEnabled(false);
        this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(detailComposite, TestUIPlugin.getString("L_FILE"));
        this.fileText = widgetFactory.createStyledText(detailComposite, 65540);
        this.fileText.setEnabled(false);
        this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.executionResult = null;
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        boolean doPack = false;
        boolean testIsSet = false;
        if (object instanceof TPFExecutionResult) {
            this.executionResult = (TPFExecutionResult)object;
            TPFTest test = this.executionResult.getTest();
            doPack = true;
            if (test != null) {
                String value;
                IWorkbenchAdapter workbenchAdapter;
                testIsSet = true;
                ImageDescriptor imageDescriptor = null;
                if (test instanceof IAdaptable && (workbenchAdapter = (IWorkbenchAdapter)test.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = ExecutionResultDetailPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                    imageDescriptor = workbenchAdapter.getImageDescriptor((Object)test);
                }
                if (imageDescriptor == null) {
                    imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                }
                this.imageLabel.setImage(imageDescriptor.createImage());
                if (test.getName() != null) {
                    this.testLink.setText(test.getName());
                } else {
                    this.testLink.setText(TestUIPlugin.getString("W_TEST"));
                }
                this.testLink.setData(test);
                TPFTestSuite testSuite = null;
                testSuite = test instanceof TPFTestSuite ? (TPFTestSuite)test : ((TPFTestCase)test).getTestSuite();
                if (testSuite != null && (value = testSuite.getType()) != null) {
                    IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    if (descriptor != null && descriptor.getName() != null) {
                        value = descriptor.getName();
                    }
                    this.typeText.setText(value);
                }
                this.fileText.setText(EMFUtil.getFilePath((EObject)testSuite));
                if (this.executionResult.getVerdict() != null) {
                    this.verdictText.setText(this.executionResult.getVerdict().getLabel());
                } else {
                    this.verdictText.setText("");
                }
                long startTimestamp = 0L;
                long stopTimestamp = 0L;
                Iterator i = this.executionResult.getExecutionHistory().getExecutionEvents().iterator();
                while (i.hasNext()) {
                    TPFExecutionType type;
                    TPFExecutionEvent event = (TPFExecutionEvent)i.next();
                    if (!(event instanceof TPFTypedEvent) || (type = ((TPFTypedEvent)event).getType()) == null) continue;
                    switch (type.getValue()) {
                        case 0: {
                            startTimestamp = event.getTimestamp();
                            break;
                        }
                        case 1: {
                            stopTimestamp = event.getTimestamp();
                        }
                    }
                    if (startTimestamp != 0L && stopTimestamp != 0L) break;
                }
                this.startText.setText(EventUtil.getTime(startTimestamp));
                this.stopText.setText(EventUtil.getTime(stopTimestamp));
            }
        } else {
            this.verdictText.setText("");
            this.startText.setText("");
            this.stopText.setText("");
        }
        if (!testIsSet) {
            doPack = true;
            this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
            this.testLink.setText(TestUIPlugin.getString("NO_TST_TO_INV"));
            this.testLink.setData(null);
            this.fileText.setText("");
            this.typeText.setText("");
        }
        if (doPack) {
            this.imageLabel.pack(true);
            this.imageLabel.redraw();
            this.testLink.pack(true);
            this.testLink.redraw();
        }
    }

    public Object getInput() {
        return this.executionResult;
    }

    public void linkActivated(Control linkLabel) {
        Object data = linkLabel.getData();
        if (data != null) {
            EObject eObject = (EObject)data;
            IEditorPart editorPart = TestUIUtil.openEditor(eObject.eResource(), null, false);
            if (editorPart instanceof ISelectionProvider) {
                ((ISelectionProvider)editorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
            }
            return;
        }
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setErrorMessage(TestUIPlugin.getString("_ERROR_MSG_UN_OPEN_OBJ"));
        }
    }

    public void linkEntered(Control linkLabel) {
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage(((SelectableFormLabel)linkLabel).getText());
        }
    }

    public void linkExited(Control linkLabel) {
        IActionBars actionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
            manager.setErrorMessage("");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

