/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SharedPartWithButtons;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class StructuredViewerPart
extends SharedPartWithButtons {
    private StructuredViewer viewer;
    private Point minSize = null;

    public StructuredViewerPart(String[] buttonLabels) {
        super(buttonLabels);
    }

    public StructuredViewerPart(String[] buttonLabels, String[] toolTips) {
        super(buttonLabels, toolTips);
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    protected void createMainControl(Composite parent, int style, int span, FormWidgetFactory factory) {
        this.viewer = this.createStructuredViewer(parent, style, factory);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                StructuredViewerPart.this.selectionChanged((IStructuredSelection)e.getSelection());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                StructuredViewerPart.this.handleDoubleClick((IStructuredSelection)e.getSelection());
            }
        });
        Control control = this.viewer.getControl();
        if (factory != null) {
            factory.hookDeleteListener(control);
        }
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        control.setLayoutData((Object)gd);
        this.applyMinimumSize();
    }

    public void setMinimumSize(int width, int height) {
        this.minSize = new Point(width, height);
        if (this.viewer != null) {
            this.applyMinimumSize();
        }
    }

    private void applyMinimumSize() {
        if (this.minSize != null) {
            GridData gd = (GridData)this.viewer.getControl().getLayoutData();
            gd.widthHint = this.minSize.x;
            gd.heightHint = this.minSize.y;
        }
    }

    protected void updateEnabledState() {
        this.getControl().setEnabled(this.isEnabled());
        super.updateEnabledState();
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1, int var2, FormWidgetFactory var3);

    protected void selectionChanged(IStructuredSelection selection) {
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
    }
}

