/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementLink;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NamedElementsSection
extends FormSection
implements IDisposable {
    protected IEditorExtension editorExtension;
    protected int destinationPage;
    private String moreButtonToolTip;
    protected FormWidgetFactory factory;
    protected Composite hyperlinksParent;
    private NamedElementListAdapter adapter;

    public NamedElementsSection(IEditorExtension editorExtension, int destinationPage) {
        this.editorExtension = editorExtension;
        this.destinationPage = destinationPage;
        this.moreButtonToolTip = "";
    }

    public void dispose() {
        this.editorExtension = null;
        this.factory = null;
        this.hyperlinksParent = null;
        if (this.adapter != null) {
            if (this.adapter.getTarget() != null) {
                this.adapter.getTarget().eAdapters().remove((Object)this.adapter);
            }
            this.adapter.dispose();
        }
        super.dispose();
    }

    public void setMoreButtonToolTip(String text) {
        this.moreButtonToolTip = text == null ? "" : text;
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = factory.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)GridDataUtil.createFill());
        this.hyperlinksParent = factory.createComposite(container);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 2;
        this.hyperlinksParent.setLayout((Layout)gridLayout);
        this.hyperlinksParent.setLayoutData((Object)GridDataUtil.createFill());
        Composite buttonContainer = factory.createComposite(container);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        buttonContainer.setLayout((Layout)gridLayout);
        Button moreButton = factory.createButton(buttonContainer, TestUIPlugin.getString("ACT_MORE"), 8);
        moreButton.setLayoutData((Object)new GridData(130));
        moreButton.setToolTipText(this.moreButtonToolTip);
        moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedElementsSection.this.editorExtension.getHyadesEditorPart().setActivePage(NamedElementsSection.this.destinationPage);
            }
        });
        return container;
    }

    public void initialize(EObject container, EStructuralFeature namedElementFeature, String statusLinePrefix) {
        if (!CommonPackage.eINSTANCE.getCMNNamedElement().isSuperTypeOf((EClass)namedElementFeature.getEType())) {
            return;
        }
        if (!namedElementFeature.isMany()) {
            return;
        }
        this.adapter = new NamedElementListAdapter(namedElementFeature, statusLinePrefix);
        container.eAdapters().add((Object)this.adapter);
        this.adapter.setTarget((Notifier)container);
        this.adapter.refreshComposite(container);
    }

    public Control createControl(Composite parent, FormWidgetFactory factory, String headerText, String headerDescription) {
        this.setCollapsable(true);
        this.setHeaderText(headerText);
        this.setDescription(headerDescription);
        Control control = this.createControl(parent, factory);
        control.setLayoutData((Object)new GridData(1810));
        return control;
    }

    private class NamedElementListAdapter
    extends AdapterImpl
    implements IDisposable {
        private EStructuralFeature feature;
        private String statusLinePrefix;

        public NamedElementListAdapter(EStructuralFeature feature, String statusLinePrefix) {
            this.feature = feature;
            this.statusLinePrefix = statusLinePrefix;
        }

        public void dispose() {
            this.feature = null;
            this.setTarget(null);
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() != this.feature) {
                return;
            }
            switch (msg.getEventType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.refreshComposite((EObject)msg.getNotifier());
                }
            }
        }

        protected void refreshComposite(EObject notifier) {
            this.disposeChildren(NamedElementsSection.this.hyperlinksParent);
            EList namedElements = (EList)notifier.eGet(this.feature);
            Iterator i = namedElements.iterator();
            while (i.hasNext()) {
                NamedElementLink link = new NamedElementLink(NamedElementsSection.this.editorExtension, NamedElementsSection.this.destinationPage);
                link.setHoverMessagePrefix(this.statusLinePrefix);
                link.create(NamedElementsSection.this.factory, NamedElementsSection.this.hyperlinksParent, (CMNNamedElement)i.next());
            }
            NamedElementsSection.this.hyperlinksParent.pack(true);
            Composite parent = NamedElementsSection.this.hyperlinksParent.getParent();
            parent.setSize(parent.computeSize(parent.getSize().x, -1));
            parent.getParent().setSize(parent.getParent().computeSize(parent.getParent().getSize().x, -1));
        }

        protected void disposeChildren(Composite parent) {
            Control[] children = parent.getChildren();
            int i = 0;
            int maxi = children.length;
            while (i < maxi) {
                children[i].dispose();
                ++i;
            }
        }
    }
}

