/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExecutionContentProvider
implements ITreeContentProvider,
IDisposable {
    private ResourceSet resourceSet;
    private Map elementDescriptionByFileExtension;
    private boolean showEMFResource;
    private boolean showEnabledChildren = true;

    public ExecutionContentProvider(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.elementDescriptionByFileExtension = new HashMap();
        this.showEMFResource = false;
    }

    public void dispose() {
        this.elementDescriptionByFileExtension.clear();
    }

    public void addElementDescription(ElementDescription elementDescription) {
        this.elementDescriptionByFileExtension.put(elementDescription.getFileExtension(), elementDescription);
    }

    public boolean isShowEMFResource() {
        return this.showEMFResource;
    }

    public void setShowEMFResource(boolean showEMFResource) {
        this.showEMFResource = showEMFResource;
    }

    public boolean isShowEnabledChildren() {
        return this.showEnabledChildren;
    }

    public void setShowEnabledChildren(boolean showEnabledChildren) {
        this.showEnabledChildren = showEnabledChildren;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof Resource) {
            return EMFUtil.getParent((Resource)element);
        }
        if (element instanceof TPFExecutionResult && ((TPFExecutionResult)element).eContainer() == null) {
            return ((TPFExecutionResult)element).getTest();
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            if (eObject.eContainer() != null) {
                return eObject.eContainer();
            }
            if (this.isShowEMFResource()) {
                return eObject.eResource();
            }
            return EMFUtil.getParent(eObject.eResource());
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<IProject> children = new ArrayList<IProject>();
        if (inputElement instanceof IWorkspaceRoot) {
            children.addAll(Arrays.asList(((IWorkspaceRoot)inputElement).getProjects()));
        }
        children.addAll(NavigatorExtensionUtil.getAllChildren((Object)inputElement, (String)"org.eclipse.hyades.test.ui.ExecutionNavigator"));
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        if (NavigatorExtensionUtil.hasChildren((Object)element, (String)"org.eclipse.hyades.test.ui.ExecutionNavigator")) {
            return true;
        }
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            if (!container.exists()) {
                return false;
            }
            IResource[] resources = null;
            try {
                resources = container.members();
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
                return false;
            }
            int i = 0;
            int maxi = resources.length;
            while (i < maxi) {
                if (resources[i].getType() != 1) {
                    return true;
                }
                ElementDescription elementDescription = (ElementDescription)this.elementDescriptionByFileExtension.get(resources[i].getFileExtension());
                if (elementDescription != null) {
                    EObject[] eObjects = EMFUtil.load(this.resourceSet, (IFile)resources[i]);
                    Iterator iter = elementDescription.getEClassifiers().iterator();
                    while (iter.hasNext()) {
                        if (EcoreUtil.getObjectByType(Arrays.asList(eObjects), (EClassifier)((EClassifier)iter.next())) == null) continue;
                        return true;
                    }
                }
                ++i;
            }
        } else {
            if (element instanceof Resource) {
                return !((Resource)element).getContents().isEmpty();
            }
            if (element instanceof TPFTest) {
                return ExecutionUtil.findExecutionResults((TPFTest)((TPFTest)element)).size() > 0;
            }
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof IContainer) {
            IResource[] resources = null;
            try {
                resources = ((IContainer)parentElement).members();
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
                children.addAll(NavigatorExtensionUtil.getAllChildren((Object)parentElement, (String)"org.eclipse.hyades.test.ui.ExecutionNavigator"));
                return children.toArray();
            }
            int i = 0;
            int maxi = resources.length;
            while (i < maxi) {
                if (resources[i].getType() != 1) {
                    children.add(resources[i]);
                } else {
                    ElementDescription elementDescription = (ElementDescription)this.elementDescriptionByFileExtension.get(resources[i].getFileExtension());
                    if (elementDescription != null) {
                        EObject[] eObjects = EMFUtil.load(this.resourceSet, (IFile)resources[i]);
                        Iterator iter = elementDescription.getEClassifiers().iterator();
                        while (iter.hasNext()) {
                            Collection validObjects = EcoreUtil.getObjectsByType(Arrays.asList(eObjects), (EClassifier)((EClassifier)iter.next()));
                            if (this.isShowEMFResource()) {
                                Iterator iter2 = validObjects.iterator();
                                while (iter2.hasNext()) {
                                    children.add(((EObject)iter2.next()).eResource());
                                }
                                continue;
                            }
                            children.addAll(validObjects);
                        }
                    }
                }
                ++i;
            }
        } else if (parentElement instanceof Resource) {
            children.addAll((Collection<Object>)((Resource)parentElement).getContents());
        } else if (parentElement instanceof TPFTest) {
            children.addAll(ExecutionUtil.findExecutionResults((TPFTest)((TPFTest)parentElement)));
        }
        children.addAll(NavigatorExtensionUtil.getAllChildren((Object)parentElement, (String)"org.eclipse.hyades.test.ui.ExecutionNavigator"));
        return children.toArray();
    }

    public static class ElementDescription {
        private String fileExtension;
        private List eClassifiers;

        public ElementDescription(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public List getEClassifiers() {
            if (this.eClassifiers == null) {
                this.eClassifiers = new UniqueEList();
            }
            return this.eClassifiers;
        }
    }
}

