/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementFactoryManager;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class DefaultExecutionResultProxyNode
extends TypedElementProxyNode
implements IExecutionResultProxyNode {
    private IProxyNode[] children;

    public DefaultExecutionResultProxyNode(TPFExecutionResult er, Object parent) {
        super(er, parent);
        LinkedList c = new LinkedList();
        TPFExecutionHistory history = er.getExecutionHistory();
        if (history != null) {
            EList events = history.getExecutionEvents();
            Iterator it = events.iterator();
            while (it.hasNext()) {
                this.getEventChildren((TPFExecutionEvent)it.next(), c, er);
            }
        }
        this.children = c.toArray(new IProxyNode[c.size()]);
        String name = er.getName() != null ? er.getName() : "unamed";
        TPFTest test = er.getTest();
        if (test != null && test.getName() != null) {
            if (test instanceof TPFTestSuite) {
                if (er.getExecutionHistory().getExecutionEvents() != null && er.getExecutionHistory().getExecutionEvents().size() > 0) {
                    long timeStamp = ((TPFExecutionEvent)er.getExecutionHistory().getExecutionEvents().get(0)).getTimestamp();
                    String dateStamp = EventUtil.getTime(timeStamp);
                    name = name + " [" + dateStamp + "]";
                }
            } else {
                name = name + " [" + test.getName() + "]";
            }
        }
        this.setName(name);
    }

    public DefaultExecutionResultProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
        IMemento[] childrenMemento = memento.getChildren("childNode");
        int i = 0;
        while (i < childrenMemento.length) {
            IMemento mementoChild = childrenMemento[i];
            String type = mementoChild.getString("type");
            if (type == null) {
                throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve type field");
            }
            ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
            if (factory instanceof IPersistableTypedElementProxyFactory) {
                ((IPersistableTypedElementProxyFactory)factory).recreate(mementoChild, this);
            }
            ++i;
        }
    }

    private void getEventChildren(TPFExecutionEvent event, List c, TPFExecutionResult parent) {
        if (event instanceof TPFInvocationEvent) {
            TPFExecutionResult er = ((TPFInvocationEvent)event).getInvokedExecutionResult();
            c.add(new DefaultExecutionResultProxyNode(er, (Object)parent));
        } else {
            Iterator iterator = event.getChildren().iterator();
            while (iterator.hasNext()) {
                this.getEventChildren((TPFExecutionEvent)iterator.next(), c, parent);
            }
        }
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("execution_obj.gif");
    }

    public IProxyNode[] getChildren() {
        return this.children;
    }

    public TPFExecutionResult getExecutionResult() {
        EObject exec = EMFUtil.getResourceSet().getEObject(this.getOriginatorURI(), true);
        if (exec instanceof TPFExecutionResult) {
            return (TPFExecutionResult)exec;
        }
        return null;
    }
}

