/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ArtifactFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DatapoolFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DeploymentFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ExecutionFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.LocationFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestComponentFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestSuiteFileProxyNode;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.HyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;

public class EMFResourceProxyFactory
implements IFileProxyFactory,
IPersistableFileProxyFactory {
    private FileProxyNode createFileProxy(IFile file, Resource resource) {
        FileProxyNode fileProxy = null;
        String extension = file.getFileExtension();
        String fileName = file.getName();
        fileName = fileName.substring(0, fileName.length() - extension.length() - 1);
        fileProxy = extension != null ? (extension.equals("artifact") ? new ArtifactFileProxyNode(file, resource) : (extension.equals("datapool") ? new DatapoolFileProxyNode(file, resource) : (extension.equals("location") ? new LocationFileProxyNode(file, resource) : (extension.equals("deploy") ? new DeploymentFileProxyNode(file, resource) : (extension.equals("testsuite") ? new TestSuiteFileProxyNode(file, resource) : (extension.equals("testcomponent") ? new TestComponentFileProxyNode(file, resource) : (extension.equals("execution") ? new ExecutionFileProxyNode(file, resource) : null))))))) : null;
        return fileProxy != null && fileProxy.getChildren().length > 0 ? fileProxy : null;
    }

    private boolean isLoaded(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        ResourceSet rs = EMFUtil.getResourceSet();
        return rs.getResource(uri, false) != null;
    }

    private Resource getEMFResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        ResourceSet rs = EMFUtil.getResourceSet();
        return rs.getResource(uri, true);
    }

    public IProxyNode create(IFile file) {
        IProxyNode res = null;
        boolean wasAlreadyLoaded = this.isLoaded(file);
        Resource resource = this.getEMFResource(file);
        if (resource != null) {
            EObject[] eObjects = (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
            if (eObjects.length != 0) {
                res = eObjects.length == 1 ? HyadesProxyNodeFactory.getInstance().create(eObjects[0], file.getParent()) : this.createFileProxy(file, resource);
            }
            if (!wasAlreadyLoaded) {
                resource.unload();
            }
        }
        return res;
    }

    public IProxyNode recreate(IFile file, IMemento memento) {
        IProxyNode proxy = HyadesProxyNodeFactory.getInstance().recreate(memento, file.getParent());
        if (proxy == null) {
            String nodeKind = memento.getString("nodeKind");
            if (nodeKind.equals("artifactFileNode")) {
                return new ArtifactFileProxyNode(file, memento.getString("name"), memento.getChildren("childNode"));
            }
            if (nodeKind.equals("datapoolFileNode")) {
                return new DatapoolFileProxyNode(file, memento.getString("name"), memento.getChildren("childNode"));
            }
            if (nodeKind.equals("deployFileNode")) {
                return new DeploymentFileProxyNode(file, memento.getString("name"), memento.getChildren("childNode"));
            }
            if (nodeKind.equals("executionFileNode")) {
                return new ExecutionFileProxyNode(file, memento.getString("name"), memento.getChildren("childNode"));
            }
            if (nodeKind.equals("locationFileNode")) {
                return new LocationFileProxyNode(file, memento.getString("name"), memento.getChildren("childNode"));
            }
            if (nodeKind.equals("testComponentFileNode")) {
                return new TestComponentFileProxyNode(file, memento.getString("name"), memento.getChildren("childNode"));
            }
            if (nodeKind.equals("testSuiteFileNode")) {
                return new TestSuiteFileProxyNode(file, memento.getString("name"), memento.getChildren("childNode"));
            }
        } else {
            return proxy;
        }
        return null;
    }
}

