/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileFactoryManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementFactoryManager;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class FileProxyManager {
    private static final String TAG_PROXY_STATE = "proxyState";
    private static final String TAG_LAST_SAVE_STAMP = "lastSaveStamp";
    private static final String MARKER_PROXYSTATE = "org.eclipse.hyades.test.ui.proxyStateMarker";
    private static FileProxyManager instance;
    private HashMap proxies = new HashMap();

    public static FileProxyManager getInstance() {
        if (instance == null) {
            instance = new FileProxyManager();
        }
        return instance;
    }

    private FileProxyManager() {
    }

    public IProxyNode getProxy(IFile file) {
        if (this.isaKnownFile(file)) {
            return (IProxyNode)this.proxies.get(file);
        }
        IProxyNode proxy = this.loadProxyState(file);
        if (proxy == null) {
            proxy = this.updateProxy(file);
        }
        return proxy;
    }

    private IProxyNode loadProxyState(IFile file) {
        try {
            if (!file.exists()) {
                return null;
            }
            IMarker[] markers = file.findMarkers(MARKER_PROXYSTATE, false, 0);
            if (markers.length > 0) {
                String proxyState;
                StringReader reader;
                XMLMemento memento;
                long lastSaveStamp;
                long currentModStamp = file.getModificationStamp();
                String stamp = markers[0].getAttribute(TAG_LAST_SAVE_STAMP, null);
                long l = lastSaveStamp = stamp != null ? Long.parseLong(stamp) : 0L;
                if (currentModStamp != lastSaveStamp) {
                    return null;
                }
                String factoryID = markers[0].getAttribute("factoryID", null);
                IProxyNode proxy = this.buildProxy(file, factoryID, (IMemento)(memento = XMLMemento.createReadRoot((Reader)(reader = new StringReader(proxyState = markers[0].getAttribute(TAG_PROXY_STATE, null))))));
                if (proxy != null) {
                    this.proxies.put(file, proxy);
                }
                return proxy;
            }
            return null;
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return null;
        }
    }

    private IProxyNode buildProxy(IFile file, String factoryID, IMemento memento) {
        IFileProxyFactory factory = FileFactoryManager.getInstance().getFactory(factoryID);
        if (factory != null) {
            if (factory instanceof IPersistableFileProxyFactory) {
                try {
                    return ((IPersistableFileProxyFactory)factory).recreate(file, memento);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            TestUIPlugin.logError("The factory id: " + factoryID + " should be instanceof IPersistableFileProxyFactory");
            return null;
        }
        ITypedElementProxyFactory fact = TypedElementFactoryManager.getInstance().getFactoryFromID(factoryID);
        if (fact != null) {
            if (fact instanceof IPersistableTypedElementProxyFactory) {
                try {
                    return ((IPersistableTypedElementProxyFactory)fact).recreate(memento, file.getParent());
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            TestUIPlugin.logError("The factory id: " + factoryID + " should be instanceof IPersistableTypedElementProxyFactory");
            return null;
        }
        TestUIPlugin.logError("The persisted proxy for file: " + file.getName() + " contains an unknown factory ID");
        return null;
    }

    private void saveProxyState(IFile file, IPersistableProxyNode proxy) {
        StringWriter writer = new StringWriter();
        XMLMemento memento = XMLMemento.createWriteRoot((String)"proxyStateMemento");
        proxy.saveState((IMemento)memento);
        try {
            memento.save((Writer)writer);
        }
        catch (Exception e) {
            TestUIPlugin.logError(e);
        }
        class UpdateMarkerJob
        extends Job {
            private IFile _file;
            private IPersistableProxyNode _proxy;
            private StringWriter _writer;
            private final /* synthetic */ FileProxyManager this$0;

            public UpdateMarkerJob(FileProxyManager this$0, IFile _file, IPersistableProxyNode _proxy, StringWriter _writer) {
                super("update marker for file proxy");
                this.this$0 = this$0;
                this._file = _file;
                this._proxy = _proxy;
                this._writer = _writer;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    this._file.deleteMarkers("org.eclipse.hyades.test.ui.proxyStateMarker", false, 0);
                    IMarker marker = this._file.createMarker("org.eclipse.hyades.test.ui.proxyStateMarker");
                    marker.setAttribute("lastSaveStamp", (Object)Long.toString(this._file.getModificationStamp()));
                    marker.setAttribute("factoryID", (Object)this._proxy.getFactoryID());
                    marker.setAttribute("proxyState", (Object)this._writer.toString());
                    return new Status(0, TestUIPlugin.getID(), 0, "ok", null);
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    return new Status(4, TestUIPlugin.getID(), 0, "unable to update marker for file: " + this._file.getName(), (Throwable)e);
                }
            }
        }
        UpdateMarkerJob job = new UpdateMarkerJob(this, file, proxy, writer);
        job.setRule((ISchedulingRule)file);
        job.schedule();
    }

    public boolean isaKnownFile(IFile file) {
        return this.proxies.containsKey(file);
    }

    public IProxyNode updateProxy(IFile file) {
        IProxyNode proxy = null;
        ArrayList factories = FileFactoryManager.getInstance().getFactories(file.getFileExtension());
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            IFileProxyFactory factory = (IFileProxyFactory)it.next();
            proxy = factory.create(file);
            if (proxy != null) break;
        }
        if (proxy != null) {
            this.proxies.put(file, proxy);
        }
        if (proxy instanceof IPersistableProxyNode) {
            this.saveProxyState(file, (IPersistableProxyNode)proxy);
        }
        return proxy;
    }

    public IProxyNode findProxyByID(IProxyNode proxy, String uid) {
        if (proxy == null) {
            return proxy;
        }
        if (uid.length() > 0) {
            if (proxy.getIdentifier().equals(uid)) {
                return proxy;
            }
            IProxyNode[] children = proxy.getChildren();
            int i = 0;
            while (i < children.length) {
                proxy = this.findProxyByID(children[i], uid);
                if (proxy != null) {
                    return proxy;
                }
                ++i;
            }
            return null;
        }
        return proxy;
    }

    public IProxyNode removeProxy(IFile file) {
        return (IProxyNode)this.proxies.remove(file);
    }

    public IProxyNode getCorrespondingProxy(EObject object) {
        IFile file = EMFUtil.getWorkspaceFile(object);
        if (file == null) {
            return null;
        }
        IProxyNode fileProxy = FileProxyManager.getInstance().getProxy(file);
        return FileProxyManager.getInstance().findProxyByID(fileProxy, EMFUtil.getObjectURI(object).fragment());
    }

    public IProxyNode getCorrespondingProxy(String fileName, String identifier) {
        Set keys = this.proxies.keySet();
        IProxyNode root = null;
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            IFile file = (IFile)it.next();
            if (!fileName.equals(file.getLocation().toOSString())) continue;
            root = (IProxyNode)this.proxies.get(file);
            break;
        }
        if (root != null) {
            return FileProxyManager.getInstance().findProxyByID(root, identifier);
        }
        return null;
    }
}

