/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.util;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.util.RCPFileEditorInput;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TestUIUtil {
    public static String getUniqueName(String baseName, List namedElementList) {
        int id = namedElementList.size() + 1;
        String[] args = new String[]{baseName, Integer.toString(id)};
        String name = TestUIPlugin.getString("NME_CONCAT", args);
        Iterator i = namedElementList.iterator();
        while (i.hasNext()) {
            CMNNamedElement namedElement = (CMNNamedElement)i.next();
            if (!name.equals(namedElement.getName())) continue;
            args[1] = Integer.toString(++id);
            name = TestUIPlugin.getString("NME_CONCAT", args);
            i = namedElementList.iterator();
        }
        return name;
    }

    public static String validateExtension(String result, String extension) {
        if (result.lastIndexOf(".") == -1 || !result.substring(result.lastIndexOf(".") + 1, result.length()).equalsIgnoreCase(extension)) {
            return result + "." + extension;
        }
        return result;
    }

    public static IEditorPart openEditor(Resource resource, String editorId, boolean substring) {
        IFile file = EMFUtil.getWorkspaceFile(resource);
        if (file != null && file.exists()) {
            return UIUtil.openEditor((IFile)file, (String)editorId, (boolean)substring);
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = null;
        if (workbench.getActiveWorkbenchWindow() != null) {
            activePage = workbench.getActiveWorkbenchWindow().getActivePage();
        } else if (workbench.getWorkbenchWindows().length > 0) {
            activePage = workbench.getWorkbenchWindows()[0].getActivePage();
        }
        String location = EMFUtil.getFilePath(resource);
        File ioFile = new File(location);
        RCPFileEditorInput input = new RCPFileEditorInput(ioFile);
        if (editorId == null) {
            IEditorRegistry editorRegistry = workbench.getEditorRegistry();
            IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(ioFile.getName());
            editorId = descriptor != null ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
        }
        try {
            return activePage.openEditor((IEditorInput)input, editorId, substring);
        }
        catch (PartInitException e) {
            HyadesUIPlugin.logError((Throwable)e);
            return null;
        }
    }
}

