/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.ECMAScriptGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputConstants;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.PieChartDataRetriever;
import org.eclipse.hyades.ui.sample.svg.generator.SVGDocumentGenerator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGPieChart
extends SVGDocumentGenerator
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
IDataInputConstants,
Serializable {
    private final PieChartDataRetriever dataRetriever;
    private final int NINETY_DEG = 1;
    private final int NEGATIVE_NINETY_DEG = 2;
    private final int ONE_EIGHTY_DEG = 3;
    private final int ZERO_DEG = 4;

    public SVGPieChart() {
        this.graphicType = "pie";
        this.dataRetriever = new PieChartDataRetriever();
    }

    public Document generateGraphicDocument(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = this.createGraphicAttributes(input);
        Document newDataDocument = graphicAttrs.getDataDocument();
        int numberOfDatasets = 0;
        try {
            numberOfDatasets = this.dataRetriever.getNumberOfDatasets(newDataDocument);
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.graphicType);
            throw e;
        }
        DataRange dataRange = null;
        Object markers = null;
        DataSet[] dataSets = null;
        String[] legendFlyOverLabels = null;
        try {
            dataRange = this.dataRetriever.getDataRange(newDataDocument, "");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.graphicType);
            throw e;
        }
        dataSets = new DataSet[numberOfDatasets];
        int i = 0;
        while (i < numberOfDatasets) {
            dataSets[i] = this.dataRetriever.getDatasetWithPosition(newDataDocument, Integer.toString(i));
            ++i;
        }
        legendFlyOverLabels = this.getLegendFlyOverLabels(dataSets);
        double gWidth = graphicAttrs.getGraphicWidth();
        double gHeight = graphicAttrs.getGraphicHeight();
        int yOffset = (int)(gHeight * 0.152);
        if (!graphicAttrs.isLegendSuppressed()) {
            double maxAlloableLegendWidth;
            double maxLengthOfLegendLabel = this.getMaxLengthOfLegendLabel(graphicAttrs, dataSets);
            if (maxLengthOfLegendLabel > (maxAlloableLegendWidth = (double)(graphicAttrs.getGraphicWidth() / 3))) {
                maxLengthOfLegendLabel = maxAlloableLegendWidth;
            }
            gWidth -= maxLengthOfLegendLabel + 12.0;
        }
        double cx = gWidth * 0.5;
        double radius = gHeight >= gWidth ? gWidth * 0.245 : gHeight * 0.233;
        double cy = gHeight * 0.52;
        String translateString = "translate(" + cx + "," + cy + ")";
        Document generatedDocument = this.createSvgDocument(newDataDocument.getImplementation(), Short.toString(graphicAttrs.getGraphicWidth()), Short.toString(graphicAttrs.getGraphicHeight()));
        Element svgRoot = generatedDocument.getDocumentElement();
        this.registerEventHandler(svgRoot, "onload", "init(evt)");
        this.addDefinitions(generatedDocument, graphicAttrs, numberOfDatasets);
        this.addJavaScriptFunctions(generatedDocument, graphicAttrs, numberOfDatasets);
        if (!graphicAttrs.isOutlineSuppressed()) {
            this.addOutline(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isTimestampSuppressed()) {
            try {
                String timestamp = this.dataRetriever.getTimestamp(newDataDocument);
                Date date = GraphicAttributes.parseISO8601Date(timestamp);
                this.addTimeStamp(generatedDocument, graphicAttrs, date == null ? timestamp : graphicAttrs.formatDate(date));
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        if (!graphicAttrs.isTitlebarSuppressed()) {
            this.addTitleBar(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isUserPreferencesSuppressed() && graphicAttrs.getSvgFormatOnly()) {
            this.addPreferenceIcon(generatedDocument, graphicAttrs);
        }
        try {
            Hashtable titles = this.dataRetriever.getTitles(newDataDocument);
            this.addTitles(generatedDocument, graphicAttrs, svgRoot, titles, cx, yOffset);
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.graphicType);
            throw e;
        }
        Element gTextBoxElement = generatedDocument.createElement("g");
        this.addPieSlices(generatedDocument, graphicAttrs, svgRoot, dataSets, radius, cx, cy, translateString);
        if (!graphicAttrs.isLegendSuppressed()) {
            try {
                String[] legendLabels = this.dataRetriever.getLegendLabels(newDataDocument);
                this.addLegend(generatedDocument, graphicAttrs, gTextBoxElement, legendLabels, legendFlyOverLabels, (int)gWidth, yOffset);
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        svgRoot.appendChild(gTextBoxElement);
        return generatedDocument;
    }

    protected void addJavaScriptFunctions(Document generatedDocument, GraphicAttributes attrs, int numberOfSets) {
        Element parent = generatedDocument.getDocumentElement();
        super.addJavaScriptFunctions(generatedDocument, attrs, numberOfSets, 0, 0, 0, 0);
        Element newElement = generatedDocument.createElement("script");
        newElement.setAttribute("type", "text/ecmascript");
        parent.appendChild(newElement);
        ECMAScriptGenerator jscript = new ECMAScriptGenerator();
        StringBuffer functions = new StringBuffer(jscript.generatePieChartHelperFunctions());
        CDATASection newCDATASection = generatedDocument.createCDATASection(functions.toString());
        newElement.appendChild(newCDATASection);
    }

    private void addTitles(Document generatedDocument, GraphicAttributes attrs, Element parent, Hashtable input, double cx, int yOffset) {
        int rotation = 0;
        int xOffset = 10;
        Element gElement = generatedDocument.createElement("g");
        String title = null;
        title = (String)input.get("valueTitle");
        if (title != null) {
            gElement = generatedDocument.createElement("g");
            gElement.setAttribute("id", "labelsValues0");
            gElement.setAttribute("class", "labelsValues anchorAtMiddle");
            parent.appendChild(gElement);
            this.addLabel(generatedDocument, attrs, gElement, title, null, cx, (double)attrs.getGraphicHeight() * 0.9, rotation);
        }
        if ((title = (String)input.get("totalTitle")) != null) {
            gElement = generatedDocument.createElement("g");
            gElement.setAttribute("id", "labelsValues1");
            gElement.setAttribute("class", "legendTitle anchorAtStart");
            parent.appendChild(gElement);
            this.addLabel(generatedDocument, attrs, gElement, title, null, xOffset, yOffset + 10, rotation);
        }
    }

    private void addDefaultInternalStylesheet(Document generatedDocument, GraphicAttributes attrs, Element parent, int sets) {
        StringBuffer styleRules = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        styleRules.append(" ");
        styleRules.append(" .pievalues{stroke:none; font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor: middle;}.wedgeTick{fill:none;} .wedgeOutline{fill:none;} .wedgeColor{fill:#CCCCCC;stroke:none;}");
        String[] palette = (String[])attrs.getGraphicColorPalette().get(attrs.getGraphicColorPaletteName());
        int paletteLength = palette.length;
        int i = 0;
        int j = 0;
        while (i < sets) {
            j = (i + 1) % paletteLength;
            j = j == 0 ? paletteLength - 1 : j - 1;
            styleRules.append(" .dataset" + i + "{stroke:black; fill:" + palette[j] + ";}");
            if (!attrs.isLegendSuppressed()) {
                styleRules.append(" .shape" + i + "{stroke:none; fill:" + palette[j] + ";}");
            }
            ++i;
        }
        CDATASection newCDATASection = generatedDocument.createCDATASection(styleRules.toString());
        Element newElement = generatedDocument.createElement("style");
        newElement.setAttribute("id", "defaultStyleRules");
        newElement.setAttribute("type", "text/css");
        newElement.appendChild(newCDATASection);
        parent.appendChild(newElement);
    }

    private void addDefinitions(Document generatedDocument, GraphicAttributes attrs, int numberOfDatasets) {
        Element defsElement = super.addDefinitions(generatedDocument, attrs);
        this.addDefaultInternalStylesheet(generatedDocument, attrs, defsElement, numberOfDatasets);
        Element gElement_tick = generatedDocument.createElement("g");
        gElement_tick.setAttribute("id", "tickline");
        Element tickElement = generatedDocument.createElement("polyline");
        tickElement.setAttribute("class", "grid");
        tickElement.setAttribute("points", "0 0 8 0");
        gElement_tick.appendChild(tickElement);
        defsElement.appendChild(gElement_tick);
    }

    private void addPieSlices(Document generatedDocument, GraphicAttributes attrs, Element parent, DataSet[] dataSets, double radius, double cx, double cy, String translateString) {
        double pieValue = 0.0;
        double sliceValue = 0.0;
        double percent = 0.0;
        double degree = 0.0;
        double previousDegree = 0.0;
        double radian = 0.0;
        double xPosition = 0.0;
        double yPosition = 0.0;
        Element gToggleValueElement = generatedDocument.createElement("g");
        gToggleValueElement.setAttribute("id", "exactValues");
        gToggleValueElement.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
        gToggleValueElement.setAttribute("visibility", "hidden");
        parent.appendChild(gToggleValueElement);
        Element gTogglePercentElement = generatedDocument.createElement("g");
        gTogglePercentElement.setAttribute("id", "percentValues");
        gTogglePercentElement.setAttribute("onclick", "toggleVisibility(\"percentValues\")");
        gTogglePercentElement.setAttribute("visibility", "hidden");
        parent.appendChild(gTogglePercentElement);
        Element gToggleBothValuesElement = generatedDocument.createElement("g");
        gToggleBothValuesElement.setAttribute("id", "bothValues");
        gToggleBothValuesElement.setAttribute("onclick", "toggleVisibility(\"bothValues\")");
        parent.appendChild(gToggleBothValuesElement);
        int i = 0;
        while (i < dataSets.length) {
            pieValue += dataSets[i].getTotal();
            ++i;
        }
        int i2 = 0;
        while (i2 < dataSets.length) {
            sliceValue = dataSets[i2].getTotal();
            percent = pieValue > 0.0 ? sliceValue / pieValue : 0.0;
            degree = percent * 360.0;
            radian = degree * 0.01745329252;
            xPosition = Math.cos(radian) * radius;
            yPosition = Math.sin(radian) * radius;
            String path = "M " + radius + " 0 ";
            if (degree == 360.0) {
                path = path + " A " + radius + " " + radius + " 0 0 0 " + -radius + " 0 " + " A " + radius + " " + radius + " 0 0 0 " + radius + " 0 ";
            } else if (degree != 0.0) {
                path = path + " A " + radius + " " + radius + " 0 " + (degree < 180.0 ? 0 : 1) + " 0 " + xPosition + " " + -yPosition;
            }
            path = path + " L 0 0  Z";
            String transformation = i2 == 0 ? translateString : translateString + " rotate(-" + previousDegree + ")";
            Element gColourElement = generatedDocument.createElement("g");
            gColourElement.setAttribute("id", "pieColour" + i2);
            gColourElement.setAttribute("class", "dataset" + i2);
            gColourElement.setAttribute("onclick", "toggleVisibility(\"pieColour\");");
            parent.appendChild(gColourElement);
            Element newElement = generatedDocument.createElement("path");
            newElement.setAttribute("transform", transformation);
            newElement.setAttribute("d", path);
            gColourElement.appendChild(newElement);
            String percentageLabel = attrs.formatPercentage(percent);
            String sliceValueLabel = attrs.formatNumber(sliceValue);
            this.addLabels(generatedDocument, attrs, gToggleBothValuesElement, gToggleValueElement, gTogglePercentElement, i2, percentageLabel, degree, previousDegree, sliceValueLabel, radius, cx, cy, translateString);
            previousDegree += degree;
            ++i2;
        }
    }

    private void addLabels(Document generatedDocument, GraphicAttributes attrs, Element bothValuesElement, Element valueElement, Element percentElement, int index, String percentageLabel, double degree, double previous, String sliceValueLabel, double radius, double cx, double cy, String translateString) {
        double rad = (degree / 2.0 + previous) * 0.01745329252;
        double xpos = Math.cos(-1.0 * rad) * radius;
        double ypos = Math.sin(-1.0 * rad) * radius;
        String rotateString = "";
        int rotateFlag = 0;
        if (cy + ypos > cy && cy + ypos >= cy + 0.875 * radius) {
            rotateString = "rotate(90," + xpos + "," + ypos + ")";
            rotateFlag = 1;
        } else if (cy + ypos < cy && cy + ypos <= cy - 0.875 * radius) {
            rotateString = "rotate(-90," + xpos + "," + ypos + ")";
            rotateFlag = 2;
        } else if (cx + xpos < cx) {
            rotateString = "rotate(180," + xpos + "," + ypos + ")";
            rotateFlag = 3;
        } else {
            rotateFlag = 4;
        }
        Element newElement = generatedDocument.createElement("use");
        newElement.setAttribute("xlink:href", "#tickline");
        newElement.setAttribute("x", Double.toString(xpos));
        newElement.setAttribute("y", Double.toString(ypos));
        newElement.setAttribute("transform", translateString + rotateString);
        valueElement.appendChild(newElement);
        percentElement.appendChild(newElement);
        bothValuesElement.appendChild(newElement);
        String stylesheetClass = cx + xpos >= cx ? "pieValues anchorAtStart" : "pieValues anchorAtEnd";
        String label = percentageLabel + ",  " + sliceValueLabel;
        String percentLabel = percentageLabel;
        Vector labelPosVec = this.calculateLabelPositions(cx, xpos, ypos, rotateFlag, label);
        double labelXPos = Double.parseDouble(labelPosVec.firstElement().toString());
        double labelYPos = Double.parseDouble(labelPosVec.lastElement().toString());
        newElement = generatedDocument.createElement("text");
        newElement.setAttribute("x", Double.toString(labelXPos));
        newElement.setAttribute("y", Double.toString(-1.0 * labelYPos));
        newElement.setAttribute("transform", translateString);
        newElement.setAttribute("class", stylesheetClass + " shape" + index);
        newElement.appendChild(generatedDocument.createTextNode(percentLabel));
        percentElement.appendChild(newElement);
        newElement = generatedDocument.createElement("text");
        newElement.setAttribute("x", Double.toString(labelXPos));
        newElement.setAttribute("y", Double.toString(-1.0 * labelYPos));
        newElement.setAttribute("transform", translateString);
        newElement.setAttribute("class", stylesheetClass + " shape" + index);
        newElement.appendChild(generatedDocument.createTextNode(sliceValueLabel));
        valueElement.appendChild(newElement);
        newElement = generatedDocument.createElement("text");
        newElement.setAttribute("x", Double.toString(labelXPos));
        newElement.setAttribute("y", Double.toString(-1.0 * labelYPos));
        newElement.setAttribute("transform", translateString);
        newElement.setAttribute("class", stylesheetClass + " shape" + index);
        newElement.appendChild(generatedDocument.createTextNode(label));
        bothValuesElement.appendChild(newElement);
    }

    private Vector calculateLabelPositions(double cx, double xpos, double ypos, int rotateFlag, String label) {
        double labelXPos = 0.0;
        double labelYPos = 0.0;
        Vector<Double> labelVec = new Vector<Double>(2);
        if (cx + xpos < cx) {
            if (rotateFlag == 2) {
                labelXPos = xpos + 2.0;
                labelYPos = -ypos + 12.0;
            } else if (rotateFlag == 1) {
                labelXPos = xpos + 2.0;
                labelYPos = -ypos - 20.0;
            } else if (rotateFlag == 3) {
                labelXPos = xpos - 10.0;
                labelYPos = -ypos - 1.0;
            }
        } else if (rotateFlag == 2) {
            labelXPos = xpos - 3.0;
            labelYPos = -ypos + 12.0;
        } else if (rotateFlag == 1) {
            labelXPos = xpos - 3.0;
            labelYPos = -ypos - 20.0;
        } else if (rotateFlag == 4) {
            labelXPos = xpos + 10.0;
            labelYPos = -ypos - 1.0;
        }
        labelVec.add(new Double(labelXPos));
        labelVec.add(new Double(labelYPos));
        return labelVec;
    }

    private void getConfigAttributes(GraphicAttributes attrs) throws DataInputProcessingException {
        Hashtable configProperties = this.dataRetriever.getConfigurationAttributes(attrs.getConfigDocument(), attrs.getDataDocument());
        if (configProperties == null) {
            return;
        }
        String width = (String)configProperties.get("width");
        String height = (String)configProperties.get("height");
        String title = (String)configProperties.get("title");
        String timestampPrefix = (String)configProperties.get("timestampPrefix");
        String legendTitle = (String)configProperties.get("legendTitle");
        if (width != null) {
            attrs.setGraphicWidth(width);
        }
        if (height != null) {
            attrs.setGraphicHeight(height);
        }
        if (title != null) {
            attrs.setGraphicTitle(title);
        }
        if (timestampPrefix != null) {
            attrs.setGraphicTimestampPrefix(timestampPrefix);
        }
        if (legendTitle != null) {
            attrs.setGraphicLegendTitle(legendTitle);
        }
    }

    private GraphicAttributes createGraphicAttributes(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = new GraphicAttributes();
        graphicAttrs.setGraphicWidth("450");
        graphicAttrs.setPreferencesPage("prefs_pie.htm");
        graphicAttrs.setPreferencesPageWidth("430");
        graphicAttrs.setPreferencesPageHeight("460");
        graphicAttrs.setConfigDocument(input.getConfigDocument());
        graphicAttrs.setDataDocument(input.getDataDocument());
        this.getConfigAttributes(graphicAttrs);
        graphicAttrs.setAttributesFrom(input);
        return graphicAttrs;
    }
}

