/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.jvm.threadanalysis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpProcessor;

public class ThreadDumpProcessorImpl
implements ThreadDumpProcessor {
    private EventFactory _simpleEventFactory;
    private ComponentIdentification _compId;
    private Situation _situation;
    private AssociationEngine _associationEngine;

    public Vector generateCBEs(DumpData dumpData) {
        Vector vector = new Vector();
        AssociatedEvent associatedEvent = this._simpleEventFactory.createAssociatedEvent();
        this._compId.setComponent(dumpData.getDumpingJvmName());
        CommonBaseEvent commonBaseEvent = this.createCBE("ThreadDump", null, vector);
        commonBaseEvent.addExtendedDataElement("Type", "Java");
        commonBaseEvent.addExtendedDataElement("Description", dumpData.getDescription());
        commonBaseEvent.addExtendedDataElement("DisplayName", dumpData.getDisplayName());
        CommonBaseEvent commonBaseEvent2 = this.createCBE("Threads", commonBaseEvent, vector);
        ExtendedDataElement extendedDataElement = commonBaseEvent.addExtendedDataElementWithIntValue("Threads", dumpData.getThreads().size());
        this.addThreads(dumpData, extendedDataElement, commonBaseEvent2, vector);
        CommonBaseEvent commonBaseEvent3 = this.createCBE("Monitors", commonBaseEvent, vector);
        ExtendedDataElement extendedDataElement2 = commonBaseEvent.addExtendedDataElementWithIntValue("Monitors", dumpData.getMonitors().size());
        this.addMonitors(dumpData, extendedDataElement2, commonBaseEvent3, vector);
        return vector;
    }

    private CommonBaseEvent createCBE(String string, CommonBaseEvent commonBaseEvent, Vector vector) {
        CommonBaseEvent commonBaseEvent2 = this._simpleEventFactory.createCommonBaseEvent("CBE:" + string, new Date().getTime());
        commonBaseEvent2.setSeverity((short)10);
        commonBaseEvent2.setMsg(string);
        commonBaseEvent2.setSourceComponentId(this._compId);
        commonBaseEvent2.setSituation(this._situation);
        if (commonBaseEvent != null) {
            AssociatedEvent associatedEvent = this._simpleEventFactory.createAssociatedEvent();
            associatedEvent.setAssociationEngineInfo(this._associationEngine);
            associatedEvent.addResolvedEvent(commonBaseEvent2.getGlobalInstanceId());
            commonBaseEvent.addAssociatedEvent(associatedEvent);
        }
        vector.add(commonBaseEvent2);
        return commonBaseEvent2;
    }

    private void addThreads(DumpData dumpData, ExtendedDataElement extendedDataElement, CommonBaseEvent commonBaseEvent, Vector vector) {
        Thd thd;
        int n = 0;
        commonBaseEvent.addExtendedDataElementWithIntValue("Thread Count", dumpData.getThreads().size());
        Enumeration enumeration = dumpData.getThreadEnum();
        while ((thd = dumpData.getNextThread(enumeration)) != null) {
            this.createThreadCbe(commonBaseEvent, thd, n, vector);
            ++n;
        }
    }

    private ExtendedDataElement createThreadXde(ExtendedDataElement extendedDataElement, Thd thd, int n) {
        ExtendedDataElement extendedDataElement2 = extendedDataElement.addChildWithIntValue("Thread_" + n, n);
        extendedDataElement2.addChild("threadId", thd.getThreadId());
        extendedDataElement2.addChild("name", thd.getName());
        extendedDataElement2.addChild("priority", thd._priority);
        extendedDataElement2.addChild("state", thd._state);
        extendedDataElement2.addChildWithIntValue("waitMonitorID", thd.getWaitMonitorId());
        if (thd._waitMonitor != null) {
            extendedDataElement2.addChild("waitMonitorKey", thd._waitMonitor.getName());
        }
        ExtendedDataElement extendedDataElement3 = extendedDataElement2.addChildWithIntValue("StackEntries", thd.getStkSize());
        ExtendedDataElement extendedDataElement4 = extendedDataElement2.addChildWithIntValue("StackEntriesNative", thd.getStkNativeSize());
        this.addStackEntries(thd, extendedDataElement3);
        this.addStackEntriesNative(thd, extendedDataElement4);
        return extendedDataElement2;
    }

    private CommonBaseEvent createThreadCbe(CommonBaseEvent commonBaseEvent, Thd thd, int n, Vector vector) {
        CommonBaseEvent commonBaseEvent2 = this.createCBE("Thread" + n, commonBaseEvent, vector);
        commonBaseEvent2.addExtendedDataElementWithIntValue("Thread Index", n);
        commonBaseEvent2.addExtendedDataElement("threadId", thd.getThreadId());
        commonBaseEvent2.addExtendedDataElement("name", thd.getName());
        commonBaseEvent2.addExtendedDataElement("priority", thd._priority);
        commonBaseEvent2.addExtendedDataElement("state", thd._state);
        commonBaseEvent2.addExtendedDataElementWithIntValue("waitMonitorID", thd.getWaitMonitorId());
        if (thd._waitMonitor != null) {
            commonBaseEvent2.addExtendedDataElement("waitMonitorKey", thd._waitMonitor.getName());
        }
        ExtendedDataElement extendedDataElement = commonBaseEvent2.addExtendedDataElementWithIntValue("StackEntries", thd.getStkSize());
        ExtendedDataElement extendedDataElement2 = commonBaseEvent2.addExtendedDataElementWithIntValue("StackEntriesNative", thd.getStkNativeSize());
        this.addStackEntries(thd, extendedDataElement);
        this.addStackEntriesNative(thd, extendedDataElement2);
        return commonBaseEvent2;
    }

    private void addStackEntries(Thd thd, ExtendedDataElement extendedDataElement) {
        int n = 0;
        while (n < thd.getStkSize()) {
            StkEntry stkEntry = thd.getStkEntry(n);
            ExtendedDataElement extendedDataElement2 = extendedDataElement.addChildWithIntValue("StkEntry_" + n, n);
            extendedDataElement2.addChild("module", stkEntry._module);
            extendedDataElement2.addChild("pkg", stkEntry._pkg);
            extendedDataElement2.addChild("method", stkEntry._method);
            extendedDataElement2.addChildWithIntValue("lineno", stkEntry._lineno);
            extendedDataElement2.addChildWithBooleanValue("isNative", stkEntry._isNative);
            ++n;
        }
    }

    private void addStackEntriesNative(Thd thd, ExtendedDataElement extendedDataElement) {
        int n = 0;
        while (n < thd.getStkNativeSize()) {
            StkEntryNative stkEntryNative = thd.getStkEntryNative(n);
            ExtendedDataElement extendedDataElement2 = extendedDataElement.addChildWithIntValue("StkEntryNative_" + n, n);
            extendedDataElement2.addChild("function", stkEntryNative._function);
            extendedDataElement2.addChild("hexAddress", stkEntryNative._hexAddress);
            ++n;
        }
    }

    private void addMonitors(DumpData dumpData, ExtendedDataElement extendedDataElement, CommonBaseEvent commonBaseEvent, Vector vector) {
        Monitor monitor;
        int n = 0;
        commonBaseEvent.addExtendedDataElementWithIntValue("Monitor Count", dumpData.getMonitors().size());
        Enumeration enumeration = dumpData.getMonitorEnum();
        while ((monitor = dumpData.getNextMonitor(enumeration)) != null) {
            this.createMonitorCbe(commonBaseEvent, monitor, n, vector);
            ++n;
        }
    }

    private void createMonitorXde(ExtendedDataElement extendedDataElement, Monitor monitor, int n) {
        ExtendedDataElement extendedDataElement2 = extendedDataElement.addChildWithIntValue("Monitor" + n, n);
        int n2 = monitor._waiters.size();
        extendedDataElement2.addChild("name", monitor.getName());
        if (monitor._owner != null) {
            extendedDataElement2.addChild("ownerThreadId", monitor._owner._threadId);
            extendedDataElement2.addChild("ownerThreadName", monitor._owner.getName());
        }
        extendedDataElement2.addChildWithIntValue("monitor_type", monitor._monitor_type);
        if (n2 > 0) {
            ExtendedDataElement extendedDataElement3 = extendedDataElement2.addChildWithIntValue("Waiters", n2);
            this.addWaiters(monitor, extendedDataElement3);
        }
    }

    private void createMonitorCbe(CommonBaseEvent commonBaseEvent, Monitor monitor, int n, Vector vector) {
        CommonBaseEvent commonBaseEvent2 = this.createCBE("Monitor" + n, commonBaseEvent, vector);
        int n2 = monitor._waiters.size();
        commonBaseEvent2.addExtendedDataElementWithIntValue("Monitor Index", n);
        commonBaseEvent2.addExtendedDataElement("name", monitor.getName());
        if (monitor._owner != null) {
            commonBaseEvent2.addExtendedDataElement("ownerThreadId", monitor._owner._threadId);
            commonBaseEvent2.addExtendedDataElement("ownerThreadName", monitor._owner.getName());
        }
        commonBaseEvent2.addExtendedDataElementWithIntValue("monitor_type", monitor._monitor_type);
        if (n2 > 0) {
            ExtendedDataElement extendedDataElement = commonBaseEvent2.addExtendedDataElementWithIntValue("Waiters", n2);
            this.addWaiters(monitor, extendedDataElement);
        }
    }

    private void addWaiters(Monitor monitor, ExtendedDataElement extendedDataElement) {
        Vector vector = monitor._waiters;
        int n = monitor._waiters.size();
        int n2 = 0;
        while (n2 < n) {
            Thd thd = (Thd)vector.elementAt(n2);
            ExtendedDataElement extendedDataElement2 = extendedDataElement.addChildWithIntValue("Waiter_" + n2, n2);
            extendedDataElement2.addChild("ThreadId", thd.getThreadId());
            extendedDataElement2.addChild("ThreadName", thd.getName());
            ++n2;
        }
    }

    public ThreadDumpProcessorImpl() {
        String string = null;
        this._simpleEventFactory = EventFactoryContext.getInstance().getSimpleEventFactoryHome().getAnonymousEventFactory();
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        try {
            ReportSituation reportSituation = this._simpleEventFactory.createReportSituation();
            reportSituation.setReportCategory("Trace");
            this._situation = this._simpleEventFactory.createSituation();
            this._situation.setCategoryName("ReportSituation");
            this._situation.setSituationType((SituationType)reportSituation);
            this._compId = this._simpleEventFactory.createComponentIdentification();
            this._compId.setComponentIdType("ProductName");
            this._compId.setComponent("Dummy");
            this._compId.setComponentType("JAVA JVM");
            this._compId.setSubComponent("Thread/Monitor dump");
            this._compId.setLocationType("Hostname");
            this._compId.setLocation(string);
            this._associationEngine = this._simpleEventFactory.createAssociationEngine();
            this._associationEngine.setType("Root");
            this._associationEngine.setName("Root");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

