/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.jface.viewers.IStructuredSelection;

public class TIUtils {
    private static final boolean unitTestDebug = false;

    public static void searchTRCProcesses(EObject object, TraceProcesses list, IProgressMonitor monitor) {
        EList invocations;
        TRCAgent agent;
        TRCProcess process;
        if (monitor.isCanceled()) {
            return;
        }
        if (object instanceof TRCMonitor) {
            TRCMonitor m = (TRCMonitor)object;
            if (m.getNodes() == null || m.getNodes().isEmpty()) {
                return;
            }
            Iterator i = m.getNodes().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TIUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCNode) {
            TRCNode n = (TRCNode)object;
            if (n.getProcessProxies() == null || n.getProcessProxies().isEmpty()) {
                return;
            }
            Iterator i = n.getProcessProxies().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TIUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy pp = (TRCProcessProxy)object;
            if (pp.getAgentProxies() == null || pp.getAgentProxies().isEmpty()) {
                return;
            }
            Iterator i = pp.getAgentProxies().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TIUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler") && (process = TraceUtils.getProcess((TRCAgent)(agent = ((TRCAgentProxy)object).getAgent()))) != null && (invocations = process.getInvocations()) != null && invocations.size() > 0 && invocations.get(0) instanceof TRCFullMethodInvocation) {
            list.add(new TraceProcess(process));
        }
    }

    public static List getProfileAgents(TRCProcessProxy processProxy) {
        ArrayList<TRCAgentProxy> profileAgents = new ArrayList<TRCAgentProxy>();
        if (processProxy != null) {
            EList agents = processProxy.getAgentProxies();
            TRCAgentProxy agentProxy = null;
            Iterator iterator = agents.iterator();
            while (iterator.hasNext()) {
                agentProxy = (TRCAgentProxy)iterator.next();
                if (!"Profiler".equals(agentProxy.getType())) continue;
                profileAgents.add(agentProxy);
            }
        }
        return profileAgents;
    }

    public static double getAbsoluteEntryTime(TRCFullMethodInvocation methodInvocation) {
        return TIUtils.getAbsoluteEntryTime(methodInvocation.getProcess().getAgent()) + methodInvocation.getEntryTime();
    }

    public static double getAbsoluteEntryTime(TRCAgent agent) {
        double delta = agent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() * 1.0E-6;
        return delta + agent.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCProcess process) {
        return TIUtils.getAbsoluteEntryTime(process.getAgent()) + process.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCThread thread) {
        return TIUtils.getAbsoluteEntryTime(thread.getProcess().getAgent()) + thread.getStartTime();
    }

    public static double getAbsoluteExitTime(TRCFullMethodInvocation methodInvocation) {
        double start = TIUtils.getAbsoluteEntryTime(methodInvocation.getProcess().getAgent());
        if (methodInvocation.getExitTime() != 0.0) {
            return start + methodInvocation.getExitTime();
        }
        if (methodInvocation.getInvokes() == null || methodInvocation.getInvokes().size() == 0) {
            return TIUtils.getAbsoluteExitTime(methodInvocation.getThread());
        }
        TRCFullMethodInvocation lastCalled = (TRCFullMethodInvocation)methodInvocation.getInvokes().get(methodInvocation.getInvokes().size() - 1);
        if (lastCalled.getExitTime() == 0.0) {
            return TIUtils.getAbsoluteExitTime(lastCalled);
        }
        return start + lastCalled.getExitTime();
    }

    public static double getAbsoluteExitTime(TRCAgent agent) {
        double delta = agent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() * 1.0E-6;
        return delta + agent.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCProcess process) {
        if (process.getStopTime() == 0.0) {
            return TIUtils.getAbsoluteExitTime(process.getAgent());
        }
        return TIUtils.getAbsoluteEntryTime(process.getAgent()) + process.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCThread thread) {
        if (thread.getStopTime() == 0.0) {
            return TIUtils.getAbsoluteExitTime(thread.getProcess().getAgent());
        }
        return TIUtils.getAbsoluteEntryTime(thread.getProcess().getAgent()) + thread.getStopTime();
    }

    public static boolean doesAgentProxyStillExists(String agentProxyRuntimeId) {
        ArrayList monitors = PDContentProvider.getMonitors();
        Iterator i = monitors.iterator();
        while (i.hasNext()) {
            TRCMonitor monitor = (TRCMonitor)i.next();
            EList nodes = monitor.getNodes();
            Iterator j = nodes.iterator();
            while (j.hasNext()) {
                TRCNode node = (TRCNode)j.next();
                EList pps = node.getProcessProxies();
                Iterator k = pps.iterator();
                while (k.hasNext()) {
                    TRCProcessProxy pp = (TRCProcessProxy)k.next();
                    EList aps = pp.getAgentProxies();
                    Iterator l = aps.iterator();
                    while (l.hasNext()) {
                        TRCAgentProxy ap = (TRCAgentProxy)l.next();
                        if (!agentProxyRuntimeId.equals(ap.getRuntimeId())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean matchCharacter(char c1, char c2, boolean isCaseSensitive) {
        if (TraceSDPlugin.debugMatch) {
            // empty if block
        }
        return c1 == c2 || !isCaseSensitive && Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static boolean trailingStars(char[] s, int l) {
        int i = l;
        while (i < s.length && s[i] == '*') {
            ++i;
        }
        return i == s.length;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean matchCriteria(String s, Criteria criteria) {
        try {
            e = criteria.getExpression();
            ea = e.toCharArray();
            if (TraceSDPlugin.debugMatch) {
                // empty if block
            }
            i = 0;
            j = 0;
            while (i < s.length() && j < ea.length) {
                block22: {
                    block21: {
                        sc = s.charAt(i);
                        ec = ea[j];
                        if (TraceSDPlugin.debugMatch) {
                            // empty if block
                        }
                        if (ec == 42) {
                            if (j + 1 == ea.length) {
                                if (TraceSDPlugin.debugMatch) {
                                    // empty if block
                                }
                                return true;
                            }
                            if (ea[j + 1] == '?') {
                                ea[j] = 63;
                                ec = 63;
                                ea[j + 1] = 42;
                            }
                        }
                        if (ec != 42) break block21;
                        k = 1;
                        while (i + k - 1 < s.length() && j + k < ea.length) {
                            if (ea[j + k] == '*' || ea[j + k] == '?') {
                                j += k;
                                i += k - 2;
                                break;
                            }
                            if (!TIUtils.matchCharacter(s.charAt(i + k - 1), ea[j + k], criteria.isCaseSenstiveSelected())) break;
                            ++k;
                        }
                        if (TraceSDPlugin.debugMatch) {
                            // empty if block
                        }
                        if (i + k - 1 == s.length() && TIUtils.trailingStars(ea, j + k)) {
                            if (TraceSDPlugin.debugMatch) {
                                // empty if block
                            }
                            return true;
                        }
                        break block22;
                    }
                    if (ec != 63) ** GOTO lbl47
                    if (i + 1 < s.length() && j + 1 < ea.length) {
                        ++j;
                    } else {
                        if (TraceSDPlugin.debugMatch) {
                            // empty if block
                        }
                        return i + 1 == s.length() && TIUtils.trailingStars(ea, j + 1) != false;
lbl47:
                        // 1 sources

                        if (!TIUtils.matchCharacter(sc, (char)ec, criteria.isCaseSenstiveSelected())) {
                            if (TraceSDPlugin.debugMatch) {
                                // empty if block
                            }
                            return false;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (TraceSDPlugin.debugMatch) {
                // empty if block
            }
            return i == s.length() && TIUtils.trailingStars(ea, j) != false;
        }
        catch (Exception e) {
            if (TraceSDPlugin.debugMatch) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static boolean hasObjectInteractions(TRCAgentProxy agent_proxy) {
        boolean collects_object_instances = false;
        switch (agent_proxy.getCollectionMode().getValue()) {
            case 2: 
            case 5: 
            case 6: {
                collects_object_instances = true;
                break;
            }
            default: {
                collects_object_instances = false;
            }
        }
        return collects_object_instances;
    }

    public static boolean hasInvocationData(TRCAgentProxy agentProxy) {
        boolean stackInformation = false;
        if (agentProxy != null && agentProxy.getType().equals("Profiler")) {
            EList configs = agentProxy.getConfigurations();
            if (configs == null) {
                return false;
            }
            Iterator i = configs.iterator();
            while (i.hasNext()) {
                TRCConfiguration config = (TRCConfiguration)i.next();
                EList options = config.getOptions();
                if (options == null) continue;
                Iterator io = options.iterator();
                while (io.hasNext()) {
                    TRCOption option = (TRCOption)io.next();
                    if (!option.getKey().equals("STACK_INFORMATION") || option.getValue().equals("none")) continue;
                    stackInformation = true;
                }
            }
        }
        return stackInformation;
    }

    public static void searchTRCAgentProxies(EObject object, List list) {
        if (object instanceof TRCMonitor) {
            TRCMonitor m = (TRCMonitor)object;
            if (m.getNodes() == null || m.getNodes().isEmpty()) {
                return;
            }
            Iterator i = m.getNodes().iterator();
            while (i.hasNext()) {
                TIUtils.searchTRCAgentProxies((EObject)i.next(), list);
            }
        } else if (object instanceof TRCNode) {
            TRCNode n = (TRCNode)object;
            if (n.getProcessProxies() == null || n.getProcessProxies().isEmpty()) {
                return;
            }
            Iterator i = n.getProcessProxies().iterator();
            while (i.hasNext()) {
                TIUtils.searchTRCAgentProxies((EObject)i.next(), list);
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy pp = (TRCProcessProxy)object;
            if (pp.getAgentProxies() == null || pp.getAgentProxies().isEmpty()) {
                return;
            }
            Iterator i = pp.getAgentProxies().iterator();
            while (i.hasNext()) {
                TIUtils.searchTRCAgentProxies((EObject)i.next(), list);
            }
        } else if (object instanceof TRCAgentProxy) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)object;
            if (!list.contains(agentProxy)) {
                list.add(agentProxy);
            }
        } else if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("WARNING! searchTRCAgentProxies(): Found a " + object);
        }
    }

    public static List collectMultiSelectionInNavigator() {
        INavigator nav = HyadesUtil.getActiveNavigator();
        IStructuredSelection selection = nav == null ? null : nav.getStructuredSelection();
        ArrayList list = new ArrayList();
        if (selection != null) {
            Iterator i = selection.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (obj instanceof INavigatorItem) {
                    obj = ((INavigatorItem)obj).getData();
                }
                if (obj instanceof EObject) {
                    TIUtils.searchTRCAgentProxies((EObject)obj, list);
                    continue;
                }
                if (!TraceSDPlugin.debugEvents) continue;
                TraceSDPlugin.debugTraceEvents("WARNING! collectMultiSelectionInNavigator(): Found a " + obj.getClass().getName() + " " + obj);
            }
        }
        return list;
    }
}

