/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.probekit.ProbekitPlugin;
import org.eclipse.hyades.probekit.internal.JarReader;
import org.eclipse.hyades.probekit.internal.JarWriter;

public class ProbeInstrumenterDriver {
    static final String fileSeparator = System.getProperty("file.separator");
    int errorCount = 0;
    static String[] JAR_FILE_SUFFIX_LIST = new String[]{".jar", ".war", ".ear"};
    boolean verbose = false;
    String exePath = null;
    List errorStrings = new LinkedList();
    static final String COMPILER_PLUGIN_NAME = "org.eclipse.hyades.probekit";
    static final String INSERTION_EXECUTABLE_BASENAME = "probeinstrumenter";
    private File scriptFile;
    private String scriptFileNameString;
    String errorString = "";
    int classFilesBatchSize = 10;

    public static int cmdLineMain(String[] stringArray) {
        String string = "";
        ProbeInstrumenterDriver probeInstrumenterDriver = new ProbeInstrumenterDriver();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (!stringArray[n].equals("-v")) {
                    if (stringArray[n].equals("-h")) {
                        System.err.println("User requested this usage message.");
                        return 1;
                    }
                    if (!stringArray[n].startsWith("-")) break;
                    System.err.println("Unrecognized option " + stringArray[n]);
                    return 1;
                }
                probeInstrumenterDriver.setVerbose(true);
                ++n;
            }
            if (stringArray.length - n < 2) {
                System.err.println("Not enough arguments.");
                return 1;
            }
            string = stringArray[n];
            if (!new File(string).exists()) {
                System.err.println("Probescript file \"" + string + "\" does not exist.");
                return 1;
            }
        }
        catch (Exception exception) {
            System.err.println("Usage error: " + exception);
            System.err.println("Usage: ProbeInstrumenter engine_script item [item ...]");
            System.err.println("Where \"items\" may be class files, jar/war/ear files, or directories.");
            System.err.println("Directories are processed recursively, instrumenting all subdirectories and");
            System.err.println("jar, war, ear, and class files found within.");
            return 1;
        }
        String[] stringArray2 = new String[stringArray.length - ++n];
        int n2 = 0;
        while (n2 < stringArray.length - n) {
            stringArray2[n2] = stringArray[n + n2];
            ++n2;
        }
        probeInstrumenterDriver.setExePath(INSERTION_EXECUTABLE_BASENAME);
        try {
            probeInstrumenterDriver.instrumentItems(new File(string), stringArray2, true);
        }
        catch (StaticProbeInstrumenterException staticProbeInstrumenterException) {
            System.err.println("Instrumenter error: " + staticProbeInstrumenterException.getMessage());
            return 2;
        }
        String[] stringArray3 = probeInstrumenterDriver.getErrorStrings();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            System.err.println(stringArray3[n3]);
            ++n3;
        }
        return probeInstrumenterDriver.getErrorCount();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setExePath(String string) {
        this.exePath = string;
    }

    public String[] getErrorStrings() {
        return this.errorStrings.toArray(new String[0]);
    }

    void SetExePathFromPlugin() throws StaticProbeInstrumenterException {
        this.setExePath(ProbeInstrumenterInner.getExeName());
    }

    public int instrumentItems(File file, String[] stringArray, boolean bl) throws StaticProbeInstrumenterException {
        this.scriptFile = file;
        try {
            this.scriptFileNameString = this.scriptFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new StaticProbeInstrumenterException("Error resolving \"" + file + "\": " + iOException.getMessage());
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(stringArray[n]);
            if (!file2.exists()) {
                this.errorStrings.add("No such file or directory: " + file2);
                ++this.errorCount;
            } else if (ProbeInstrumenterDriver.endsWithIgnoreCase(stringArray[n], ".class")) {
                LinkedList<File> linkedList = new LinkedList<File>();
                linkedList.add(file2);
                this.processClassFiles(linkedList, bl, file2.toString());
            } else if (ProbeInstrumenterDriver.endsWithIgnoreCase(stringArray[n], JAR_FILE_SUFFIX_LIST)) {
                this.processJarFile(file2, bl, file2.toString());
            } else if (file2.isDirectory()) {
                this.processDirectory(file2, bl, file2.toString());
            }
            ++n;
        }
        return this.errorCount;
    }

    private static boolean endsWithIgnoreCase(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 < (n = string2.length())) {
            return false;
        }
        return string.substring(n2 - n).equalsIgnoreCase(string2);
    }

    private static boolean endsWithIgnoreCase(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (ProbeInstrumenterDriver.endsWithIgnoreCase(string, stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void processClassFiles(List list, boolean bl, String string) throws StaticProbeInstrumenterException {
        Object object;
        if (this.verbose) {
            System.out.println("(ProcessClassFiles)");
        }
        String[] stringArray = new String[2 + list.size()];
        if (this.exePath == null) {
            this.SetExePathFromPlugin();
        }
        stringArray[0] = this.exePath;
        stringArray[1] = this.scriptFileNameString;
        Iterator iterator = list.iterator();
        int n = 2;
        while (iterator.hasNext()) {
            object = iterator.next();
            stringArray[n] = ((File)object).getAbsolutePath();
            ++n;
        }
        try {
            object = this.executeCommandAndWait(stringArray);
        }
        catch (IOException iOException) {
            throw new StaticProbeInstrumenterException("Unrecoverable error attempting to execute \"" + stringArray[0] + "\"");
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            String string2 = string + file.getName();
            File file2 = new File(file.getAbsolutePath() + ".bci");
            if (!file2.exists()) {
                this.errorStrings.add("Error instrumenting " + string2 + ": no BCI file created");
                this.errorStrings.add("Instrumenter error output follows:");
                this.errorStrings.add(object[1]);
                ++this.errorCount;
                continue;
            }
            if (bl) {
                File file3 = new File(file.getAbsolutePath() + ".bak");
                file3.delete();
                if (!file.renameTo(file3)) {
                    this.errorStrings.add("Error renaming " + file.getAbsolutePath() + " to *.bak");
                    ++this.errorCount;
                }
            } else {
                file.delete();
            }
            if (file2.renameTo(file)) continue;
            this.errorStrings.add("Error renaming " + file2.getAbsolutePath() + " to *.class");
            ++this.errorCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processJarFile(File file, boolean bl, String string) throws StaticProbeInstrumenterException {
        File file2;
        block13: {
            block12: {
                if (this.verbose) {
                    System.out.println("Jar file " + file.getName());
                }
                file2 = null;
                try {
                    try {
                        Object object;
                        file2 = File.createTempFile("probetemp-", "");
                        if (!file2.delete()) throw new StaticProbeInstrumenterException("Internal error managing temporary files");
                        if (!file2.mkdir()) {
                            throw new StaticProbeInstrumenterException("Internal error managing temporary files");
                        }
                        JarReader jarReader = new JarReader(file);
                        Manifest manifest = jarReader.getManifest();
                        jarReader.extractAll(file2);
                        jarReader.close();
                        this.processDirectory(file2, false, string);
                        if (manifest != null) {
                            ProbeInstrumenterDriver.stripManifest(manifest);
                        }
                        if (this.verbose) {
                            System.out.println("Repack " + string);
                        }
                        if (bl) {
                            object = new File(file.getCanonicalPath() + ".bak");
                            ((File)object).delete();
                            if (!file.renameTo((File)object)) {
                                this.errorStrings.add("Unable to rename jar file to *.bak: " + file.getCanonicalPath());
                                ++this.errorCount;
                                Object var9_9 = null;
                                this.recursiveDelete(file2);
                                return;
                            }
                        } else {
                            file.delete();
                            if (file.exists()) {
                                this.errorStrings.add("Unable to delete jar file: " + file.getCanonicalPath());
                                ++this.errorCount;
                                break block12;
                            }
                        }
                        object = new JarWriter(file, manifest, null);
                        ((JarWriter)object).write(file2, "", true);
                        ((JarWriter)object).close();
                        break block13;
                    }
                    catch (IOException iOException) {
                        this.errorStrings.add("I/O Exception processing jar file " + file.getAbsolutePath() + ": " + iOException.getClass() + iOException.getMessage());
                        ++this.errorCount;
                        Object var9_12 = null;
                        this.recursiveDelete(file2);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    this.recursiveDelete(file2);
                    throw throwable;
                }
            }
            Object var9_10 = null;
            this.recursiveDelete(file2);
            return;
        }
        Object var9_11 = null;
        this.recursiveDelete(file2);
    }

    void processDirectory(File file, boolean bl, String string) throws StaticProbeInstrumenterException {
        if (this.verbose) {
            System.out.println("Directory " + file.getName());
        }
        File[] fileArray = file.listFiles();
        Vector<File> vector = new Vector<File>();
        int n = 0;
        while (n < fileArray.length) {
            String string2 = string + fileSeparator + fileArray[n].toString();
            if (fileArray[n].isDirectory()) {
                this.processDirectory(fileArray[n], bl, string2);
            } else if (fileArray[n].getName().endsWith(".class")) {
                vector.add(fileArray[n]);
            } else if (ProbeInstrumenterDriver.endsWithIgnoreCase(fileArray[n].getName(), JAR_FILE_SUFFIX_LIST)) {
                this.processJarFile(fileArray[n], bl, string2);
            }
            if (n == fileArray.length - 1 || vector.size() == this.classFilesBatchSize) {
                this.processClassFiles(vector, bl, string);
                vector.clear();
            }
            ++n;
        }
    }

    boolean recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.recursiveDelete(fileArray[n]);
                ++n;
            }
        }
        return file.delete();
    }

    static void stripManifest(Manifest manifest) {
        Map<String, Attributes> map = manifest.getEntries();
        if (map != null) {
            Iterator<Map.Entry<String, Attributes>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                String string;
                Object object;
                Map.Entry<String, Attributes> entry = iterator.next();
                Map.Entry<String, Attributes> entry2 = entry;
                Attributes attributes = entry2.getValue();
                if (attributes == null) continue;
                Set<Object> set = attributes.keySet();
                Iterator<Object> iterator2 = set.iterator();
                HashSet<String> hashSet = new HashSet<String>();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    string = object.toString();
                    if (!string.endsWith("-Digest")) continue;
                    hashSet.add(string);
                }
                object = hashSet.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    Attributes.Name name = new Attributes.Name(string);
                    attributes.remove(name);
                }
            }
        }
    }

    private String[] executeCommandAndWait(String[] stringArray) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringArray);
        StreamCapture streamCapture = new StreamCapture(process.getInputStream());
        streamCapture.start();
        StreamCapture streamCapture2 = new StreamCapture(process.getErrorStream());
        streamCapture2.start();
        boolean bl = false;
        int n = 0;
        do {
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while (bl);
        String string = streamCapture.getCapture().toString();
        String string2 = streamCapture2.getCapture().toString();
        if (n != 0) {
            this.errorCount = 4;
        }
        return new String[]{string, string2};
    }

    static class StreamCapture
    extends Thread {
        InputStream stream;
        StringBuffer capture = new StringBuffer();
        static final String newline = System.getProperty("line.separator");

        public StreamCapture(InputStream inputStream) {
            this.stream = inputStream;
        }

        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.stream));
            String string = null;
            boolean bl = false;
            do {
                try {
                    string = bufferedReader.readLine();
                    if (string == null) continue;
                    this.capture.append(string);
                    this.capture.append(newline);
                }
                catch (IOException iOException) {
                    this.capture.append("IO Exception in stream reader:");
                    this.capture.append(newline);
                    this.capture.append(iOException.getMessage());
                    this.capture.append(newline);
                    if (bl) break;
                    bl = true;
                }
            } while (string != null);
        }

        public StringBuffer getCapture() {
            return this.capture;
        }
    }

    public static class StaticProbeInstrumenterException
    extends Exception {
        public StaticProbeInstrumenterException(String string) {
            super(string);
        }
    }

    static class ProbeInstrumenterInner {
        ProbeInstrumenterInner() {
        }

        static String getExeName() throws StaticProbeInstrumenterException {
            try {
                URL uRL;
                URL uRL2;
                String string = "$os$/probeinstrumenter";
                if (Platform.getOS().equals("win32")) {
                    string = string + ".exe";
                }
                ProbekitPlugin probekitPlugin = ProbekitPlugin.getDefault();
                Path path = new Path(string);
                URL uRL3 = probekitPlugin.find((IPath)path, null);
                URL uRL4 = probekitPlugin.getBundle().getEntry("/");
                String string2 = uRL3.getFile();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                if ((uRL2 = Platform.asLocalURL((URL)(uRL = new URL(uRL4, string2)))) == null) {
                    throw new StaticProbeInstrumenterException("Native executable for instrumentation not found (tried " + string + " relative to " + probekitPlugin.getBundle().getSymbolicName());
                }
                String string3 = uRL2.getFile();
                File file = new File(string3);
                if (!file.exists()) {
                    throw new StaticProbeInstrumenterException("Native executable for instrumentation not found (tried " + string3 + ")");
                }
                string3 = file.getCanonicalPath();
                return string3;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

