/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.editor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.test.common.TestCommonImages;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.common.internal.editor.BehaviorForm;
import org.eclipse.hyades.test.common.internal.editor.action.AddLoop;
import org.eclipse.hyades.test.common.internal.editor.action.AddTestInvocation;
import org.eclipse.hyades.test.common.internal.editor.action.BehaviorActionGroup;
import org.eclipse.hyades.test.common.internal.editor.action.InsertLoop;
import org.eclipse.hyades.test.common.internal.editor.action.InsertTestInvocation;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.ui.adapter.TestAdapterFactory;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class BehaviorSection
extends EObjectTreeSection
implements IITestSuiteProvider {
    protected static final int HELP_SECTION_CONTROL = 1;
    protected static final int HELP_SECTION_UP_ACTION = 2;
    protected static final int HELP_SECTION_DOWN_ACTION = 3;
    protected static final int HELP_SECTION_ADD_LOOP_ACTION = 4;
    protected static final int HELP_SECTION_ADD_INV_ACTION = 5;
    private BehaviorActionGroup addBehaviorActionGroup;
    private BehaviorActionGroup insertBehaviorActionGroup;

    public BehaviorSection(BehaviorForm behaviorForm) {
        super((EditorForm)behaviorForm, (EStructuralFeature)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction_InteractionFragments(), null);
    }

    public void dispose() {
        if (this.addBehaviorActionGroup != null) {
            this.addBehaviorActionGroup.dispose();
        }
        if (this.insertBehaviorActionGroup != null) {
            this.insertBehaviorActionGroup.dispose();
        }
        super.dispose();
    }

    public ITestSuite getTestSuite() {
        return ((BehaviorForm)this.getEditorForm()).getTestSuite();
    }

    protected void adjustButtonLabels(String string) {
        super.adjustButtonLabels(TestCommonPlugin.getString("BTN_ADD"), TestCommonPlugin.getString("BTN_INSERT"));
    }

    protected void adjustClient(Composite composite) {
        super.adjustClient(composite);
        this.registerHelp(1, this.getTreeViewer().getControl());
        this.registerHelp(2, this.moveUpAction);
        this.registerHelp(3, this.moveDownAction);
    }

    protected void createActions() {
        this.addBehaviorActionGroup = this.createAddBehaviorActionGroup();
        this.insertBehaviorActionGroup = this.createInsertBehaviorActionGroup();
        super.createActions();
    }

    protected IContentProvider createContentProvider() {
        return new BehaviorContentProvider(this.getEditorForm(), this.getEStructuralFeature());
    }

    protected ILabelProvider createLabelProvider() {
        return new BehaviorLabelProvider();
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        if (this.addBehaviorActionGroup != null) {
            this.addBehaviorActionGroup.fillContextMenu(iMenuManager);
            if (this.isReadOnly()) {
                this.addBehaviorActionGroup.disableActions();
            }
        }
        if (this.insertBehaviorActionGroup != null) {
            this.insertBehaviorActionGroup.fillContextMenu(iMenuManager);
            if (this.isReadOnly()) {
                this.insertBehaviorActionGroup.disableActions();
            }
        }
        super.fillContextMenu(iMenuManager);
    }

    protected void doAdd() {
        if (this.addBehaviorActionGroup != null) {
            Menu menu = this.getTreePart().getButtonMenu(0);
            this.addBehaviorActionGroup.fillContextMenu(menu, true);
            menu.setVisible(true);
        }
    }

    protected void doInsert() {
        if (this.insertBehaviorActionGroup != null) {
            Menu menu = this.getTreePart().getButtonMenu(1);
            this.insertBehaviorActionGroup.fillContextMenu(menu, true);
            menu.setVisible(true);
        }
    }

    protected void updateActionsAndButtons(IStructuredSelection iStructuredSelection) {
        if (this.addBehaviorActionGroup != null) {
            this.addBehaviorActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            this.getTreePart().setButtonEnabled(0, this.addBehaviorActionGroup.isEnabled());
        }
        if (this.insertBehaviorActionGroup != null) {
            this.insertBehaviorActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            this.getTreePart().setButtonEnabled(1, this.insertBehaviorActionGroup.isEnabled());
        }
        if (!iStructuredSelection.isEmpty() && ((EObject)iStructuredSelection.getFirstElement()).eContainer() != this.getInput()) {
            this.moveUpAction.setEStructuralFeature((EStructuralFeature)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments());
            this.moveDownAction.setEStructuralFeature((EStructuralFeature)Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments());
        } else {
            this.moveUpAction.setEStructuralFeature(this.getEStructuralFeature());
            this.moveDownAction.setEStructuralFeature(this.getEStructuralFeature());
        }
        if (this.addAction != null) {
            if (this.addAction instanceof SelectionListenerAction) {
                ((SelectionListenerAction)this.addAction).selectionChanged(iStructuredSelection);
            }
            this.getTreePart().setButtonEnabled(0, this.addAction.isEnabled());
        }
        if (this.insertAction != null) {
            if (this.insertAction instanceof SelectionListenerAction) {
                ((SelectionListenerAction)this.insertAction).selectionChanged(iStructuredSelection);
            }
            this.getTreePart().setButtonEnabled(1, this.insertAction.isEnabled());
        }
        if (this.removeAction != null) {
            this.removeAction.selectionChanged(iStructuredSelection);
            this.getTreePart().setButtonEnabled(2, this.removeAction.isEnabled());
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.selectionChanged(iStructuredSelection);
            this.getTreePart().setButtonEnabled(4, this.moveDownAction.isEnabled());
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.selectionChanged(iStructuredSelection);
            this.getTreePart().setButtonEnabled(3, this.moveUpAction.isEnabled());
        }
    }

    protected BehaviorActionGroup createAddBehaviorActionGroup() {
        BehaviorActionGroup behaviorActionGroup = new BehaviorActionGroup(this, TestCommonPlugin.getString("LBL_ADD"));
        AddLoop addLoop = new AddLoop(this, TestCommonPlugin.getString("LBL_LOOP"), TestCommonPlugin.getString("W_LOOP"));
        this.registerHelp(4, (Object)addLoop);
        behaviorActionGroup.addAction(addLoop);
        AddTestInvocation addTestInvocation = new AddTestInvocation(this, TestCommonPlugin.getString("W_LWR_INV")){

            protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite iTestSuite) {
                return TestCommonUtil.createInvokedTestSelectionDialog(iTestSuite, false);
            }
        };
        this.registerHelp(5, (Object)addTestInvocation);
        behaviorActionGroup.addAction(addTestInvocation);
        return behaviorActionGroup;
    }

    protected BehaviorActionGroup createInsertBehaviorActionGroup() {
        BehaviorActionGroup behaviorActionGroup = new BehaviorActionGroup(this, TestCommonPlugin.getString("LBL_INSERT"));
        BehaviorContentProvider behaviorContentProvider = (BehaviorContentProvider)this.createContentProvider();
        InsertLoop insertLoop = new InsertLoop(this, TestCommonPlugin.getString("LBL_LOOP"), TestCommonPlugin.getString("W_LOOP"));
        this.registerHelp(4, (Object)insertLoop);
        behaviorActionGroup.addAction(insertLoop);
        InsertTestInvocation insertTestInvocation = new InsertTestInvocation(this, TestCommonPlugin.getString("W_LWR_INV")){

            protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite iTestSuite) {
                return TestCommonUtil.createInvokedTestSelectionDialog(iTestSuite, false);
            }
        };
        this.registerHelp(5, (Object)insertTestInvocation);
        behaviorActionGroup.addAction(insertTestInvocation);
        return behaviorActionGroup;
    }

    protected void registerHelp(int n, Object object) {
        switch (n) {
            case 1: {
                WorkbenchHelp.setHelp((Control)((Control)object), (String)(TestCommonPlugin.getID() + ".behf0004"));
                break;
            }
            case 3: {
                WorkbenchHelp.setHelp((IAction)((Action)object), (String)(TestCommonPlugin.getID() + ".behf0006"));
                break;
            }
            case 2: {
                WorkbenchHelp.setHelp((IAction)((Action)object), (String)(TestCommonPlugin.getID() + ".behf0005"));
                break;
            }
            case 4: {
                WorkbenchHelp.setHelp((IAction)((Action)object), (String)(TestCommonPlugin.getID() + ".addl0001"));
                break;
            }
            case 5: {
                WorkbenchHelp.setHelp((IAction)((Action)object), (String)(TestCommonPlugin.getID() + ".adti0001"));
            }
        }
    }

    protected void buttonSelected(int n) {
        if (!this.isReadOnly()) {
            switch (n) {
                case 0: {
                    this.doAdd();
                    break;
                }
                case 1: {
                    this.doInsert();
                    break;
                }
                case 2: {
                    this.doRemove();
                    break;
                }
                case 3: {
                    this.doMoveUp();
                    break;
                }
                case 4: {
                    this.doMoveDown();
                }
            }
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    public static class BehaviorLabelProvider
    extends LabelProvider {
        public String getText(Object object) {
            return TestAdapterFactory.INSTANCE.getHyadesWorkbenchAdapter().getLabel(object);
        }

        public Image getImage(Object object) {
            if (object instanceof ILoop) {
                return TestCommonImages.INSTANCE.getImage("loop.gif");
            }
            if (object instanceof ITestInvocation) {
                return TestCommonImages.INSTANCE.getImage("invocation.gif");
            }
            ImageDescriptor imageDescriptor = TestAdapterFactory.INSTANCE.getHyadesWorkbenchAdapter().getImageDescriptor(object);
            if (imageDescriptor != null) {
                return imageDescriptor.createImage();
            }
            return null;
        }
    }

    public static class BehaviorContentProvider
    extends EObjectTreeSection.EObjectContainerContentProvider {
        public BehaviorContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
            super(editorForm, eStructuralFeature);
        }

        public void dispose() {
            if (this.getContainer() != null) {
                EMFUtil.removeAdapter((Iterator)this.getContainer().eResource().getAllContents(), (Adapter)this);
            }
            super.dispose();
        }

        protected void deregisterInputAdapters(EObject eObject, Object object) {
            if (eObject.eResource() != null) {
                EMFUtil.removeAdapter((Iterator)eObject.eResource().getAllContents(), (Adapter)this);
            }
        }

        protected void registerInputAdapters(EObject eObject, Object object) {
            EMFUtil.addAdapter((Iterator)eObject.eResource().getAllContents(), (Adapter)this);
        }

        public Object getParent(Object object) {
            if (object instanceof org.eclipse.hyades.models.common.facades.behavioral.IAction) {
                EObject eObject = ((EObject)object).eContainer();
                while (!(eObject instanceof ILoop) && eObject != null) {
                    eObject = eObject.eContainer();
                }
                return eObject;
            }
            return super.getParent(object);
        }

        public boolean hasChildren(Object object) {
            if (super.hasChildren(object)) {
                return true;
            }
            if (object instanceof ILoop) {
                return !((ILoop)object).getBlock().getActions().isEmpty();
            }
            return false;
        }

        public Object[] getChildren(Object object) {
            if (object instanceof ILoop) {
                return ((ILoop)object).getBlock().getActions().toArray();
            }
            return super.getChildren(object);
        }

        protected void adjustAdapter(Notification notification) {
            EObject eObject = null;
            switch (notification.getEventType()) {
                case 3: {
                    eObject = (EObject)notification.getNewValue();
                    eObject.eAdapters().add((Object)this);
                    EMFUtil.addAdapter((Iterator)eObject.eAllContents(), (Adapter)this);
                    break;
                }
                case 5: {
                    Iterator iterator = ((Collection)notification.getNewValue()).iterator();
                    while (iterator.hasNext()) {
                        EMFUtil.addAdapter((Iterator)((EObject)iterator.next()).eAllContents(), (Adapter)this);
                    }
                    break;
                }
                case 4: {
                    eObject = (EObject)notification.getOldValue();
                    eObject.eAdapters().remove((Object)this);
                    EMFUtil.removeAdapter((Iterator)eObject.eAllContents(), (Adapter)this);
                    break;
                }
                case 6: {
                    Iterator iterator = ((Collection)notification.getOldValue()).iterator();
                    while (iterator.hasNext()) {
                        EMFUtil.removeAdapter((Iterator)((EObject)iterator.next()).eAllContents(), (Adapter)this);
                    }
                    break;
                }
            }
        }

        protected boolean shouldUpdateViewer(Notification notification) {
            if (super.shouldUpdateViewer(notification)) {
                return true;
            }
            return notification.getNotifier() instanceof IBlock && notification.getFeature() == Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments();
        }

        protected void attributeChanged(Notification notification) {
            super.attributeChanged(notification);
            if (this.getViewer() != null && notification.getFeature() == Common_Behavior_InteractionsPackage.eINSTANCE.getBVRExecutionOccurrence_OtherBehavior() && notification.getNotifier() instanceof ITestInvocation) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
                if (iStructuredSelection.isEmpty()) {
                    return;
                }
                if (iStructuredSelection.getFirstElement() == notification.getNotifier()) {
                    UIUtil.fireCurrentSelection((StructuredViewer)((StructuredViewer)this.getViewer()));
                }
            }
        }
    }
}

