/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.editor.action;

import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionListenerAction;

public class AddBlockChildAction
extends SelectionListenerAction
implements IDisposable {
    private IITestSuiteProvider testSuiteProvider;
    private IBlock block;
    private String baseName;
    private boolean actionPerformed = false;

    public AddBlockChildAction(IITestSuiteProvider iITestSuiteProvider, String string, String string2) {
        super(string);
        this.testSuiteProvider = iITestSuiteProvider;
        this.baseName = string2;
    }

    public void dispose() {
        this.testSuiteProvider = null;
        this.block = null;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public boolean actionPerformed() {
        return this.actionPerformed;
    }

    protected void setActionPerformed(boolean bl) {
        this.actionPerformed = bl;
    }

    protected ITestSuite getTestSuite() {
        return this.testSuiteProvider.getTestSuite();
    }

    protected IBlock getBlock() {
        return this.block;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.actionPerformed = false;
        this.block = null;
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IBlock) {
            this.block = (IBlock)object;
        } else if (object instanceof ITest) {
            IImplementor iImplementor = ((ITest)object).getImplementor();
            if (iImplementor != null) {
                this.block = iImplementor.getBlock();
            }
        } else if (object instanceof IImplementor) {
            this.block = ((IImplementor)object).getBlock();
        } else if (object instanceof ILoop) {
            this.block = ((ILoop)object).getBlock();
        }
        return this.block != null && this.getTestSuite() != null;
    }
}

