/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.junit.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.junit.editor.HttpHeaderViewer;
import org.eclipse.hyades.test.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.http.internal.util.HttpConstants;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.IWriteAccessChangeListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class HttpTestCaseDetailPage
extends DetailSection.DetailPage
implements ModifyListener,
IWriteAccessChangeListener,
SelectionListener {
    public static final int COLUMNS_IN_LAYOUT = 2;
    private CCombo methodCombo;
    private StyledText httpVersionText;
    private StyledText hostText;
    private StyledText portText;
    private StyledText absolutePathText;
    private StyledText bodyText;
    private HttpHeaderViewer headerViewer;
    private CCombo m_thinkTimeCo;
    private RequestHelper requestHelper = new RequestHelper();
    private Button m_sslButton;

    public void dispose() {
        this.getEditorForm().getBaseEditorExtension().removeListener((IWriteAccessChangeListener)this);
        this.requestHelper.dispose();
        this.headerViewer.dispose();
    }

    public Control createControl(Composite composite, FormWidgetFactory formWidgetFactory) {
        this.getEditorForm().getBaseEditorExtension().addListener((IWriteAccessChangeListener)this);
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite2 = widgetFactory.createComposite(composite);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("HTTP_Version_Label"));
        this.httpVersionText = widgetFactory.createStyledText(composite2, 65540);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.httpVersionText.setLayoutData((Object)gridData);
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("RQ_METH_TEXT"));
        this.methodCombo = widgetFactory.createCCombo(composite2, 0x800000);
        this.methodCombo.setLayoutData((Object)this.getFullRowLayoutData());
        this.methodCombo.setItems(HttpConstants.SUPPORTED_REQUEST_METHODS);
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("HOST_TEXT"));
        this.hostText = widgetFactory.createStyledText(composite2, 65540);
        this.hostText.setLayoutData((Object)this.getFullRowLayoutData());
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("PORT_TEXT"));
        this.portText = widgetFactory.createStyledText(composite2, 65540);
        this.portText.setLayoutData((Object)this.getFullRowLayoutData());
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("THINK_TIME"));
        this.m_thinkTimeCo = widgetFactory.createCCombo(composite2, 0x800000);
        this.m_thinkTimeCo.setLayoutData((Object)this.getFullRowLayoutData());
        this.m_thinkTimeCo.setItems(new String[]{TestHttpPlugin.getString("THNK_TIME_DEF"), TestHttpPlugin.getString("THNK_TIME_QRY")});
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("ABS_PATH_TEXT"));
        this.absolutePathText = widgetFactory.createStyledText(composite2, 65540);
        this.absolutePathText.setLayoutData((Object)this.getFullRowLayoutData());
        this.m_sslButton = widgetFactory.createButton(composite2, TestHttpPlugin.getString("SSL_LABEL"), 32);
        this.m_sslButton.setLayoutData((Object)this.getFullRowLayoutData());
        widgetFactory.createLabel(composite2, TestHttpPlugin.getString("BODY_TEXT"));
        this.bodyText = widgetFactory.createStyledText(composite2, 66306);
        GridData gridData2 = this.getFullRowLayoutData();
        gridData2.heightHint = 4 * this.hostText.getLineHeight();
        this.bodyText.setLayoutData((Object)gridData2);
        this.headerViewer = new HttpHeaderViewer();
        this.headerViewer.createControl(composite2, widgetFactory);
        this.headerViewer.setReadOnly(this.isReadOnly());
        widgetFactory.paintBordersFor(composite2);
        return composite2;
    }

    public void setInput(Object object) {
        Object object2;
        this.requestHelper.dispose();
        this.methodCombo.removeModifyListener((ModifyListener)this);
        this.httpVersionText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.httpVersionText.removeModifyListener((ModifyListener)this);
        this.hostText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.hostText.removeModifyListener((ModifyListener)this);
        this.absolutePathText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.absolutePathText.removeModifyListener((ModifyListener)this);
        this.bodyText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.bodyText.removeModifyListener((ModifyListener)this);
        this.portText.removeVerifyKeyListener((VerifyKeyListener)this);
        this.portText.removeModifyListener((ModifyListener)this);
        this.m_thinkTimeCo.removeModifyListener((ModifyListener)this);
        this.m_thinkTimeCo.removeSelectionListener((SelectionListener)this);
        this.m_sslButton.removeSelectionListener((SelectionListener)this);
        this.httpVersionText.setText("");
        this.hostText.setText("");
        this.bodyText.setText("");
        this.portText.setText("");
        this.absolutePathText.setText("");
        this.methodCombo.setText("");
        this.m_thinkTimeCo.setText("");
        this.m_sslButton.setSelection(false);
        if (object instanceof IStructuredSelection && (object2 = (IStructuredSelection)object).size() == 1) {
            object = object2.getFirstElement();
        }
        if (object instanceof ITestCase) {
            this.methodCombo.setEnabled(!this.isReadOnly());
            this.httpVersionText.setEditable(false);
            this.hostText.setEditable(true);
            this.bodyText.setEditable(true);
            this.absolutePathText.setEditable(true);
            this.portText.setEditable(true);
            this.m_thinkTimeCo.setEnabled(!this.isReadOnly());
            this.requestHelper.setTestCase((ITestCase)object);
            this.httpVersionText.setText("1.1");
            this.absolutePathText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(3)));
            this.bodyText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(4)));
            this.hostText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(1)));
            this.portText.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(2)));
            this.methodCombo.setText(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(5)));
            object2 = this.requestHelper.getAttribute(7);
            if (object2 == null || ((String)object2).charAt(0) == '-') {
                this.m_thinkTimeCo.setText("");
                this.m_thinkTimeCo.setSelection(new Point(1, 1));
                this.m_thinkTimeCo.select(1);
            } else {
                this.m_thinkTimeCo.setText((String)object2);
            }
            this.m_sslButton.setSelection("true".equalsIgnoreCase(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(12))));
            try {
                int n = Integer.parseInt(HyadesTestUtil.getNotNullString((Object)this.requestHelper.getAttribute(9)));
                switch (n) {
                    case 1: {
                        String string = TestHttpPlugin.getString("ENUM_START");
                        break;
                    }
                    case 2: {
                        String string = TestHttpPlugin.getString("ENUM_MID");
                        break;
                    }
                    case 3: {
                        String string = TestHttpPlugin.getString("ENUM_END");
                        break;
                    }
                    case 4: {
                        String string = TestHttpPlugin.getString("ENUM_ONLY");
                        break;
                    }
                    default: {
                        String string = TestHttpPlugin.getString("ENUM_UNDEFINED");
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string = TestHttpPlugin.getString("ENUM_UNDEFINED");
            }
            this.headerViewer.setEnabled(true);
            this.headerViewer.setInput(this.requestHelper);
        } else {
            this.httpVersionText.setEditable(false);
            this.hostText.setEditable(false);
            this.bodyText.setEditable(false);
            this.absolutePathText.setEditable(false);
            this.methodCombo.setEnabled(false);
            this.portText.setEditable(false);
            this.m_thinkTimeCo.setEnabled(false);
            this.m_sslButton.setEnabled(false);
            this.headerViewer.setEnabled(false);
        }
        this.methodCombo.addModifyListener((ModifyListener)this);
        this.httpVersionText.addVerifyKeyListener((VerifyKeyListener)this);
        this.httpVersionText.addModifyListener((ModifyListener)this);
        this.hostText.addVerifyKeyListener((VerifyKeyListener)this);
        this.hostText.addModifyListener((ModifyListener)this);
        this.absolutePathText.addVerifyKeyListener((VerifyKeyListener)this);
        this.absolutePathText.addModifyListener((ModifyListener)this);
        this.bodyText.addVerifyKeyListener((VerifyKeyListener)this);
        this.bodyText.addModifyListener((ModifyListener)this);
        this.portText.addVerifyKeyListener((VerifyKeyListener)this);
        this.portText.addModifyListener((ModifyListener)this);
        this.m_thinkTimeCo.addModifyListener((ModifyListener)this);
        this.m_thinkTimeCo.addSelectionListener((SelectionListener)this);
        this.m_sslButton.addSelectionListener((SelectionListener)this);
    }

    public Object getInput() {
        return this.requestHelper.getTestCase();
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        super.verifyKey(verifyEvent);
        if (verifyEvent.widget == this.portText) {
            UIUtil.integerStyledTextVerifyKey((VerifyEvent)verifyEvent);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.absolutePathText) {
            this.requestHelper.setAttribute(3, this.absolutePathText.getText());
        } else if (modifyEvent.widget == this.bodyText) {
            this.requestHelper.setAttribute(4, this.bodyText.getText());
        } else if (modifyEvent.widget == this.hostText) {
            this.requestHelper.setAttribute(1, this.hostText.getText());
        } else if (modifyEvent.widget == this.portText) {
            this.requestHelper.setAttribute(2, this.portText.getText());
        } else if (modifyEvent.widget == this.methodCombo) {
            this.requestHelper.setAttribute(5, this.methodCombo.getText());
        } else if (modifyEvent.widget == this.m_thinkTimeCo) {
            try {
                Long.parseLong(this.m_thinkTimeCo.getText());
                this.requestHelper.setAttribute(7, this.m_thinkTimeCo.getText());
                this.m_thinkTimeCo.setForeground(null);
            }
            catch (Exception exception) {
                this.m_thinkTimeCo.setForeground(new Color((Device)this.m_thinkTimeCo.getShell().getDisplay(), 255, 0, 0));
            }
        }
        if (this.requestHelper.isDirty()) {
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    public void writeAccessChanged(IFile iFile, boolean bl) {
        this.methodCombo.setEnabled(!bl);
        this.headerViewer.setReadOnly(bl);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.m_thinkTimeCo) {
            String string = null;
            switch (this.m_thinkTimeCo.getSelectionIndex()) {
                case -1: {
                    string = this.m_thinkTimeCo.getText();
                    break;
                }
                case 0: {
                    string = HttpPreferenceUtil.getInstance().getDefaultThinkTime();
                    this.m_thinkTimeCo.setText(string);
                    break;
                }
                case 1: {
                    string = "-1";
                }
            }
            this.requestHelper.setAttribute(7, string);
            this.m_thinkTimeCo.setForeground(null);
        } else if (selectionEvent.widget == this.m_sslButton) {
            if (this.m_sslButton.getSelection()) {
                this.requestHelper.setAttribute(12, "true");
            } else {
                this.requestHelper.setAttribute(12, "false");
            }
        }
        if (this.requestHelper.isDirty()) {
            this.getEditorForm().getBaseEditorExtension().markDirty();
        }
    }

    protected GridData getFullRowLayoutData() {
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        return gridData;
    }
}

