/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExtractorSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Button isReplaceLineBreaks;
    protected Button hasStartEvent;
    protected Text eventStartText;
    protected Button hasEndEvent;
    protected Text eventEndText;
    protected Button isLineBreaks;
    protected Text lineBreaksText;
    protected Text descriptionText;
    protected Label uniqueIdText;
    protected ExtractorType currentSelection;
    protected boolean isDisplaying = false;
    protected ExtractorTypeItemProvider itemProvider;
    protected ExtractorItemProviderAdapterFactory itemFactory = new ExtractorItemProviderAdapterFactory();

    public ExtractorSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_DESCR"), 0);
        this.descriptionText = factory.createText(this, "", 0);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_ID"), 0);
        this.uniqueIdText = factory.createLabel(this, "");
        this.uniqueIdText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.isLineBreaks = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_HAS_LINEB"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.isLineBreaks.setLayoutData((Object)data);
        this.isReplaceLineBreaks = factory.createButton(this, AcadEditorPlugin.INSTANCE.getString("REPLACE_LINE_BREAK"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.isReplaceLineBreaks.setLayoutData((Object)data);
        Composite grp = new Composite((Composite)this, 0);
        detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 10;
        grp.setLayout((Layout)detailLayout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        grp.setLayoutData((Object)data);
        label = factory.createLabel(grp, AcadEditorPlugin.getPlugin().getString("STR_EXTR_LINE_BSYMB"), 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        this.lineBreaksText = factory.createText(grp, "", 0);
        this.lineBreaksText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        grp = new Composite((Composite)this, 0);
        detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 10;
        grp.setLayout((Layout)detailLayout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        grp.setLayoutData((Object)data);
        label = factory.createLabel(grp, AcadEditorPlugin.getPlugin().getString("STR_EXTR_STARTP"), 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        this.hasStartEvent = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_INC_STARTP"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.hasStartEvent.setLayoutData((Object)data);
        this.eventStartText = factory.createText(grp, "", 0);
        this.eventStartText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        grp = new Composite((Composite)this, 0);
        detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 10;
        grp.setLayout((Layout)detailLayout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        grp.setLayoutData((Object)data);
        label = factory.createLabel(grp, AcadEditorPlugin.getPlugin().getString("STR_EXTR_END_PATTERN"), 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        this.hasEndEvent = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_EXTR_INC_ENDP"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.hasEndEvent.setLayoutData((Object)data);
        this.eventEndText = factory.createText(grp, "", 0);
        this.eventEndText.setLayoutData((Object)new GridData(768));
        this.eventEndText.addModifyListener((ModifyListener)this);
        this.eventStartText.addModifyListener((ModifyListener)this);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.lineBreaksText.addModifyListener((ModifyListener)this);
        this.isLineBreaks.addSelectionListener((SelectionListener)this);
        this.hasStartEvent.addSelectionListener((SelectionListener)this);
        this.hasEndEvent.addSelectionListener((SelectionListener)this);
        this.isReplaceLineBreaks.addSelectionListener((SelectionListener)this);
        this.itemProvider = (ExtractorTypeItemProvider)this.itemFactory.createExtractorTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.currentSelection == null || this.isDisplaying) {
            return;
        }
        if (e.getSource() == this.eventStartText) {
            String text2 = this.eventStartText.getText();
            if (!text2.equals(this.currentSelection.getStartPattern())) {
                if (text2.length() == 0 && this.currentSelection.getStartPattern() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.eventEndText) {
            String text3 = this.eventEndText.getText();
            if (!text3.equals(this.currentSelection.getEndPattern())) {
                if (text3.length() == 0 && this.currentSelection.getEndPattern() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.END_PATTERN);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text3);
                }
            }
        } else if (e.getSource() == this.descriptionText) {
            String text4 = this.descriptionText.getText();
            if (!text4.equals(this.currentSelection.getDescription())) {
                if (text4.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.DESCRIPTION);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text4);
                }
            }
        } else if (e.getSource() == this.lineBreaksText && !(text = this.lineBreaksText.getText()).equals(this.currentSelection.getLineBreakSymbol())) {
            if (text.length() == 0 && this.currentSelection.getLineBreakSymbol() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.LINE_BREAK_SYMBOL);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.currentSelection = null;
    }

    protected void updateControls() {
        this.isDisplaying = true;
        if (this.currentSelection.getUniqueID() != null) {
            this.uniqueIdText.setText(this.currentSelection.getUniqueID());
        }
        if (this.currentSelection.getDescription() != null) {
            this.descriptionText.setText(this.currentSelection.getDescription());
        }
        if (this.currentSelection.getStartPattern() != null) {
            this.eventStartText.setText(this.currentSelection.getStartPattern());
        }
        if (this.currentSelection.getEndPattern() != null) {
            this.eventEndText.setText(this.currentSelection.getEndPattern());
        }
        if (this.currentSelection.getLineBreakSymbol() != null) {
            this.lineBreaksText.setText(this.currentSelection.getLineBreakSymbol());
        }
        this.isLineBreaks.setSelection(this.currentSelection.isContainsLineBreaks());
        this.hasStartEvent.setSelection(this.currentSelection.isIncludeStartPattern());
        this.hasEndEvent.setSelection(this.currentSelection.isIncludeEndPattern());
        this.isReplaceLineBreaks.setSelection(this.currentSelection.isReplaceLineBreaks());
        this.isDisplaying = false;
    }

    public void widgetSelected(SelectionEvent e) {
        boolean value;
        if (e.getSource() == this.isReplaceLineBreaks) {
            boolean value2 = this.isReplaceLineBreaks.getSelection();
            if (value2 != this.currentSelection.isReplaceLineBreaks()) {
                this.currentSelection.setReplaceLineBreaks(value2);
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
                String oldValue = this.currentSelection.getStartPattern();
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
                }
            }
        } else if (e.getSource() == this.isLineBreaks) {
            boolean value3 = this.isLineBreaks.getSelection();
            if (value3 != this.currentSelection.isContainsLineBreaks()) {
                this.currentSelection.setContainsLineBreaks(value3);
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
                String oldValue = this.currentSelection.getStartPattern();
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
                }
            }
        } else if (e.getSource() == this.hasEndEvent) {
            boolean value4 = this.hasEndEvent.getSelection();
            if (value4 != this.currentSelection.isIncludeEndPattern()) {
                this.currentSelection.setIncludeEndPattern(value4);
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
                String oldValue = this.currentSelection.getStartPattern();
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
                }
            }
        } else if (e.getSource() == this.hasStartEvent && (value = this.hasStartEvent.getSelection()) != this.currentSelection.isIncludeStartPattern()) {
            this.currentSelection.setIncludeStartPattern(value);
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ExtractorTypeItemProvider.START_PATTERN);
            String oldValue = this.currentSelection.getStartPattern();
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void notifyChanged(Notification notification) {
        if (this.eventEndText.isFocusControl() || this.eventStartText.isFocusControl() || this.uniqueIdText.isFocusControl() || this.descriptionText.isFocusControl() || this.isLineBreaks.isFocusControl() || this.lineBreaksText.isFocusControl() || this.hasEndEvent.isFocusControl() || this.hasStartEvent.isFocusControl() || this.isReplaceLineBreaks.isFocusControl()) {
            return;
        }
        this.updateControls();
    }

    public void display(EObject object) {
        if (object != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)object.eContainer());
        }
        if (this.currentSelection == object) {
            return;
        }
        if (this.eventEndText.isFocusControl() || this.eventStartText.isFocusControl() || this.uniqueIdText.isFocusControl() || this.descriptionText.isFocusControl() || this.isLineBreaks.isFocusControl() || this.lineBreaksText.isFocusControl() || this.hasEndEvent.isFocusControl() || this.hasStartEvent.isFocusControl() || this.isReplaceLineBreaks.isFocusControl()) {
            return;
        }
        this.currentSelection = (ExtractorType)object;
        this.isDisplaying = true;
        this.updateControls();
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (ExtractorType)currentSelection;
        this.currentSelection.setDescription(this.descriptionText.getText());
        this.currentSelection.setUniqueID(this.uniqueIdText.getText());
        this.currentSelection.setReplaceLineBreaks(this.isReplaceLineBreaks.getSelection());
        this.currentSelection.setContainsLineBreaks(this.isLineBreaks.getSelection());
        this.currentSelection.setLineBreakSymbol(this.lineBreaksText.getText());
        this.currentSelection.setIncludeStartPattern(this.hasStartEvent.getSelection());
        this.currentSelection.setStartPattern(this.eventStartText.getText());
        this.currentSelection.setIncludeEndPattern(this.hasEndEvent.getSelection());
        this.currentSelection.setEndPattern(this.eventEndText.getText());
        return false;
    }
}

