/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.provider.AdapterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.provider.FormatterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.provider.SensorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ResourceSelectionDialog
extends SelectionDialog {
    protected EditingDomain editingDomain;
    protected Object selection;

    public ResourceSelectionDialog(Shell parentShell, EditingDomain editingDomain) {
        super(parentShell);
        this.setTitle(AcadEditorPlugin.getPlugin().getString("STR_SELC_DLG_TITLE"));
        this.editingDomain = editingDomain;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridData data = GridUtil.createFill();
        data.widthHint = 300;
        data.heightHint = 400;
        dialogArea.setLayoutData((Object)data);
        dialogArea.setLayout((Layout)new GridLayout());
        Tree tree = new Tree(dialogArea, 2052);
        tree.setLayoutData((Object)GridUtil.createFill());
        final TreeViewer selectionViewer = new TreeViewer(tree);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add((Object)new ConfigurationItemProviderAdapterFactory());
        factories.add((Object)new ExtractorItemProviderAdapterFactory());
        factories.add((Object)new ContextItemProviderAdapterFactory());
        factories.add((Object)new OutputterItemProviderAdapterFactory());
        factories.add((Object)new SensorItemProviderAdapterFactory());
        factories.add((Object)new AdapterItemProviderAdapterFactory());
        factories.add((Object)new ParserItemProviderAdapterFactory());
        factories.add((Object)new FormatterItemProviderAdapterFactory());
        factories.add((Object)new UnitItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        EList list = this.editingDomain.getResourceSet().getResources();
        if (list.size() > 0) {
            Object selected = list.get(0);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Resource element = (Resource)iter.next();
                if (!element.getURI().fileExtension().equals("adapter")) continue;
                EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)AdapterPackage.eINSTANCE);
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
                EObject rootObject = (EObject)element.getContents().get(0);
                selected = rootObject;
                break;
            }
            selectionViewer.setInput(selected);
        } else {
            selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
        }
        selectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ResourceSelectionDialog.this.setSelection(selection.getFirstElement());
            }
        });
        selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (selectionViewer.getExpandedState(item)) {
                        selectionViewer.collapseToLevel(item, 1);
                    } else {
                        selectionViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        return dialogArea;
    }

    public Object getSelection() {
        return this.selection;
    }

    public void setSelection(Object object) {
        this.selection = object;
    }
}

