/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.IExtractor;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.ISensor;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueue;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.hyades.logging.adapter.ui.internal.views.LogView;
import org.eclipse.swt.widgets.Display;

public class TestContextListener
implements IContextListener {
    private int extractorIndex = 0;
    private int formatterIndex = 0;
    private boolean firstRecord = true;
    protected ContextInstanceType context;
    private ResultQueue queue = null;
    private String staticParserName = "org.eclipse.hyades.logging.adapter.config.sensors.StaticParserSensor";

    public void preProcessEventItems(IComponent component, Object[] msgs) {
    }

    public void postProcessEventItems(IComponent component, Object[] results) {
        block22: {
            int idx;
            AcadGuiModel model;
            block21: {
                model = AcadGuiModelManager.getModel(this.context);
                if (model == null) {
                    return;
                }
                if (this.queue == null) {
                    this.queue = model.getResultQueue();
                }
                if (component.getClass().getName().equals(this.staticParserName) && results != null && model != null) {
                    idx = 0;
                    while (idx < results.length) {
                        if (results[idx] != null && ++this.extractorIndex >= model.getStartRecord()) {
                            MessageString msg = new MessageString();
                            msg.setValue(AcadEditorPlugin.getPlugin().getString("STR_STATIC_PARSER_EXTRACTOR_MSG"));
                            this.queue.insertExtractorResult(msg);
                            if (this.firstRecord) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        LogView log = LogView.getLogView(false);
                                        if (log != null) {
                                            log.enableActions();
                                        }
                                    }
                                });
                                this.firstRecord = false;
                            }
                        }
                        if (results[idx] != null && ++this.formatterIndex >= model.getStartRecord()) {
                            this.queue.insertFormatterResult(results[idx]);
                        }
                        ++idx;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            model.updateTemplateLog();
                        }
                    });
                }
                if (!(component instanceof ISensor)) break block21;
                if (results == null) break block22;
                StringBuffer buffer = new StringBuffer();
                int resultCnt = 0;
                int idx2 = 0;
                while (idx2 < results.length) {
                    if (results[idx2] != null) {
                        buffer.append(results[idx2]).append("\n");
                        ++resultCnt;
                    }
                    ++idx2;
                }
                if (model == null) break block22;
                model.setLogContent(model.getLogContent() + buffer.toString(), resultCnt);
                break block22;
            }
            if (component instanceof IExtractor) {
                if (results != null && model != null) {
                    idx = 0;
                    while (idx < results.length) {
                        if (results[idx] != null && ++this.extractorIndex >= model.getStartRecord()) {
                            this.queue.insertExtractorResult(results[idx]);
                        }
                        ++idx;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            model.updateTemplateLog();
                        }
                    });
                }
            } else if (component instanceof IParser) {
                if (results == null && model != null) {
                    this.queue.forceExtractorResult();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            model.updateTemplateLog();
                        }
                    });
                }
            } else if (component instanceof IFormatter && results != null && model != null) {
                idx = 0;
                while (idx < results.length) {
                    if (results[idx] != null && ++this.formatterIndex >= model.getStartRecord()) {
                        this.queue.insertFormatterResult(results[idx]);
                        if (this.firstRecord) {
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    LogView log = LogView.getLogView(false);
                                    if (log != null) {
                                        log.enableActions();
                                    }
                                }
                            });
                            this.firstRecord = false;
                        }
                    }
                    ++idx;
                }
            }
        }
    }

    public String[] getTargetContextUniqueIds() {
        AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
        if (model == null || model.getContextInstance() == null) {
            this.context = null;
            return new String[0];
        }
        this.context = model.getContextInstance();
        model.setContextListener(this);
        return new String[]{this.context.getUniqueID()};
    }

    public ContextInstanceType getContext() {
        return this.context;
    }

    public void setContext(ContextInstanceType type) {
        this.context = type;
    }
}

