/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.preferences;

import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AcadEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static int MAX_SIZE = 100;
    public static int DEFAULT_SIZE = 10;
    public static final String BUFFER_SIZE = "buffer_size";
    private Text sizeText;
    public static final String SWITCH_TO_PERSPECTIVE_KEY = "switch_to_perspective";
    private Button _alwaysPersp;
    private Button _neverPersp;
    private Button _promptPersp;
    protected static PreferencePage INSTANCE;

    public AcadEditorPreferencePage() {
        INSTANCE = this;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        Group content = new Group(composite, 0);
        content.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_BUFFER_GRP"));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.verticalSpacing = 5;
        layout.makeColumnsEqualWidth = false;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Label prefDesc = new Label((Composite)content, 64);
        prefDesc.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_MESSAGE", new Object[]{String.valueOf(MAX_SIZE)}));
        GridData data = GridDataUtil.createHorizontalFill();
        data.widthHint = 400;
        data.horizontalSpan = 2;
        prefDesc.setLayoutData((Object)data);
        Label textDesc = new Label((Composite)content, 0);
        textDesc.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_BUFFER_SIZE"));
        this.sizeText = new Text((Composite)content, 2048);
        data = GridDataUtil.createFill();
        data.widthHint = 50;
        data.horizontalAlignment = 1;
        this.sizeText.setLayoutData((Object)data);
        this.sizeText.setFocus();
        this.sizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = AcadEditorPreferencePage.this.sizeText.getText();
                String errorMessage = null;
                try {
                    int size = Integer.parseInt(value);
                    if (size > MAX_SIZE) {
                        errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_TOO_LARGE", new Object[]{String.valueOf(MAX_SIZE)});
                    } else if (size < 0) {
                        errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NEGATIVE");
                    } else if (size == 0) {
                        errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NOT_INTEGER");
                    }
                }
                catch (Exception exp) {
                    errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NOT_INTEGER");
                }
                INSTANCE.setErrorMessage(errorMessage);
                INSTANCE.setValid(errorMessage == null);
            }
        });
        Group switchPerspGroup = new Group(composite, 0);
        switchPerspGroup.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_GRP"));
        layout = new GridLayout();
        layout.numColumns = 3;
        switchPerspGroup.setLayout((Layout)layout);
        data = GridDataUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        switchPerspGroup.setLayoutData((Object)data);
        this._alwaysPersp = new Button((Composite)switchPerspGroup, 16);
        this._alwaysPersp.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_ALWAYS"));
        this._neverPersp = new Button((Composite)switchPerspGroup, 16);
        this._neverPersp.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_NEVER"));
        this._promptPersp = new Button((Composite)switchPerspGroup, 16);
        this._promptPersp.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_PROMPT"));
        this.initializeValues();
        return composite;
    }

    public void initializeValues() {
        int size = AcadEditorPlugin.getPlugin().getPluginPreferences().getInt(BUFFER_SIZE);
        this.sizeText.setText(Integer.toString(size));
        this.setSwitchPerspOption(AcadEditorPlugin.getPlugin().getPluginPreferences().getString(SWITCH_TO_PERSPECTIVE_KEY));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        AcadEditorPlugin.getPlugin().getPluginPreferences().setToDefault(BUFFER_SIZE);
        this.sizeText.setText("" + AcadEditorPlugin.getPlugin().getPluginPreferences().getDefaultInt(BUFFER_SIZE));
        AcadEditorPlugin.getPlugin().getPluginPreferences().setToDefault(SWITCH_TO_PERSPECTIVE_KEY);
        this.setSwitchPerspOption(AcadEditorPlugin.getPlugin().getPluginPreferences().getDefaultString(SWITCH_TO_PERSPECTIVE_KEY));
    }

    private void storeValues() {
        int size = -1;
        try {
            size = Integer.parseInt(this.sizeText.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        AcadEditorPlugin.getPlugin().getPluginPreferences().setValue(BUFFER_SIZE, size);
        AcadEditorPlugin.getPlugin().getPluginPreferences().setValue(SWITCH_TO_PERSPECTIVE_KEY, this.getSwitchPerspOption());
        AcadEditorPlugin.getPlugin().savePluginPreferences();
    }

    public void setSwitchPerspOption(String value) {
        if ("always".equals(value)) {
            this._alwaysPersp.setSelection(true);
            this._neverPersp.setSelection(false);
            this._promptPersp.setSelection(false);
        } else if ("never".equals(value)) {
            this._neverPersp.setSelection(true);
            this._alwaysPersp.setSelection(false);
            this._promptPersp.setSelection(false);
        } else {
            this._promptPersp.setSelection(true);
            this._alwaysPersp.setSelection(false);
            this._neverPersp.setSelection(false);
        }
    }

    public String getSwitchPerspOption() {
        if (this._alwaysPersp.getSelection()) {
            return "always";
        }
        if (this._neverPersp.getSelection()) {
            return "never";
        }
        return "prompt";
    }
}

