/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class LocationPage
extends WizardNewFileCreationPage {
    private String fileExtension;
    private boolean allowOverwrite = false;

    public LocationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public void setAllowOverwrite(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!this.allowOverwrite()) {
            IPath path = this.getContainerFullPath();
            if (path != null) {
                String name;
                int lastIndexOfExtension;
                String fileName = this.getFileName();
                if (fileName.length() == 0 || fileName.equals("." + this.getFileExtension())) {
                    this.setErrorMessage(HyadesUIPlugin.getString((String)"_ERROR_MIS_NAME"));
                    return false;
                }
                if (fileName.startsWith(".")) {
                    this.setErrorMessage(HyadesUIPlugin.getString((String)"_ERROR_FILE_NAME_EXT"));
                    return false;
                }
                String invalidChar = UIUtil.validateOSFileName((String)fileName);
                if (invalidChar != null) {
                    if (Character.isDigit(invalidChar.charAt(0))) {
                        String[] errors = new String[]{HyadesUIPlugin.getString((String)"LOGICAL_NAME"), HyadesUIPlugin.getString((String)"NUMERIC_VALUE")};
                        this.setErrorMessage(HyadesUIPlugin.getString((String)"_ERROR_NAME_EXT", (String[])errors));
                        return false;
                    }
                    if (invalidChar.trim().equals("-")) {
                        String[] errors = new String[]{HyadesUIPlugin.getString((String)"LOGICAL_NAME"), "-"};
                        this.setErrorMessage(HyadesUIPlugin.getString((String)"_ERROR_NAME_EXT", (String[])errors));
                        return false;
                    }
                    String[] errors = new String[]{HyadesUIPlugin.getString((String)"LOGICAL_NAME"), invalidChar};
                    this.setErrorMessage(HyadesUIPlugin.getString((String)"_ERROR_NAME_SPECIAL_CHAR", (String[])errors));
                    return false;
                }
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.append(fileName));
                if (resource != null && resource.exists()) {
                    this.setErrorMessage(IDEWorkbenchMessages.format((String)"ResourceGroup.nameExists", (Object[])new String[]{fileName}));
                    return false;
                }
                String fileExtension = this.getFileExtension();
                if (fileExtension != null && (lastIndexOfExtension = fileName.lastIndexOf(fileExtension)) > 0 && (name = fileName.substring(0, lastIndexOfExtension - 1)).endsWith("." + fileExtension)) {
                    this.setMessage(HyadesUIPlugin.getString((String)"_WARNING_FILE_NAME", (String)fileName), 2);
                    return true;
                }
            } else {
                this.setErrorMessage(HyadesUIPlugin.getString((String)"_ERROR_MIS_PROJECT"));
                return false;
            }
        }
        return super.validatePage();
    }

    protected String getNewFileLabel() {
        return HyadesUIPlugin.getString((String)"LBL_NAME");
    }

    protected IStatus validateLinkedResource() {
        return new Status(0, HyadesUIPlugin.getID(), 0, "", null);
    }

    public String getFileName() {
        String name = super.getFileName();
        if (this.fileExtension != null) {
            name = name + "." + this.fileExtension;
        }
        return name;
    }

    public String getItemName() {
        return super.getFileName();
    }
}

