/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.statistical.ui.EditorPlugin;

public class ObservationMerger
extends Thread {
    SDContiguousObservation target;
    BasicEList target_values;
    BasicEList target_times;
    ArrayList sources;
    ArrayList sizes = new ArrayList();

    public ObservationMerger(ArrayList sources, SDMemberDescriptor des) {
        this.target = StatisticalFactory.eINSTANCE.createSDContiguousObservation();
        this.target.setMemberDescriptor(des);
        this.target.setWindow(((SDSnapshotObservation)sources.get(0)).getWindow());
        this.sources = sources;
        this.setDaemon(true);
        this.start();
    }

    public ObservationMerger(ArrayList sources, SDContiguousObservation target) {
        this.target = target;
        this.sources = sources;
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        int i = 0;
        while (i < this.sources.size()) {
            SDContiguousObservation obs;
            Object o = this.sources.get(i);
            if (o instanceof SDContiguousObservation) {
                obs = (SDContiguousObservation)o;
                this.sizes.add(new Integer(0));
            } else if (o instanceof SDDiscreteObservation) {
                obs = (SDDiscreteObservation)o;
                this.sizes.add(new Integer(0));
            } else {
                EditorPlugin.DBG.error("ObservationMerger got an observation that wasnt contigious or discrete (" + o.getClass() + ")");
                return;
            }
            ++i;
        }
        this.target_values = (BasicEList)this.target.getValue();
        this.target_times = (BasicEList)this.target.getCreationTime();
        while (true) {
            int i2 = 0;
            while (i2 < this.sources.size()) {
                int k;
                int vsize;
                EList times;
                EList values;
                SDContiguousObservation obs;
                Object o = this.sources.get(i2);
                int size = (Integer)this.sizes.get(i2);
                if (o instanceof SDContiguousObservation) {
                    obs = (SDContiguousObservation)o;
                    values = obs.getValue();
                    times = obs.getCreationTime();
                    vsize = values.size();
                    if (vsize != size) {
                        k = size;
                        while (k < vsize) {
                            this.addData((Double)values.get(k), (Double)times.get(k));
                            ++k;
                        }
                        this.sizes.set(i2, new Integer(values.size()));
                    }
                } else if (o instanceof SDDiscreteObservation) {
                    obs = (SDDiscreteObservation)o;
                    values = obs.getValue();
                    times = obs.getCreationTime();
                    vsize = values.size();
                    if (vsize != size) {
                        k = size;
                        while (k < vsize) {
                            this.addData(new Double(((Integer)values.get(k)).doubleValue()), (Double)times.get(k));
                            ++k;
                        }
                        this.sizes.set(i2, new Integer(values.size()));
                    }
                }
                ++i2;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    private void addData(Double d, Double l) {
        double tnew = l;
        double tcurr = Double.MAX_VALUE;
        int i = this.target_times.size();
        while (tcurr > tnew && i > 0) {
            tcurr = (Double)this.target_times.get(--i);
        }
        if (i < 0) {
            i = 0;
        }
        if (i != this.target_times.size()) {
            this.target_times.addUnique(++i, (Object)l);
            this.target_values.addUnique(i, (Object)d);
        } else {
            this.target_times.addUnique((Object)l);
            this.target_values.addUnique((Object)d);
        }
        if (this.target_times.size() != this.target_values.size()) {
            System.err.println("DIFFERENT SIZE BETWEEN TIME AND VALUES");
        }
    }
}

