/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.monitoractions.internal.cbe;

import java.text.SimpleDateFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.cbe.CBEControl;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.swt.widgets.Composite;

public class CBEAlertAction
implements AlertAction {
    public static final short SEVERITY_INFO = 10;
    public static final short SEVERITY_WARNING = 30;
    public static final short SEVERITY_MINOR_ERROR = 40;
    public static final short SEVERITY_FATAL_ERROR = 60;
    CBEFactory factory = CBEFactory.eINSTANCE;
    boolean trigger;
    String name;
    double value;
    double time;
    SDSnapshotObservation obs;
    static SimpleDateFormat sdf = new SimpleDateFormat();

    public AlertActionControl getControl(Composite c) {
        return new CBEControl(c, this);
    }

    public String getDescription() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_CBE");
    }

    public String getProviderName() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_CBE");
    }

    public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
        this.name = name;
        this.value = value;
        this.time = time;
        this.trigger = trigger;
        this.obs = obs;
    }

    public void run() {
        try {
            SDMemberDescriptor des = this.obs.getMemberDescriptor();
            TRCAgent agent = des.getAgent();
            while (agent == null) {
                des = des.getParent();
                agent = des.getAgent();
            }
            EList cbelog = agent.getDefaultEvents();
            CBEComponentIdentification sourceID = null;
            CBEComponentIdentification repID = null;
            String idtype = "Application";
            String sourceid = EditorPlugin.getString("ALERT_ACTION_SOURCEID");
            String sourcesubid = this.name;
            String message = this.trigger ? EditorPlugin.getString("ALERT_ALERT") + " " + this.name + " " + EditorPlugin.getString("ALERT_TRIGGERED_AT") + " " + this.value : EditorPlugin.getString("ALERT_ALERT") + " " + this.name + " " + EditorPlugin.getString("ALERT_RESET_AT") + " " + this.value;
            if (sourceID == null) {
                sourceID = this.factory.createCBEComponentIdentification();
                sourceID.setComponentIdType(idtype);
                sourceID.setComponent(sourceid);
                sourceID.setSubComponent(sourcesubid);
                sourceID.setLocationType("Application");
                sourceID.setLocation(sourceid);
            }
            if (repID == null) {
                repID = this.factory.createCBEComponentIdentification();
                repID.setComponentIdType(idtype);
                repID.setComponent(sourceid);
                repID.setSubComponent(sourcesubid);
                repID.setLocationType("Application");
                repID.setLocation(sourceid);
            }
            CBECommonBaseEvent event = this.factory.createCBECommonBaseEvent();
            event.setCreationTime(this.time * 1000.0);
            event.setMsg(message);
            event.setSeverity((short)30);
            event.setSourceComponentId(sourceID);
            event.setReporterComponentId(repID);
            event.setAgent(agent);
        }
        catch (Exception e) {
            EditorPlugin.DBG.warning("error logging alert to Common Base Event log " + e);
        }
    }

    public Object clone() {
        CBEAlertAction action = new CBEAlertAction();
        action.name = this.name;
        action.value = this.value;
        action.time = this.time;
        action.trigger = this.trigger;
        action.obs = this.obs;
        return action;
    }
}

