/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import java.util.Properties;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.email.EmailAlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.StatConAlertActionProvider;
import org.eclipse.jface.preference.IPreferenceStore;

public class EmailActionProvider
implements StatConAlertActionProvider {
    public static final String PREFS = "STATCON_ACTION_EMAIL__";
    public static final String TO = "to";
    public static final String FROM = "from";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String DOMAIN = "domain";

    public String getName() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_EMAIL");
    }

    public AlertAction newAlertAction() {
        return this.fromPreferenceStore(EditorPlugin.getDefault().getPreferenceStore());
    }

    public AlertAction fromPreferenceStore(IPreferenceStore props) {
        EmailAlertAction a = new EmailAlertAction();
        if (props.contains("STATCON_ACTION_EMAIL__host")) {
            a.host = props.getString("STATCON_ACTION_EMAIL__host");
        }
        if (props.contains("STATCON_ACTION_EMAIL__to")) {
            a.recipients = props.getString("STATCON_ACTION_EMAIL__to");
        }
        if (props.contains("STATCON_ACTION_EMAIL__from")) {
            a.sender = props.getString("STATCON_ACTION_EMAIL__from");
        }
        if (props.contains("STATCON_ACTION_EMAIL__port")) {
            a.port = props.getInt("STATCON_ACTION_EMAIL__port");
        }
        if (props.contains("STATCON_ACTION_EMAIL__domain")) {
            a.localhostDomain = props.getString("STATCON_ACTION_EMAIL__domain");
        }
        return a;
    }

    public void toPreferenceStore(IPreferenceStore props, AlertAction action) {
        EmailAlertAction a = (EmailAlertAction)action;
        props.setDefault("STATCON_ACTION_EMAIL__host", a.host);
        props.setDefault("STATCON_ACTION_EMAIL__to", a.recipients);
        props.setDefault("STATCON_ACTION_EMAIL__from", a.sender);
        props.setDefault("STATCON_ACTION_EMAIL__port", a.port);
        props.setDefault("STATCON_ACTION_EMAIL__domain", a.localhostDomain);
    }

    public AlertAction fromProperties(Properties props) {
        EmailAlertAction a = new EmailAlertAction();
        a.host = props.getProperty("STATCON_ACTION_EMAIL__host");
        a.recipients = props.getProperty("STATCON_ACTION_EMAIL__to");
        a.sender = props.getProperty("STATCON_ACTION_EMAIL__from");
        try {
            a.port = Integer.parseInt(props.getProperty("STATCON_ACTION_EMAIL__port"));
        }
        catch (Exception e) {
            // empty catch block
        }
        a.localhostDomain = props.getProperty("STATCON_ACTION_EMAIL__domain");
        return a;
    }

    public void toProperties(Properties props, AlertAction action) {
        EmailAlertAction a = (EmailAlertAction)action;
        props.setProperty("STATCON_ACTION_EMAIL__host", a.host);
        props.setProperty("STATCON_ACTION_EMAIL__to", a.recipients);
        props.setProperty("STATCON_ACTION_EMAIL__from", a.sender);
        props.setProperty("STATCON_ACTION_EMAIL__port", "" + a.port);
        props.setProperty("STATCON_ACTION_EMAIL__domain", a.localhostDomain);
    }
}

