/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.monitoractions.internal.sound;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.sound.SoundControl;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.swt.widgets.Composite;

public class SoundAlertAction
implements AlertAction {
    boolean trigger;
    String name;
    double value;
    double time;
    String path = "newsound.wav";
    static SimpleDateFormat sdf = new SimpleDateFormat();
    AudioClip player;

    public AlertActionControl getControl(Composite c) {
        return new SoundControl(c, this);
    }

    public String getDescription() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_SOUND") + " (" + this.path + ")";
    }

    public String getProviderName() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_SOUND");
    }

    public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
        this.name = name;
        this.value = value;
        this.time = time;
        this.trigger = trigger;
    }

    public void run() {
        SoundThread st = new SoundThread();
        st.start();
    }

    public Object clone() {
        SoundAlertAction action = new SoundAlertAction();
        action.name = this.name;
        action.value = this.value;
        action.time = this.time;
        action.trigger = this.trigger;
        action.path = this.path;
        return action;
    }

    class SoundThread
    extends Thread {
        public SoundThread() {
            this.setDaemon(true);
        }

        public void run() {
            long sleepFor = 1L;
            try {
                SoundAlertAction.this.player = Applet.newAudioClip(new URL("file:///" + SoundAlertAction.this.path));
                FileInputStream fin = new FileInputStream(SoundAlertAction.this.path);
                sleepFor = Math.max(1, fin.available());
                fin.close();
            }
            catch (MalformedURLException e) {
                EditorPlugin.DBG.warning("bad URL for sound " + SoundAlertAction.this.path);
            }
            catch (IOException e) {
                EditorPlugin.DBG.warning("couldnt get file length for sound " + SoundAlertAction.this.path);
                sleepFor = 20000L;
            }
            SoundAlertAction.this.player.play();
            EditorPlugin.DBG.info("sound thread exiting");
        }
    }
}

