/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;

public class TestGraphSource
implements GraphSource {
    public static final int SINE_WAVE = 0;
    public static final int COSINE_WAVE = 1;
    int type;
    double min;
    double max;

    public TestGraphSource(double min, double max, int type) {
        this.min = min;
        this.max = max;
        this.type = type;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getValueMin() {
        return 0.0;
    }

    public double getValueMax() {
        return 100.0;
    }

    public double getValueAt(double x) {
        if (this.type == 0) {
            return 50.0 + 50.0 * Math.sin(Math.toRadians(x / 60.0));
        }
        if (this.type == 1) {
            return 50.0 + 50.0 * Math.cos(Math.toRadians(x / 60.0));
        }
        return 0.0;
    }

    public double getAverageBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getSumBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getMaxBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getMinBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getCountBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getStandardDeviationBetween(double x, double x2) {
        return this.getValueAt(x);
    }
}

