/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.perfmon.internal.launchconfig;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PerfmonMainTab
extends AbstractLaunchConfigurationTab
implements KeyListener,
SelectionListener {
    ILaunchConfigurationDialog dialog;
    String DEF_HOST = "localhost";
    boolean isdirty = false;
    String message = null;
    String error_message = null;
    Composite mainpanel;
    Composite remotehost_panel;
    Label remotehost_label;
    Text remotehost_text;
    Label container_label;
    Text container_text;
    Button container_browse;
    Label monitor_label;
    Text monitor_text;
    Button monitor_browse;

    public void setMessage(String msg) {
        this.message = msg;
        if (this.message.length() == 0) {
            this.message = null;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setError(String msg) {
        this.error_message = msg;
        if (this.error_message.length() == 0) {
            this.error_message = null;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDirty(boolean b) {
        this.isdirty = b;
        this.checkForErrors();
        this.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite parent) {
        GridLayout glayout = new GridLayout();
        glayout.numColumns = 1;
        this.mainpanel = new Composite(parent, 0);
        this.mainpanel.setLayout((Layout)glayout);
        glayout = new GridLayout();
        glayout.numColumns = 3;
        glayout.marginWidth = 10;
        glayout.marginHeight = 10;
        glayout.horizontalSpacing = 10;
        glayout.verticalSpacing = 10;
        this.remotehost_panel = new Composite(this.mainpanel, 0);
        this.remotehost_panel.setLayout((Layout)glayout);
        this.remotehost_panel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.remotehost_label = new Label(this.remotehost_panel, 16384);
        this.remotehost_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)1, (int)1));
        this.remotehost_label.setText(PerfmonPlugin.getString("USE_RAC_HOST"));
        this.remotehost_text = new Text(this.remotehost_panel, 18436);
        this.remotehost_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.remotehost_text.setText(this.DEF_HOST);
        Label horizontal = new Label(this.remotehost_panel, 258);
        horizontal.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)3, (int)1, (int)4, (int)4));
        this.container_label = new Label(this.remotehost_panel, 16384);
        this.container_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.container_label.setText(PerfmonPlugin.getString("PROFILING_PROJECT"));
        this.container_text = new Text(this.remotehost_panel, 18436);
        this.container_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.container_browse = new Button(this.remotehost_panel, 0);
        this.container_browse.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)1, (int)4));
        this.container_text.setText("platform:/resource/" + PerfmonPlugin.getString("DEFAULT_PROFILING_PROJECT"));
        this.container_browse.setText(PerfmonPlugin.getString("BROWSE"));
        this.monitor_label = new Label(this.remotehost_panel, 16384);
        this.monitor_label.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.monitor_label.setText(PerfmonPlugin.getString("PROFILING_MONITOR"));
        this.monitor_text = new Text(this.remotehost_panel, 18436);
        this.monitor_text.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.monitor_text.setText(PerfmonPlugin.getString("DEFAULT_MONITOR"));
        this.monitor_browse = new Button(this.remotehost_panel, 0);
        this.monitor_browse.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)1, (int)4));
        this.monitor_browse.setText(PerfmonPlugin.getString("BROWSE"));
        this.monitor_browse.addSelectionListener((SelectionListener)this);
        this.container_browse.addSelectionListener((SelectionListener)this);
        this.container_text.addKeyListener((KeyListener)this);
        this.monitor_text.addKeyListener((KeyListener)this);
        this.remotehost_text.addKeyListener((KeyListener)this);
        this.checkForErrors();
    }

    public void keyPressed(KeyEvent e) {
        this.setDirty(true);
    }

    public void keyReleased(KeyEvent e) {
        this.setDirty(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.monitor_browse) {
            Object[] result;
            MonitorSelectionDialog mdialog = new MonitorSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), PerfmonPlugin.getString("PROFILING_DIALOG"));
            if (mdialog.open() == 0 && (result = mdialog.getResult()) != null && result.length == 1 && result[0] != null) {
                IPath path = (IPath)result[0];
                URI monitor_uri = URI.createPlatformResourceURI((String)path.toString());
                this.monitor_text.setText(monitor_uri.toString().replaceFirst("platform:/resource/", ""));
                this.setDirty(true);
            }
        } else if (e.getSource() == this.container_browse) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path container_savepath = null;
            IFolder container = null;
            try {
                container_savepath = new Path("" + this.container_text.getText());
                container = workspaceRoot.getFolder((IPath)container_savepath);
            }
            catch (Throwable x) {
                PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path " + this.container_text.getText());
            }
            PerfmonPlugin.DBG.info("showing container selection dialog");
            ContainerSelectionDialog dialog = null;
            dialog = new ContainerSelectionDialog(this.mainpanel.getShell(), (IContainer)container, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length > 0) {
                Path container_path = (Path)result[0];
                URI savepath = URI.createPlatformResourceURI((String)container_path.toString().replaceFirst("platform:/resource/", ""));
                this.container_text.setText("" + savepath);
                PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
                this.setDirty(true);
            }
        }
    }

    public Control getControl() {
        return this.mainpanel;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("remotehost_text", "localhost");
        configuration.setAttribute("smodel_container", "");
        configuration.setAttribute("monitor", PerfmonPlugin.getString("DEFAULT_MONITOR"));
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String s = URI.createPlatformResourceURI((String)workspace.getRoot().getProjects()[0].getFullPath().toString()).toString();
            configuration.setAttribute("smodel_container", s);
        }
        catch (Exception e) {
            PerfmonPlugin.DBG.error("problem getting default project", (Throwable)e);
        }
        configuration.setAttribute("statcon_file", "");
        this.checkForErrors();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setDirty(false);
        try {
            this.container_text.setText(configuration.getAttribute("smodel_container", "platform:/resource/" + PerfmonPlugin.getString("DEFAULT_PROFILING_PROJECT")));
            this.monitor_text.setText(configuration.getAttribute("monitor", PerfmonPlugin.getString("DEFAULT_MONITOR")));
            this.remotehost_text.setText(configuration.getAttribute("remotehost_text", this.DEF_HOST));
        }
        catch (CoreException e) {
            PerfmonPlugin.DBG.logVisibleError((Throwable)e, PerfmonPlugin.getString("ERROR_LAUNCH_CONFIG"), true);
        }
        this.checkForErrors();
    }

    public void dispose() {
        try {
            this.mainpanel.dispose();
        }
        catch (Throwable t) {}
    }

    private void printConfiguration(ILaunchConfiguration conf) {
        try {
            PerfmonPlugin.DBG.info(conf.getAttribute("smodel_container", "platform:/resource/" + PerfmonPlugin.getString("DEFAULT_PROFILING_PROJECT")));
            PerfmonPlugin.DBG.info(conf.getAttribute("monitor", PerfmonPlugin.getString("DEFAULT_MONITOR")));
            PerfmonPlugin.DBG.info(conf.getAttribute("statcon_file", ""));
            PerfmonPlugin.DBG.info(conf.getAttribute("remotehost_text", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.printConfiguration((ILaunchConfiguration)configuration);
        configuration.setAttribute("smodel_container", this.container_text.getText());
        configuration.setAttribute("monitor", this.monitor_text.getText());
        configuration.setAttribute("remotehost_text", this.remotehost_text.getText());
    }

    public void checkForErrors() {
        this.error_message = "";
        try {
            if (this.container_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_CONTAINER");
            }
            if (this.monitor_text.getText().length() == 0) {
                this.error_message = PerfmonPlugin.getString("BAD_MONITOR");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setError(this.error_message);
        this.updateLaunchConfigurationDialog();
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.error_message == null;
    }

    public boolean canSave() {
        return this.isdirty;
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.dialog;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.dialog = dialog;
    }

    public void launched(ILaunch launch) {
    }

    public String getName() {
        return PerfmonPlugin.getString("PERFMON_DEST_TAB");
    }

    public Image getImage() {
        return PerfmonPlugin.img.getImage("logo.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.initializeFrom((ILaunchConfiguration)workingCopy);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.performApply(workingCopy);
    }
}

