/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.utils.internal;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.DCAgentCommandUtil;
import org.eclipse.hyades.perfmon.utils.internal.SetVariableCommand;
import org.eclipse.hyades.perfmon.utils.internal.StatisticalLoaderListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.swt.widgets.Display;

public class DCAgentGenericLoader
implements DataProcessor,
ProcessListener,
AgentListener {
    private static final boolean PRINTXML = false;
    private boolean LOGXML = false;
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    DCAgentCommandUtil command = null;
    long started;
    String tracename;
    String process_exe;
    Node node;
    Process process;
    Agent agent;
    TRCAgent trcagent;
    boolean running = false;
    XMLLoader xloader;
    ArrayList listeners = new ArrayList();
    ModelListener adapter = new ModelListener();
    OutputStream logfile;
    IProgressMonitor pmonitor;
    boolean first = true;

    public DCAgentGenericLoader(IProgressMonitor pmonitor, long started, TRCAgent tagent, String modelname, String process_exe, String host, int port, SetVariableCommand[] commands, int freq) throws Exception {
        this.pmonitor = pmonitor;
        this.started = started;
        this.process_exe = process_exe;
        this.init(modelname, tagent, host, port, commands, freq);
    }

    public DCAgentGenericLoader(long started, TRCAgent tagent, String modelname, String process_exe, String host, SetVariableCommand[] commands, int freq) throws Exception {
        this.started = started;
        this.process_exe = process_exe;
        this.init(modelname, tagent, host, 10002, commands, freq);
    }

    public void processLaunched(Process process) {
    }

    public void processExited(Process process) {
        if (this.trcagent == null) {
            return;
        }
        TRCAgentProxy agentProxy = this.trcagent.getAgentProxy();
        if (agentProxy == null) {
            return;
        }
        TRCProcessProxy processProxy = this.trcagent.getAgentProxy().getProcessProxy();
        if (processProxy == null) {
            return;
        }
        agentProxy.setActive(false);
        agentProxy.setAttached(false);
        agentProxy.setMonitored(false);
        processProxy.setActive(false);
        final TRCAgentProxy agentTemp = agentProxy;
        Display d = Display.getDefault();
        d.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource((Object)agentTemp);
                event.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    public void agentActive(Agent agent) {
    }

    public void agentInactive(Agent agent) {
        this.processExited(this.process);
    }

    public void error(Agent agent, String errorId, String errorMessage) {
    }

    public void handleCommand(Agent agent, CommandElement command) {
    }

    public DCAgentCommandUtil getCommandUtil() {
        return this.command;
    }

    public void killProcess() throws Exception {
        this.node.killProcess(this.process);
    }

    public SDDescriptor getModel() {
        EList models = this.trcagent.getDescriptor();
        if (models.size() > 0) {
            return (SDDescriptor)models.get(0);
        }
        return null;
    }

    public void addLoaderListener(StatisticalLoaderListener listener) {
        this.listeners.add(listener);
    }

    public void removeLoaderListener(StatisticalLoaderListener listener) {
        this.listeners.add(listener);
    }

    private Agent findAgent(Node node) throws NotConnectedException {
        Agent agent = null;
        Enumeration processes = node.listProcesses();
        while (processes.hasMoreElements()) {
            Process p = (Process)processes.nextElement();
            PerfmonPlugin.DBG.info("checking RAC process " + p.getName());
            agent = this.findAgent(p);
            if (agent != null) break;
        }
        return agent;
    }

    private Agent findAgent(Process p) {
        if (p == null) {
            return null;
        }
        Enumeration agents = p.listAgents();
        Agent the_agent = null;
        if (!agents.hasMoreElements()) {
            PerfmonPlugin.DBG.info("found no agents in this process");
        }
        while (agents.hasMoreElements()) {
            Agent a = (Agent)agents.nextElement();
            PerfmonPlugin.DBG.info("found RAC agent " + a.getName() + "/" + a.getType() + " looking for " + this.process_exe);
            if (!a.getName().startsWith(this.process_exe) && !a.getType().startsWith(this.process_exe)) continue;
            try {
                if (a.isAttached()) continue;
                this.process = p;
                the_agent = a;
                PerfmonPlugin.DBG.info("agent called " + a.getName() + " not attached - accepting");
                break;
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("error checking agent " + e);
            }
        }
        return the_agent;
    }

    private void init(String modelname, TRCAgent trcagent, String host, int port, SetVariableCommand[] commands, int freq) throws Exception {
        block23: {
            this.trcagent = trcagent;
            SDView view = (SDView)trcagent.getView();
            if (view == null) {
                view = this.factory.createSDView();
                view.setAgent(trcagent);
                view.setName("view");
            }
            if (view.eContents().size() == 0) {
                SDSampleWindow window = this.factory.createSDSampleWindow();
                window.setView(view);
            }
            trcagent.getAgentProxy().eAdapters().add((Object)this.adapter);
            trcagent.eAdapters().add((Object)this.adapter);
            trcagent.getView().eAdapters().add((Object)this.adapter);
            EList windows = view.eContents();
            int k = 0;
            while (k < windows.size()) {
                SDSampleWindow window = (SDSampleWindow)windows.get(k);
                window.eAdapters().add((Object)this.adapter);
                ++k;
            }
            if (this.LOGXML) {
                try {
                    this.logfile = new FileOutputStream("C:\\temp\\XMLLOG.txt");
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            this.tracename = modelname;
            this.xloader = new XMLLoader(trcagent);
            PerfmonPlugin.DBG.warning("asked to connect to " + host + ":" + port);
            try {
                PerfmonPlugin.DBG.info("connecting to RAC");
                this.node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(port));
                if (this.pmonitor != null) {
                    this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONNECTING"));
                }
                PerfmonPlugin.DBG.info("connected to RAC");
                if (this.pmonitor != null) {
                    this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CREATING"));
                }
                this.agent = this.findAgent(this.node);
                if (this.agent == null) {
                    PerfmonPlugin.DBG.info("Launching RAC PerfmonAgent");
                    Process process = ProcessFactory.createProcess((Node)this.node, (String)this.process_exe);
                    if (process != null) {
                        ProcessAdapter adapter = new ProcessAdapter(process, null);
                        process.addProcessListener(new ProcessListener((IProcess)adapter){
                            private final /* synthetic */ IProcess val$adapter;
                            {
                                this.val$adapter = val$adapter;
                            }

                            public void processLaunched(Process p) {
                                UIPlugin.getDefault().registerLaunchProcess(this.val$adapter);
                            }

                            public void processExited(Process p) {
                                UIPlugin.getDefault().deregisterLaunchProcess(this.val$adapter);
                            }
                        });
                        ProcessLaunch launcher = new ProcessLaunch();
                        launcher.process = process;
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        display.syncExec((Runnable)launcher);
                        if (launcher.error != null) {
                            throw launcher.error;
                        }
                        long t = System.currentTimeMillis() + 8000L;
                        while (!process.isActive() && System.currentTimeMillis() < t) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        t = System.currentTimeMillis() + 25000L;
                        this.agent = this.findAgent(process);
                        while (this.agent == null && System.currentTimeMillis() < t) {
                            Thread.sleep(1250L);
                            this.agent = this.findAgent(this.node);
                        }
                    }
                }
                if (this.agent != null) {
                    this.command = new DCAgentCommandUtil(this.agent);
                    if (this.pmonitor != null) {
                        this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));
                    }
                    this.agent.addAgentListener((AgentListener)this);
                    this.process.addProcessListener((ProcessListener)this);
                    PerfmonPlugin.DBG.info("attaching to perfmon agent " + this.agent.getName());
                    this.running = true;
                    try {
                        trcagent.getAgentProxy().getProcessProxy().setPid(Integer.parseInt(this.agent.getProcess().getProcessId()));
                    }
                    catch (Exception e) {
                        PerfmonPlugin.DBG.error("could not set process proxy PID");
                    }
                    trcagent.getAgentProxy().setRuntimeId(this.process.getUUID());
                    LoadersUtils.registerAgentInstance((TRCAgentProxy)trcagent.getAgentProxy(), (Object)this.agent);
                    this.agent.attach();
                    this.agent.startMonitoring((DataProcessor)this);
                    trcagent.setRuntimeId(this.agent.getUUID());
                    PerfmonPlugin.DBG.info("attached To & Monitoring Perfmon Agent");
                    int x = 0;
                    while (x < commands.length) {
                        this.command.setVariable(commands[x]);
                        ++x;
                    }
                    this.command.setVariable(new SetVariableCommand("DC_WAITTIME", freq));
                    this.command.getUpdatedTree();
                    long t = System.currentTimeMillis();
                    break block23;
                }
                PerfmonPlugin.DBG.warning("no perfmon agent found");
                throw new Exception(PerfmonPlugin.getString("ERROR_CREATE_PERFMON_AGENT"));
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("problem initialising loader");
                throw e;
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        block2: {
            this.running = false;
            PerfmonPlugin.DBG.info("shutdown");
            if (this.agent == null) break block2;
            try {
                PerfmonPlugin.DBG.info("detaching from agent");
                this.agent.stopMonitoring();
                this.agent.detach();
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("failed to detach from agent", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public void incoming(String msg) {
    }

    private byte[] stringToBytes(String s) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            bout.write((byte)s.charAt(i));
            ++i;
        }
        return bout.toByteArray();
    }

    public void incommingData(byte[] buffer, int length, InetAddress peer) {
        if (this.LOGXML) {
            try {
                this.logfile.write(buffer, 0, length);
            }
            catch (Throwable t) {
                this.LOGXML = false;
            }
        }
        if ((length = (buffer = new String(buffer, 0, length).trim().getBytes()).length) == 0) {
            return;
        }
        if (this.first) {
            byte[] ROOT_START = "<TRACE>".getBytes();
            this.xloader.loadEvent(ROOT_START, ROOT_START.length);
            this.first = false;
        }
        try {
            this.xloader.loadEvent(buffer, length);
        }
        catch (Throwable t) {
            PerfmonPlugin.DBG.error("unable to parse message " + new String(buffer, 0, 30) + "...", t);
        }
    }

    public void incommingData(char[] buffer, int length, InetAddress peer) {
    }

    public void invalidDataType(byte[] data, int length, InetAddress peer) {
        PerfmonPlugin.DBG.warning("invalid datatype");
    }

    public void waitingForData() {
    }

    class ModelListener
    extends AdapterImpl {
        ModelListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 3) {
                Object newValue = notification.getNewValue();
                boolean notify = false;
                SDDescriptor parent = null;
                if (newValue instanceof SDDescriptor) {
                    notify = true;
                    parent = ((SDDescriptor)newValue).getParent();
                    ((SDDescriptor)newValue).eAdapters().add((Object)DCAgentGenericLoader.this.adapter);
                } else if (newValue instanceof SDSnapshotObservation) {
                    notify = true;
                    parent = ((SDSnapshotObservation)newValue).getMemberDescriptor();
                }
                if (notify) {
                    int i = 0;
                    while (i < DCAgentGenericLoader.this.listeners.size()) {
                        StatisticalLoaderListener listener = (StatisticalLoaderListener)DCAgentGenericLoader.this.listeners.get(i);
                        listener.modelChanged(parent);
                        ++i;
                    }
                }
            }
        }
    }

    class ProcessLaunch
    implements Runnable {
        Exception error = null;
        Process process;

        ProcessLaunch() {
        }

        public void run() {
            try {
                this.process.launch();
            }
            catch (Exception e) {
                this.error = e;
            }
        }
    }
}

