/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.utils.internal.launch;

import java.net.UnknownHostException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.launch.HostUpdater;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HostUI
extends HostUpdater
implements SelectionListener,
ModifyListener {
    private Button _delete;
    private Button _add;
    private Text _host;
    private Text _port;
    private Table _list;
    private String DEFAULT_PORT = "10002";
    private String agentname;

    public HostUI(String agentname) {
        this.agentname = agentname;
    }

    public void addHost() {
        this.addHost(this._host.getText().trim() + ":" + this._port.getText().trim());
        this._host.setText("");
        this._port.setText(this.DEFAULT_PORT);
        this._host.setFocus();
    }

    public void addHost(String text) {
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (text.equals(this._list.getItem(idx).getText())) {
                return;
            }
            ++idx;
        }
        TableItem item = new TableItem(this._list, 0);
        item.setText(text);
        item.setImage(PerfmonPlugin.img.getImage("node.gif"));
        this._list.setSelection(new TableItem[]{item});
    }

    private void addHosts(String hosts) {
        if (hosts != null && !hosts.equals("")) {
            int idx = 0;
            while (idx != -1) {
                idx = hosts.indexOf(",");
                if (idx != -1) {
                    String host = hosts.substring(0, idx);
                    this.addHost(host);
                    hosts = hosts.substring(idx + 1);
                    continue;
                }
                this.addHost(hosts);
            }
        }
    }

    public Composite createControl(Composite parent) {
        GridData data = new GridData();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(1808));
        Label desc = new Label(result, 0);
        GridData data2 = new GridData(768);
        data2.horizontalSpan = 3;
        desc.setLayoutData((Object)data2);
        desc.setText(PerfmonPlugin.getString("STR_PREF_HOST_NODE"));
        Composite dataGroup = new Composite(result, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.numColumns = 1;
        layout2.verticalSpacing = 10;
        dataGroup.setLayout((Layout)layout2);
        dataGroup.setLayoutData((Object)new GridData(1808));
        this._list = new Table(dataGroup, 2304);
        this._list.setLayoutData((Object)new GridData(1808));
        Composite bottomWidget = new Composite(dataGroup, 0);
        bottomWidget.setLayoutData((Object)new GridData(768));
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 2;
        bottomWidget.setLayout((Layout)layout3);
        Label hostLabel = new Label(bottomWidget, 0);
        hostLabel.setText(PerfmonPlugin.getString("STR_PREF_HOST_IP"));
        this._host = new Text(bottomWidget, 2048);
        this._host.setLayoutData((Object)new GridData(768));
        Label portLabel = new Label(bottomWidget, 0);
        portLabel.setText(PerfmonPlugin.getString("RAC_PORT_TEXT"));
        this._port = new Text(bottomWidget, 2048);
        this._port.setLayoutData((Object)new GridData(768));
        this._port.setText(this.DEFAULT_PORT);
        Composite buttonWidget = new Composite(result, 0);
        buttonWidget.setLayoutData((Object)new GridData(1296));
        GridLayout layout4 = new GridLayout();
        layout4.numColumns = 1;
        buttonWidget.setLayout((Layout)layout4);
        Composite buttonWidget1 = new Composite(buttonWidget, 0);
        buttonWidget1.setLayoutData((Object)new GridData(1808));
        GridLayout layout5 = new GridLayout();
        layout5.numColumns = 1;
        buttonWidget1.setLayout((Layout)layout5);
        this._delete = new Button(buttonWidget1, 0);
        this._delete.setLayoutData((Object)new GridData(768));
        this._delete.setText("     " + PerfmonPlugin.getString("DELETE") + "     ");
        Label l = new Label(buttonWidget1, 0);
        l.setLayoutData((Object)new GridData(1040));
        Composite buttonWidget2 = new Composite(buttonWidget, 0);
        GridLayout layout6 = new GridLayout();
        layout6.numColumns = 1;
        buttonWidget2.setLayout((Layout)layout6);
        buttonWidget2.setLayoutData((Object)new GridData(768));
        this._add = new Button(buttonWidget2, 0);
        this._add.setLayoutData((Object)new GridData(768));
        this._add.setText(PerfmonPlugin.getString("STR_PREF_ADD"));
        this._add.addSelectionListener((SelectionListener)this);
        this._delete.addSelectionListener((SelectionListener)this);
        this._list.addSelectionListener((SelectionListener)this);
        this._host.addModifyListener((ModifyListener)this);
        this._port.addModifyListener((ModifyListener)this);
        this._add.setEnabled(false);
        this._delete.setEnabled(false);
        this.initializeValues();
        this._host.setFocus();
        this._host.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    if (HostUI.this._host.getText().trim() == "" || HostUI.this._port.getText().trim() == "") {
                        return;
                    }
                    HostUI.this.addHost();
                    e.doit = false;
                }
            }
        });
        return result;
    }

    public Table getListUI() {
        return this._list;
    }

    public Text getHostUI() {
        return this._host;
    }

    public Text getPortUI() {
        return this._port;
    }

    public Button getDeleteUI() {
        return this._delete;
    }

    public Button getAddUI() {
        return this._add;
    }

    private void deleteHost() {
        int i = this._list.getSelectionIndex();
        if (i != -1) {
            this._list.remove(i);
        }
    }

    public String getHost() {
        String name = null;
        int idx = this._list.getSelectionIndex();
        if (idx == -1) {
            return name;
        }
        name = this._list.getItem(idx).getText();
        int id = name.indexOf(":");
        if (id != -1) {
            name = name.substring(0, id);
        }
        return name;
    }

    public int getPort() {
        int id;
        String port = this.DEFAULT_PORT;
        int idx = this._list.getSelectionIndex();
        if (idx != -1) {
            port = this._list.getItem(idx).getText();
        }
        port = (id = port.indexOf(":")) != -1 ? port.substring(id + 1) : this.DEFAULT_PORT;
        return Integer.parseInt(port);
    }

    public boolean isLocalHost(String hostname) {
        String name = "localhost";
        if (name.equals(hostname)) {
            return true;
        }
        try {
            Node fnode = NodeFactory.createNode((String)name);
            name = fnode.getInetAddress().getHostName();
        }
        catch (UnknownHostException exc) {
            return false;
        }
        return hostname.equals(name);
    }

    public TableItem[] getHosts() {
        return this._list.getItems();
    }

    private void initializeValues() {
        IPreferenceStore store = PerfmonPlugin.getDefault().getPreferenceStore();
        String hosts = store.getString("ATTR_HOST" + this.agentname);
        this.addHosts(hosts);
        this.enableButtons();
    }

    public void modifyText(ModifyEvent e) {
        block4: {
            block3: {
                if (e.widget != this._host) break block3;
                this._add.setEnabled(!this._host.getText().trim().equals("") && !this._port.getText().trim().equals(""));
                break block4;
            }
            if (e.widget != this._port) break block4;
            try {
                int value = Integer.parseInt(this._port.getText().trim());
                if (value < 0 || value > 65535) {
                    this._add.setEnabled(false);
                    return;
                }
                this._add.setEnabled(!this._host.getText().trim().equals("") && !this._port.getText().trim().equals(""));
            }
            catch (NumberFormatException nfe) {
                this._add.setEnabled(false);
            }
        }
    }

    public void reset() {
        this._list.removeAll();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void enableButtons() {
        this._delete.setEnabled(this._list.getSelectionIndex() != -1);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._add) {
            this.addHost();
            this.enableButtons();
            this.changed();
        } else if (e.widget == this._delete) {
            this.deleteHost();
            this.enableButtons();
            this.changed();
        } else if (e.widget == this._list) {
            TableItem[] selected = this._list.getSelection();
            this.enableButtons();
            this._list.setSelection(selected);
            this.changed();
        }
    }

    public void selectHost(String hostname) {
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            if (hostname.equals(this._list.getItem(idx).getText())) {
                this._list.setSelection(idx);
                return;
            }
            ++idx;
        }
    }
}

