/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.net.InetAddress;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor2;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;

public class XMLExecutionDataProcessor
extends XMLLoader
implements DataServerListener,
IExecutionHarnessDataProcessor2 {
    private final String START_TAG = "<EXECUTION>";
    private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    public static final String IID = "org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor";
    private ITest test = null;
    private Agent controlAgent = null;
    private Process process = null;
    private static final HashMap contextMap = new HashMap();
    private String executionResultName;
    private boolean overrideExistingExcResult = false;
    private String executionResultLocation;

    public XMLExecutionDataProcessor() {
        super((TRCMonitor)null);
    }

    protected boolean isIgnoredElement() {
        if (this.startDocument) {
            if (this.currentElementName == null) {
                return true;
            }
            if (this.currentElementName.equals("EXECUTION")) {
                return true;
            }
            this.startDocument = false;
        }
        return false;
    }

    protected boolean isValidTag(String buf) {
        return !buf.startsWith(this.START_TAG) && !buf.startsWith(this.XML_VERSION_TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataServerExited() {
        ExecutionContext eContext;
        ExecutionContext executionContext = eContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
        synchronized (executionContext) {
            if (eContext.decrementAgentCount() == 0) {
                contextMap.remove(this.executionResultLocation + "/" + this.executionResultName);
                Thread contextCleaner = new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        eContext.cleanUp();
                    }
                };
                contextCleaner.setName("context cleanup");
                contextCleaner.start();
            }
        }
        this.cleanUp();
    }

    public void incommingData(byte[] buffer, int length, InetAddress peer) {
        try {
            super.loadEvent(buffer, length);
        }
        catch (InvalidXMLException e) {}
    }

    public void incommingData(char[] buffer, int length, InetAddress peer) {
        byte[] newBuffer = new byte[length];
        int i = 0;
        while (i < length) {
            newBuffer[i] = (byte)buffer[i];
            ++i;
        }
        this.incommingData(newBuffer, newBuffer.length, peer);
    }

    public void invalidDataType(byte[] data, int length, InetAddress peer) {
    }

    public void waitingForData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.defaultLoader = new IgnoredXMLFragmentLoader();
        if (!(this.getTest() instanceof TPFTestSuite)) {
            return;
        }
        ExecutionContext eContext = null;
        HashMap hashMap = contextMap;
        synchronized (hashMap) {
            eContext = (ExecutionContext)contextMap.get(this.executionResultLocation + "/" + this.executionResultName);
            TPFTestSuite suite = (TPFTestSuite)this.getTest();
            if (eContext == null) {
                eContext = new ExecutionContext(suite, suite.getId(), this.executionResultLocation, this.executionResultName, this.overrideExistingExcResult);
                contextMap.put(this.executionResultLocation + "/" + this.executionResultName, eContext);
            }
        }
        eContext.incrementAgentCount();
        this.context.getCustomData().put(ExecutionContext.root, eContext);
    }

    public IConfigurationElement getConfigElement() {
        return null;
    }

    public String getID() {
        return IID;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setConfigElement(IConfigurationElement theElement) {
    }

    public ITest getTest() {
        return this.test;
    }

    public Agent getControlAgent() {
        return this.controlAgent;
    }

    public void setControlAgent(Agent agent) {
        this.controlAgent = agent;
    }

    public void setInitData(ITest test, String hostName, String executionResultName, String executionResultLocation, String portNumber) {
        this.setInitData(test, hostName, executionResultName, executionResultLocation, false, portNumber);
    }

    public void setInitData(ITest theTest, String hostName, String executionResultName, String executionResultLocation, boolean overwriteExistingResults, String portNumber) {
        this.test = theTest;
        this.executionResultName = executionResultName;
        this.overrideExistingExcResult = overwriteExistingResults;
        this.executionResultLocation = executionResultLocation;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }
}

