/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.util.TimeUtil;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DrawableToolTip
implements PaintListener {
    private Composite parent = null;
    private Shell toolTipShell = null;
    private double min;
    private double max;
    private double currentValue;
    private static int H_MARGIN = 10;
    private static int V_MARGIN = 10;
    private static int TEXT_SCALE_MARGIN = 20;
    private static int SCALE_LENGTH = 100;
    private String unitName = null;
    protected String msg;
    private Color[] col;

    public DrawableToolTip(Composite _parent) {
        this.parent = _parent;
        this.toolTipShell = new Shell(this.parent.getShell(), 16384);
        this.toolTipShell.setLayout((Layout)new RowLayout());
        this.toolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.toolTipShell.addPaintListener((PaintListener)this);
        this.toolTipShell.setSize(200, 50);
        this.col = new Color[10];
        this.col[0] = new Color((Device)Display.getDefault(), 255, 229, 229);
        this.col[1] = new Color((Device)Display.getDefault(), 255, 204, 204);
        this.col[2] = new Color((Device)Display.getDefault(), 255, 178, 178);
        this.col[3] = new Color((Device)Display.getDefault(), 255, 153, 153);
        this.col[4] = new Color((Device)Display.getDefault(), 255, 127, 127);
        this.col[5] = new Color((Device)Display.getDefault(), 255, 102, 102);
        this.col[6] = new Color((Device)Display.getDefault(), 255, 76, 76);
        this.col[7] = new Color((Device)Display.getDefault(), 255, 51, 51);
        this.col[8] = new Color((Device)Display.getDefault(), 255, 25, 25);
        this.col[9] = new Color((Device)Display.getDefault(), 255, 0, 0);
    }

    public void showToolTip(double _value, double _min, double _max, String unit) {
        this.min = _min;
        this.max = _max;
        this.currentValue = _value;
        this.unitName = unit;
        int w = this.toolTipShell.getBounds().width;
        int h = this.toolTipShell.getBounds().height;
        Point hr = Display.getDefault().getCursorLocation();
        this.toolTipShell.setBounds(hr.x, hr.y + 26, w, h);
        this.toolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.toolTipShell.setVisible(false);
    }

    public void paintControl(PaintEvent event) {
        this.msg = TimeUtil.timeToString(this.currentValue);
        Point size = event.gc.textExtent(this.msg);
        if (size.x < SCALE_LENGTH) {
            size.x = SCALE_LENGTH;
        }
        event.gc.drawText(this.msg, H_MARGIN, V_MARGIN, true);
        event.gc.drawLine(H_MARGIN, V_MARGIN + TEXT_SCALE_MARGIN + size.y, H_MARGIN + SCALE_LENGTH, V_MARGIN + TEXT_SCALE_MARGIN + size.y);
        int step = SCALE_LENGTH / 10;
        double gr = (this.max - this.min) / 10.0;
        double delta = this.currentValue - this.min;
        int colIndex = 0;
        if (gr != 0.0) {
            colIndex = Math.round((float)(delta / gr));
            if (colIndex > this.col.length) {
                colIndex = this.col.length;
            } else if (colIndex <= 1) {
                colIndex = 1;
            }
        } else {
            colIndex = 1;
        }
        int i = 0;
        while (i <= 10) {
            if (i < 10) {
                event.gc.setBackground(this.col[i]);
            }
            if (i < colIndex && i < 10) {
                event.gc.fillRectangle(H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y - 5, step, 11);
            }
            if (i == 0) {
                event.gc.drawText(SDViewerPlugin.getResourceString("MIN_LABEL"), H_MARGIN, size.y + 2 * V_MARGIN + TEXT_SCALE_MARGIN, true);
            }
            if (i == 0) {
                int len = event.gc.textExtent((String)SDViewerPlugin.getResourceString((String)"MAX_LABEL")).x;
                event.gc.drawText(SDViewerPlugin.getResourceString("MAX_LABEL"), H_MARGIN + SCALE_LENGTH - len + 1, size.y + 2 * V_MARGIN + TEXT_SCALE_MARGIN, true);
            }
            int lineWidth = 10;
            if (i == 0 || i == 10) {
                lineWidth = 14;
            }
            event.gc.drawLine(H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y - lineWidth / 2, H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y + lineWidth / 2);
            ++i;
        }
        this.toolTipShell.setSize(size.x + 2 * H_MARGIN + 2, 2 * size.y + 3 * V_MARGIN + TEXT_SCALE_MARGIN);
    }

    public String getText() {
        return this.msg;
    }

    public String getAccessibleText() {
        return TimeUtil.accessibleTimeToString(this.currentValue);
    }

    public void dispose() {
        int i = 0;
        while (i < this.col.length) {
            this.col[i].dispose();
            ++i;
        }
    }
}

