/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IFont;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ColorImpl;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class NGC
implements IGC {
    protected GC context;
    protected SDWidget view;
    private Font tempFont = null;
    private IColor gradientColor = null;
    private IColor backGround = null;
    private IColor foreGround = null;
    private int y_;
    private int x_;
    private int yx;
    private int xx;
    private boolean drawWithFocus = false;
    private static int vscreen_bounds = 0;

    public NGC(SDWidget scrollView, GC gc) {
        this.context = gc;
        this.view = scrollView;
    }

    public void setLineStyle(int style) {
        this.context.setLineStyle(style);
    }

    public int getLineStyle() {
        return this.context.getLineStyle();
    }

    public int getContentsX() {
        return Math.round((float)this.view.getContentsX() / this.view.zoomValue);
    }

    public int getContentsY() {
        return Math.round((float)this.view.getContentsY() / this.view.zoomValue);
    }

    public int getVisibleWidth() {
        return Math.round((float)this.view.getVisibleWidth() / this.view.zoomValue);
    }

    public int getVisibleHeight() {
        return Math.round((float)this.view.getVisibleHeight() / this.view.zoomValue);
    }

    public int contentsToViewX(int x) {
        return this.view.contentsToViewX(x);
    }

    public int contentsToViewY(int y) {
        return this.view.contentsToViewY(y);
    }

    private byte code(int x, int y) {
        byte c = 0;
        this.y_ = vscreen_bounds;
        this.x_ = vscreen_bounds;
        this.yx = this.view.getVisibleHeight() + vscreen_bounds;
        this.xx = this.view.getVisibleWidth() + vscreen_bounds;
        if (y > this.yx) {
            c = (byte)(c | 1);
        } else if (y < this.y_) {
            c = (byte)(c | 2);
        }
        if (x > this.xx) {
            c = (byte)(c | 4);
        } else if (x < this.x_) {
            c = (byte)(c | 8);
        }
        return c;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        x1 = Math.round((float)x1 * this.view.zoomValue);
        y1 = Math.round((float)y1 * this.view.zoomValue);
        x2 = Math.round((float)x2 * this.view.zoomValue);
        y2 = Math.round((float)y2 * this.view.zoomValue);
        x1 = this.view.contentsToViewX(x1);
        y1 = this.view.contentsToViewY(y1);
        x2 = this.view.contentsToViewX(x2);
        y2 = this.view.contentsToViewY(y2);
        byte code1 = this.code(x1, y1);
        byte code2 = this.code(x2, y2);
        boolean draw = false;
        boolean end = false;
        int x = 0;
        int y = 0;
        do {
            byte codex;
            if (code1 == 0 && code2 == 0) {
                draw = true;
                end = true;
                continue;
            }
            if ((code1 & code2) != 0) {
                end = true;
                continue;
            }
            byte by = codex = code1 != 0 ? code1 : code2;
            if ((codex & 1) != 0) {
                x = x1 + (x2 - x1) * (this.yx - y1) / (y2 - y1);
                y = this.yx;
            } else if ((codex & 2) != 0) {
                x = x1 + (x2 - x1) * (this.y_ - y1) / (y2 - y1);
                y = this.y_;
            } else if ((codex & 4) != 0) {
                y = y1 + (y2 - y1) * (this.xx - x1) / (x2 - x1);
                x = this.xx;
            } else if ((codex & 8) != 0) {
                y = y1 + (y2 - y1) * (this.x_ - x1) / (x2 - x1);
                x = this.x_;
            }
            if (codex == code1) {
                x1 = x;
                y1 = y;
                code1 = this.code(x1, y1);
                continue;
            }
            x2 = x;
            y2 = y;
            code2 = this.code(x2, y2);
        } while (!end);
        if (draw) {
            this.context.drawLine(x1, y1, x2, y2);
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        x = Math.round((float)x * this.view.zoomValue);
        if (y != this.getContentsY()) {
            y = Math.round((float)y * this.view.zoomValue);
            y = this.view.contentsToViewY(y);
        } else {
            y = 0;
        }
        width = Math.round((float)width * this.view.zoomValue);
        height = Math.round((float)height * this.view.zoomValue);
        x = this.view.contentsToViewX(x);
        if (x < -vscreen_bounds) {
            width = width + x + vscreen_bounds;
            x = -vscreen_bounds;
        }
        if (y < -vscreen_bounds) {
            height = height + y + vscreen_bounds;
            y = -vscreen_bounds;
        }
        if (width < -vscreen_bounds && x + width < -vscreen_bounds) {
            width = -vscreen_bounds;
        } else if (width + x > this.view.getVisibleWidth() + vscreen_bounds) {
            width = this.view.getVisibleWidth() + vscreen_bounds - x;
        }
        if (height < -vscreen_bounds && y + height < -vscreen_bounds) {
            height = -vscreen_bounds;
        } else if (height + y > this.view.getVisibleHeight() + vscreen_bounds) {
            height = this.view.getVisibleHeight() + vscreen_bounds - y;
        }
        this.context.drawRectangle(x, y, width, height);
    }

    public void drawFocus(int x, int y, int width, int height) {
        IColor bC = this.getBackground();
        IColor fC = this.getForeground();
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        x = Math.round((float)x * this.view.zoomValue);
        y = Math.round((float)y * this.view.zoomValue);
        width = Math.round((float)width * this.view.zoomValue);
        height = Math.round((float)height * this.view.zoomValue);
        this.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        this.setBackground(Frame.getUserPref().getBackGroundColorSelection());
        this.context.drawFocus(this.view.contentsToViewX(x - 1), this.view.contentsToViewY(y - 1), width + 3, height + 3);
        this.setBackground(bC);
        this.setForeground(fC);
    }

    public void fillPolygon(int[] points) {
        int len = points.length / 2 * 2;
        int[] localPoint = new int[len];
        int i = 0;
        while (i < len) {
            localPoint[i] = this.view.contentsToViewX(Math.round((float)points[i] * this.view.zoomValue));
            localPoint[++i] = this.view.contentsToViewY(Math.round((float)points[i] * this.view.zoomValue));
            ++i;
        }
        this.context.fillPolygon(localPoint);
    }

    public void drawPolygon(int[] points) {
        int len = points.length / 2 * 2;
        int[] localPoint = new int[len];
        int i = 0;
        while (i < len) {
            localPoint[i] = this.view.contentsToViewX(Math.round((float)points[i] * this.view.zoomValue));
            localPoint[++i] = this.view.contentsToViewY(Math.round((float)points[i] * this.view.zoomValue));
            ++i;
        }
        this.context.drawPolygon(localPoint);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        x = Math.round((float)x * this.view.zoomValue);
        if (y != this.getContentsY()) {
            y = Math.round((float)y * this.view.zoomValue);
            y = this.view.contentsToViewY(y) + 1;
        } else {
            y = 1;
        }
        width = Math.round((float)width * this.view.zoomValue) - 1;
        height = Math.round((float)height * this.view.zoomValue) - 1;
        x = this.view.contentsToViewX(x) + 1;
        if (x < -vscreen_bounds) {
            width = width + x + vscreen_bounds;
            x = -vscreen_bounds;
        }
        if (y < -vscreen_bounds) {
            height = height + y + vscreen_bounds;
            y = -vscreen_bounds;
        }
        if (width < -vscreen_bounds && x + width < -vscreen_bounds) {
            width = -vscreen_bounds;
        } else if (width + x > this.view.getVisibleWidth() + vscreen_bounds) {
            width = this.view.getVisibleWidth() + vscreen_bounds - x;
        }
        if (height < -vscreen_bounds && y + height < -vscreen_bounds) {
            height = -vscreen_bounds;
        } else if (height + y > this.view.getVisibleHeight() + vscreen_bounds) {
            height = this.view.getVisibleHeight() + vscreen_bounds - y;
        }
        this.context.fillRectangle(x, y, width, height);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        x = Math.round((float)x * this.view.zoomValue);
        y = Math.round((float)y * this.view.zoomValue);
        width = Math.round((float)width * this.view.zoomValue);
        height = Math.round((float)height * this.view.zoomValue);
        IColor tempColor = this.foreGround;
        this.setForeground(this.gradientColor);
        x = this.view.contentsToViewX(x);
        y = this.view.contentsToViewY(y);
        if (vertical) {
            height = height > 0 ? ++height : --height;
            this.context.fillGradientRectangle(x, y, width, height, vertical);
            this.setForeground(tempColor);
        } else {
            if (x < -vscreen_bounds) {
                width = width + x + vscreen_bounds;
                x = -vscreen_bounds;
            }
            if (y < -vscreen_bounds) {
                height = height + y + vscreen_bounds;
                y = -vscreen_bounds;
            }
            if (width < -vscreen_bounds && x + width < -vscreen_bounds) {
                width = -vscreen_bounds;
            } else if (width + x > this.view.getVisibleWidth() + vscreen_bounds) {
                width = this.view.getVisibleWidth() + vscreen_bounds - x;
            }
            if (height < -vscreen_bounds && y + height < -vscreen_bounds) {
                height = -vscreen_bounds;
            } else if (height + y > this.view.getVisibleHeight() + vscreen_bounds) {
                height = this.view.getVisibleHeight() + vscreen_bounds - y;
            }
            this.context.fillGradientRectangle(x + width, y, -width, height + 1, vertical);
            this.setForeground(tempColor);
        }
    }

    public int textExtent(String name) {
        return this.context.textExtent((String)name).x;
    }

    public void drawText(String string, int x, int y, boolean trans) {
        x = Math.round((float)x * this.view.zoomValue);
        y = Math.round((float)y * this.view.zoomValue);
        this.context.drawText(string, this.view.contentsToViewX(x), this.view.contentsToViewY(y), trans);
        if (this.drawWithFocus) {
            Point r = this.context.textExtent(string);
            this.context.drawFocus(x - 1, y - 1, r.x + 2, r.y + 2);
        }
    }

    public void drawText(String string, int x, int y) {
        x = Math.round((float)x * this.view.zoomValue);
        y = Math.round((float)y * this.view.zoomValue);
        this.context.drawText(string, this.view.contentsToViewX(x), this.view.contentsToViewY(y), true);
        if (this.drawWithFocus) {
            Point r = this.context.textExtent(string);
            this.context.drawFocus(x - 1, y - 1, r.x + 2, r.y + 2);
        }
    }

    public void fillOval(int x, int y, int width, int height) {
        x = Math.round((float)x * this.view.zoomValue);
        y = Math.round((float)y * this.view.zoomValue);
        width = Math.round((float)width * this.view.zoomValue);
        height = Math.round((float)height * this.view.zoomValue);
        this.context.fillOval(this.view.contentsToViewX(x), this.view.contentsToViewY(y), width, height);
    }

    public IColor getBackground() {
        if (this.backGround != null && this.backGround.getColor() instanceof Color && !((Color)this.backGround.getColor()).isDisposed()) {
            return this.backGround;
        }
        return ColorImpl.getSystemColor(1);
    }

    public IColor getForeground() {
        if (this.foreGround != null && this.foreGround.getColor() instanceof Color && !((Color)this.foreGround.getColor()).isDisposed()) {
            return this.foreGround;
        }
        return ColorImpl.getSystemColor(1);
    }

    public void setBackground(IColor color) {
        if (color == null) {
            return;
        }
        if (color.getColor() instanceof Color) {
            this.context.setBackground((Color)color.getColor());
            this.backGround = color;
        }
    }

    public void setForeground(IColor color) {
        Color c;
        if (color == null) {
            return;
        }
        if (color.getColor() instanceof Color && !(c = (Color)color.getColor()).isDisposed()) {
            this.context.setForeground(c);
            this.foreGround = color;
        }
    }

    public void setGradientColor(IColor color) {
        if (color == null) {
            return;
        }
        if (color.getColor() instanceof Color) {
            this.gradientColor = color;
        }
    }

    public void setLineWidth(int width) {
        this.context.setLineWidth(width);
    }

    public int getLineWidth() {
        return this.context.getLineWidth();
    }

    private void localDrawText(String string, int x, int y, boolean trans) {
        Point r = this.context.textExtent(string);
        if (!trans) {
            this.context.fillRectangle(x, y, r.x, r.y);
        }
        this.context.drawText(string, x, y, trans);
        if (this.drawWithFocus && string.length() > 1) {
            this.context.drawFocus(x - 1, y - 1, r.x + 2, r.y + 2);
        }
    }

    public void drawTextTruncatedCentred(String name, int _x, int _y, int width, int height, boolean trans) {
        Point tx = this.context.textExtent(name);
        _x = Math.round((float)_x * this.view.zoomValue);
        int y = 0;
        if (_y != this.getContentsY()) {
            _y = Math.round((float)_y * this.view.zoomValue);
            y = this.view.contentsToViewY(_y);
        }
        width = Math.round((float)width * this.view.zoomValue);
        height = Math.round((float)height * this.view.zoomValue);
        int x = this.view.contentsToViewX(_x);
        if (tx.y > height) {
            return;
        }
        if (tx.x <= width) {
            this.localDrawText(name, x + 1 + (width - tx.x) / 2, y + 1 + (height - tx.y) / 2, trans);
        } else {
            String nameToDisplay = name;
            int i = name.length() - 1;
            while (i >= 0 && this.context.textExtent((String)nameToDisplay).x >= width) {
                nameToDisplay = name.substring(0, i);
                --i;
            }
            int dotCount = 0;
            int i2 = 1;
            while (i2 <= 3 && nameToDisplay.length() - i2 > 0) {
                ++dotCount;
                ++i2;
            }
            nameToDisplay = nameToDisplay.substring(0, nameToDisplay.length() - dotCount);
            int i3 = 0;
            while (i3 < dotCount) {
                nameToDisplay = nameToDisplay + ".";
                ++i3;
            }
            this.localDrawText(nameToDisplay, x + 1 + (width - this.context.textExtent((String)nameToDisplay).x) / 2, y + 1 + (height - this.context.textExtent((String)nameToDisplay).y) / 2, trans);
        }
    }

    public void drawTextTruncated(String name, int _x, int _y, int width, int height, boolean trans) {
        _x = Math.round((float)_x * this.view.zoomValue);
        _y = Math.round((float)_y * this.view.zoomValue);
        width = Math.round((float)width * this.view.zoomValue);
        height = Math.round((float)height * this.view.zoomValue);
        int x = this.view.contentsToViewX(_x);
        int y = this.view.contentsToViewY(_y);
        if (this.context.textExtent((String)name).x <= width) {
            this.localDrawText(name, x + 1, y + 1 + height, trans);
        } else {
            String nameToDisplay = name;
            int i = name.length() - 1;
            while (i >= 0 && this.context.textExtent((String)nameToDisplay).x >= width) {
                nameToDisplay = name.substring(0, i);
                --i;
            }
            int dotCount = 0;
            int i2 = 1;
            while (i2 <= 3 && nameToDisplay.length() - i2 > 0) {
                ++dotCount;
                ++i2;
            }
            nameToDisplay = nameToDisplay.substring(0, nameToDisplay.length() - dotCount);
            int i3 = 0;
            while (i3 < dotCount) {
                nameToDisplay = nameToDisplay + ".";
                ++i3;
            }
            this.localDrawText(nameToDisplay, x + 1, y + 1 + height, trans);
        }
    }

    public void drawImage(IImage image, int _x, int _y, int maxWith, int maxHeight) {
        Image img = null;
        if (image == null || !(image.getImage() instanceof Image)) {
            _x = Math.round((float)_x * this.view.zoomValue);
            _y = Math.round((float)_y * this.view.zoomValue);
            int x = this.view.contentsToViewX(_x);
            int y = this.view.contentsToViewY(_y);
            float tempZoom = this.view.zoomValue;
            int width = Math.round((float)maxWith * tempZoom);
            int height = Math.round((float)maxHeight * tempZoom);
            this.context.setBackground(this.view.getDisplay().getSystemColor(3));
            this.context.fillRectangle(x, y, width, height);
            return;
        }
        img = (Image)image.getImage();
        _x = Math.round((float)_x * this.view.zoomValue);
        _y = Math.round((float)_y * this.view.zoomValue);
        int x = this.view.contentsToViewX(_x);
        int y = this.view.contentsToViewY(_y);
        Rectangle b = ((Image)image.getImage()).getBounds();
        int width = b.width;
        int height = b.height;
        if (width > maxWith) {
            width = maxWith;
        }
        if (height > maxHeight) {
            height = maxHeight;
        }
        float tempZoom = this.view.zoomValue;
        width = Math.round((float)width * tempZoom);
        height = Math.round((float)height * tempZoom);
        this.context.drawImage(img, 0, 0, b.width, b.height, x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        x = Math.round((float)x * this.view.zoomValue);
        y = Math.round((float)y * this.view.zoomValue);
        width = Math.round((float)width * this.view.zoomValue);
        height = Math.round((float)height * this.view.zoomValue);
        if (width == 0 || height == 0 || endAngle == 0) {
            return;
        }
        this.context.drawArc(this.view.contentsToViewX(x), this.view.contentsToViewY(y), width, height, startAngle, endAngle);
    }

    public void setFont(IFont font) {
        if (font.getFont() != null && ((Font)font.getFont()).getFontData().length > 0) {
            int h;
            FontData fontData = ((Font)font.getFont()).getFontData()[0];
            if (SDViewPref.getInstance().fontLinked() && (h = Math.round((float)fontData.getHeight() * this.view.zoomValue)) > 0) {
                fontData.setHeight(h);
            }
            if (this.tempFont != null) {
                this.tempFont.dispose();
            }
            this.tempFont = new Font((Device)Display.getCurrent(), fontData);
            this.context.setFont(this.tempFont);
        }
    }

    public int getFontHeight(IFont font) {
        if (font.getFont() != null && font.getFont() instanceof Font && ((Font)font.getFont()).getFontData().length > 0) {
            FontData fontData = ((Font)font.getFont()).getFontData()[0];
            Font toRestore = this.context.getFont();
            this.context.setFont((Font)font.getFont());
            int height = this.context.textExtent((String)"lp").y;
            this.context.setFont(toRestore);
            return height;
        }
        return 0;
    }

    public int getFontWidth(IFont font) {
        if (font.getFont() != null && font.getFont() instanceof Font) {
            Font toRestore = this.context.getFont();
            this.context.setFont((Font)font.getFont());
            int width = this.context.getFontMetrics().getAverageCharWidth();
            this.context.setFont(toRestore);
            return width;
        }
        return 0;
    }

    public void dispose() {
        if (this.tempFont != null) {
            this.tempFont.dispose();
        }
        this.tempFont = null;
        if (this.context != null) {
            this.context.dispose();
        }
        this.context = null;
    }

    public float getZoom() {
        if (this.view != null) {
            return this.view.zoomValue;
        }
        return 1.0f;
    }

    public int getLineDotStyle() {
        return 3;
    }

    public int getLineDashStyle() {
        return 2;
    }

    public int getLineSolidStyle() {
        return 1;
    }

    public IColor createColor(int r, int g, int b) {
        return new ColorImpl(Display.getDefault(), r, g, b);
    }

    public void setDrawTextWithFocusStyle(boolean focus) {
        this.drawWithFocus = focus;
    }
}

