/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.views.ExtensionPointHandler;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogPage;
import org.eclipse.hyades.log.ui.internal.views.LogPaneTreeViewer;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.models.internal.sdb.loader.SDBLoader;
import org.eclipse.hyades.sdb.analysis.LogAnalyzerImpl;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.util.PreferencesUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class AnalyzeLogAction
implements IRunnableWithProgress {
    private String symptomDBPath;
    private String projectName;
    private String sdbFileName;
    private IConfigurationElement newSymptomDBLoaderElement = null;
    private boolean newSymptomDBLoaderElementInit;
    private ExtensionPointHandler eph = ExtensionPointHandler.getExtensionPointHandler();
    protected EObject mofObject;
    private LogPaneTreeViewer logPaneTreeViewer;

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IPreferenceStore store = PreferencesUtil.doGetPreferenceStore();
        if (this.sdbFileName.length() > 0 && this.sdbFileName.endsWith("xml")) {
            this.importDB(monitor);
        } else if (this.symptomDBPath.length() > 0 && this.symptomDBPath.endsWith("xml")) {
            this.sdbFileName = Platform.getLocation() + "/" + this.symptomDBPath;
            this.importDB(monitor);
        }
        String value = this.getNewSDBPathPreference(store.getString("symptom_db_path"), this.symptomDBPath);
        store.setValue("symptom_db_path", value);
        store.setValue("project_name", this.projectName);
        store.setValue("sdb_file_name", this.sdbFileName);
        PreferencesUtil.savePreferences();
        List objects = this.getObjectsToAnalyze();
        LogAnalyzerImpl aLogAnalyzer = new LogAnalyzerImpl();
        aLogAnalyzer.loadDatabase();
        if (aLogAnalyzer.errorMsg() == null) {
            aLogAnalyzer.analyze((Object)objects, null);
        }
        this.logPaneTreeViewer.refresh();
        Event event = new Event();
        event.item = ((Tree)this.logPaneTreeViewer.getControl()).getItems()[0];
        this.logPaneTreeViewer.getControl().notifyListeners(13, event);
    }

    private String getNewSDBPathPreference(String previousValue, String symptomDBPath) {
        if (previousValue.length() == 0) {
            return symptomDBPath + ",1";
        }
        int index = previousValue.indexOf(symptomDBPath);
        if (index < 0) {
            return symptomDBPath + ",1" + ";" + previousValue;
        }
        if (previousValue.substring(symptomDBPath.length() + index + 1, symptomDBPath.length() + index + 2).equals("0")) {
            String temp1 = previousValue.substring(0, index + symptomDBPath.length() + 1);
            String temp2 = previousValue.substring(index + symptomDBPath.length() + 2, previousValue.length());
            return temp1 + "1" + temp2;
        }
        if (previousValue.substring(symptomDBPath.length() + index + 1, symptomDBPath.length() + index + 2).equals("1")) {
            return previousValue;
        }
        return "";
    }

    public List getObjectsToAnalyze() {
        try {
            IWorkbenchPage persp = UIPlugin.getActivePage();
            LogViewer logviewer = (LogViewer)persp.showView("org.eclipse.hyades.log.ui.internal.views.LogViewer");
            LogPage logPage = (LogPage)logviewer.getPage(this.mofObject);
            if (logPage == null) {
                logviewer.addViewPage(this.mofObject);
                logPage = (LogPage)logviewer.getPage(this.mofObject);
            }
            this.logPaneTreeViewer = logPage.getView().getViewer();
            LogContentProvider logContentProvider = (LogContentProvider)this.logPaneTreeViewer.getContentProvider();
            return Arrays.asList(logContentProvider.getChildren((Object)this.mofObject));
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public String getSymptomDBPath() {
        return this.symptomDBPath;
    }

    public void setSymptomDBPath(String string) {
        this.symptomDBPath = string;
    }

    public void setProjectName(String pName) {
        this.projectName = pName;
    }

    public void setSDBFileName(String string) {
        this.sdbFileName = string;
    }

    public EObject getMofObject() {
        return this.mofObject;
    }

    public void setMofObject(EObject object) {
        this.mofObject = object;
    }

    public void importDB(IProgressMonitor monitor) {
        String PLATFORM_PREFIX = "platform:/resource";
        try {
            Path path = new Path(this.symptomDBPath);
            SDBLoader l = new SDBLoader();
            this.symptomDBPath = path.removeFileExtension().addFileExtension(l.getExtension()).toString();
            l.loadDatabase(new Path(this.sdbFileName).toString(), new Path("platform:/resource" + this.symptomDBPath).toString(), monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

