/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.hyades.execution.recorder.http.remote.ClientSideReader;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;
import org.eclipse.hyades.execution.recorder.http.remote.PeekSocket;
import org.eclipse.hyades.execution.recorder.http.remote.SSLCheckClass;
import org.eclipse.hyades.execution.recorder.http.remote.ServerSideReader;

public class ClientSideReaderSOCKS
extends ClientSideReader {
    public static final String ERROR_SSL_REQUEST_MADE = "-1";
    public static final String ERROR_NO_TESTKEYS = "-2";
    static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
    static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");

    ClientSideReaderSOCKS(PeekSocket peekSocket, PacketWriter packetWriter, String string) {
        super(peekSocket, packetWriter, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int n = 0;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        if (ClientSideReader.isSSLClassAvailable == -1 && (ClientSideReader.isSSLClassAvailable = this.findSSLClass()) == 1) {
            ClientSideReader.foundTestKeys = this.checkForTestKeys();
        }
        this.setName("ClientSideReaderSOCKS-Conn:" + this.iConnection);
        try {
            byte[] byArray = new byte[this.client.getReceiveBufferSize()];
            int n2 = this.client.getReceiveBufferSize();
            bl = this.processSocksRequest();
            if (bl) {
                this.bSecure = this.checkSSLByte();
                if (this.bSecure) {
                    if (ClientSideReader.isSSLClassAvailable != 1) {
                        this.packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_SSL_REQUEST_MADE);
                        this.respondToClient(false);
                        return;
                    }
                    if (!ClientSideReader.foundTestKeys) {
                        this.packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_NO_TESTKEYS);
                        return;
                    }
                    SSLCheckClass sSLCheckClass = new SSLCheckClass(this, this.keyFile);
                    sSLCheckClass.makeSecureConnection();
                    if (this.httpServer == null) {
                        this.packetWriter.writeRecorderMessage(1, "Error connecting to SSL Server:" + this.destServer + " Port: " + this.serverPort);
                        this.packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_SSL_REQUEST_MADE);
                        return;
                    }
                } else {
                    this.httpServer = new Socket(this.newAddr, this.destPort);
                    if (this.httpServer == null) {
                        this.packetWriter.writeRecorderMessage(1, "Error connecting to Server:" + this.destServer + " Port: " + this.serverPort);
                        return;
                    }
                    string = this.makeRegularConnection();
                }
                while ((n = this.from_client.read(byArray)) != -1) {
                    Thread.yield();
                    this.bNoPrintToServer = false;
                    boolean bl3 = false;
                    String string2 = new String(byArray, 0, n);
                    bl2 = true;
                    if (this.bSecure) {
                        this.packetWriter.writePacket(this.bSecure, true, this.connectionNumber, byArray, n, this.to_server, this.bNoPrintToServer);
                    }
                    if (this.bSecure) continue;
                    this.packetWriter.writePacket(this.bSecure, true, this.connectionNumber, string2.getBytes(), string2.getBytes().length, this.to_server, this.bNoPrintToServer);
                }
            }
            if (this.httpServer != null) {
                this.httpServer.setSoLinger(true, 0);
                if (!bl2) {
                    if (!this.httpServer.isClosed()) {
                        this.httpServer.close();
                    }
                } else if (!this.httpServer.isOutputShutdown()) {
                    if (this.bSecure) {
                        this.to_server.flush();
                        this.httpServer.close();
                    } else {
                        this.httpServer.shutdownOutput();
                    }
                }
            }
            Thread.yield();
            return;
        }
        catch (Exception exception) {
            try {
                if (this.httpServer != null) {
                    if (!bl2) {
                        if (!this.httpServer.isClosed()) {
                            this.httpServer.close();
                        }
                    } else if (!this.httpServer.isOutputShutdown() && !this.httpServer.isClosed()) {
                        if (this.bSecure) {
                            this.to_server.flush();
                            this.httpServer.close();
                        } else {
                            this.httpServer.shutdownOutput();
                        }
                    }
                }
                Thread.yield();
                this.serverReader.ssrBuffer = null;
                return;
            }
            catch (IOException iOException) {
                String string3 = iOException.getMessage();
                if (string3.indexOf("Stream closed") >= 0) return;
                if (string3.indexOf("Socket closed") >= 0) return;
                if (string3.indexOf("JVM_recv in socket input") >= 0) return;
                if (string3.indexOf("onnection closed") >= 0) return;
                if (string3.indexOf("socket closed") >= 0) return;
                if (string3.indexOf("onnection reset") >= 0) return;
                if (string3.indexOf("Socket is closed") >= 0) return;
                this.packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + this.iConnection + " : " + exception.getLocalizedMessage());
                return;
            }
        }
    }

    private static int readExactOrBust(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        do {
            if ((n2 = inputStream.read(byArray, n3, n - n3)) > 0) continue;
            return -1;
        } while ((n3 += n2) < n);
        if (n3 != n) {
            throw new RuntimeException("Internal logic problem ClientSideReadSOCKS.readExactOrBust()");
        }
        return n3;
    }

    private static int flushUntilByteOccurs(InputStream inputStream, byte by) throws IOException {
        int n;
        int n2 = 0;
        do {
            if ((n = inputStream.read()) <= 0) {
                return -1;
            }
            ++n2;
        } while (by != (byte)n);
        return n2;
    }

    private boolean processSocksRequest() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = "";
        byte[] byArray = new byte[4];
        boolean bl2 = false;
        try {
            byte[] byArray2 = new byte[this.client.getReceiveBufferSize()];
            n = ClientSideReaderSOCKS.readExactOrBust(this.from_client, byArray2, 8);
            if (n < 8) {
                bl = false;
            } else {
                int n4 = 0;
                n4 = 0;
                while (n4 < 8) {
                    Byte by = new Byte(byArray2[n4]);
                    switch (n4) {
                        case 0: {
                            n2 = by.intValue();
                            break;
                        }
                        case 1: {
                            n3 = by.intValue();
                            break;
                        }
                        case 2: {
                            int n5 = 0;
                            n5 = by.intValue();
                            if (n5 < 0) {
                                n5 += 256;
                            }
                            this.destPort = n5 * 256;
                            break;
                        }
                        case 3: {
                            int n6 = 0;
                            n6 = by.intValue();
                            if (n6 < 0) {
                                n6 += 256;
                            }
                            this.destPort += n6;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            byArray[n4 - 4] = byArray2[n4];
                        }
                    }
                    ++n4;
                }
                if (ClientSideReaderSOCKS.flushUntilByteOccurs(this.from_client, (byte)0) == -1) {
                    bl = false;
                }
                string = ClientSideReaderSOCKS.IP4ByteToString(byArray);
                this.newAddr = InetAddress.getByName(string);
                this.destServer = string;
                this.serverPort = this.destPort;
                bl = true;
            }
            this.respondToClient(bl);
        }
        catch (Exception exception) {
            this.packetWriter.writeRecorderMessage(1, "Error Reading from Client Connection: " + this.iConnection);
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(1, "Error closing Client" + iOException + " Connection: " + this.iConnection);
            }
        }
        return bl;
    }

    private static String IP4ByteToString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < 4) {
            string = byArray[n] >= 0 ? string + String.valueOf(byArray[n]) : string + String.valueOf(256 + byArray[n]);
            if (n < 3) {
                string = string + ".";
            }
            ++n;
        }
        return string;
    }

    private void respondToClient(boolean bl) {
        byte[] byArray = new byte[8];
        byArray[0] = 0;
        byArray[1] = bl ? 90 : 91;
        try {
            this.to_client.write(byArray, 0, 8);
            this.to_client.flush();
        }
        catch (Exception exception) {}
    }

    private String makeRegularConnection() {
        String string = null;
        boolean bl = false;
        try {
            this.packetWriter.writeOpenConnectionInfo(this.bSecure, this.iConnection, this.destServer, this.serverPort, this.client, this.httpServer, null, null);
            this.to_server = this.httpServer.getOutputStream();
            this.from_server = this.httpServer.getInputStream();
            this.serverReader = new ServerSideReader(this.client, this.httpServer, this.from_server, this.to_client, this.packetWriter, this.connectionNumber, this.bSecure, this.httpServer.getReceiveBufferSize());
            this.serverReader.start();
        }
        catch (Exception exception) {
            this.packetWriter.writeRecorderMessage(2, "exception in ClientSideReader : " + exception + " Connection: " + this.iConnection);
            this.packetWriter.getAgentController().reportException(ClientSideReaderException, (Throwable)exception);
            try {
                if (!this.client.isClosed()) {
                    this.client.close();
                }
                string = null;
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + this.iConnection + ": " + iOException);
            }
        }
        return string;
    }

    public int findSSLClass() {
        int n = -1;
        try {
            Class<?> clazz = Class.forName("javax.net.ssl.SSLSocket");
            n = 1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            n = 0;
        }
        return n;
    }

    boolean checkSSLByte() {
        boolean bl = false;
        int n = 0;
        try {
            n = this.client.peek();
        }
        catch (IOException iOException) {
            this.packetWriter.writeRecorderMessage(2, "exception checking for SSL Connection: " + this.iConnection + iOException);
        }
        if (n == 128 || n == 20 || n == 21 || n == 22 || n == 23) {
            bl = true;
            this.bSecure = true;
        } else {
            this.bSecure = false;
            bl = false;
        }
        return bl;
    }
}

