/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.filters.internal.util.ScopeContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin
implements Application {
    protected static UIPlugin inst;
    protected ResourceBundle fResourceBundle;
    public static final String PLUGIN_ID = "org.eclipse.hyades.trace.ui";
    private static String PREFERENCE_FILTER_SELECTION_KEY;
    private static String PREFERENCE_STRING_SEPARATOR;
    private static String PREFERENCE_STRING_VALUE_SEPARATOR;

    public UIPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public void addSelectionListener(ISelectionListener l) {
        TraceUIManager.getTraceUIManager().addSelectionListener(l);
    }

    public void removeSelectionListener(ISelectionListener l) {
        TraceUIManager.getTraceUIManager().removeSelectionListener(l);
    }

    public void addSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        TraceUIManager.getTraceUIManager().addSelectionProvider(provider, part);
    }

    public void deregisterLaunchProcess(IProcess process) {
        TraceUIManager.getTraceUIManager().deregisterLaunchProcess(process);
    }

    public void deleteLaunch(IProcess process) {
        TraceUIManager.getTraceUIManager().deleteLaunch(process);
    }

    public void registerLaunchProcess(IProcess process) {
        TraceUIManager.getTraceUIManager().registerLaunchProcess(process);
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchPage page;
        block6: {
            if (UIPlugin.getActiveWorkbenchWindow() == null) {
                return null;
            }
            page = UIPlugin.getActiveWorkbenchWindow().getActivePage();
            if (page != null && page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) break block6;
            IWorkbenchWindow dwindow = UIPlugin.getActiveWorkbenchWindow();
            page = null;
            try {
                IWorkbenchPage[] persps = dwindow.getPages();
                int idx = 0;
                while (idx < persps.length) {
                    if (persps[idx].getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
                        page = persps[idx];
                        dwindow.setActivePage(page);
                        break;
                    }
                    ++idx;
                }
                if (page != null) break block6;
                IWorkspaceRoot element = UIPlugin.getPluginWorkbench().getRoot();
                IWorkbench workBench = dwindow.getWorkbench();
                if (workBench != null && element != null) {
                    page = workBench.showPerspective("org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getActiveWorkbenchWindow(), (IAdaptable)element);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return page;
    }

    public static Shell getActiveWorkbenchShell() {
        return UIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static UIPlugin getDefault() {
        return inst;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return PDPluginImages.getImageDescriptor(name);
    }

    public HierarchyFactory getPerftraceFactory() {
        return TraceUIManager.getTraceUIManager().getPerftraceFactory();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static IWorkspace getPluginWorkbench() {
        return ResourcesPlugin.getWorkspace();
    }

    public ResourceBundle getResourceBundle() {
        block2: {
            if (this.fResourceBundle != null) break block2;
            try {
                this.fResourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception e) {
                this.fResourceBundle = null;
            }
        }
        return this.fResourceBundle;
    }

    public ResourceSet getResourceSet() {
        return TraceUIManager.getTraceUIManager().getResourceSet();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = UIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public PDProjectExplorer getViewer() {
        return PDProjectExplorer.getFromActivePerspective();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("use_host", "localhost:10002");
        store.setDefault("localhost_port", "10002");
        store.setDefault("prj_name", UIPlugin.getResourceString("STR_TRACE_LOCATION_DEFAULT"));
        store.setDefault("mon_name", UIPlugin.getResourceString("STR_MON_LOCATION_DEFAULT"));
        store.setDefault("log_option", false);
        store.setDefault("prof_option", true);
        store.setDefault("profile_tips", true);
        store.setDefault("reload_no_question", true);
        store.setDefault("save_on_exit", "prompt");
        store.setDefault("switch_to_perspective", "prompt");
        store.setDefault("new_snapshot_tips", true);
        store.setDefault("prof_exec_stat", true);
        store.setDefault("prof_heap_stat", true);
        store.setDefault("prof_heap_inst", false);
        store.setDefault("prof_auto_monitor", true);
        store.setDefault("refresh_type", 0);
        store.setDefault("refresh_int", 3);
        store.setDefault("profiling_monitor_layout", 0);
        String def = UIPlugin.getResourceString("STR_DEFAULT_SET_NAME");
        store.setDefault("filter_name", def);
        String filters = TraceConstants.DEFAULT_FILTER_SET;
        store.setDefault("set_filters", filters);
        store.setDefault("prof_heap_size", true);
        store.setDefault("prof_execution", false);
        store.setDefault("prof_execution_boundary", false);
        store.setDefault("limitInvoc", false);
        store.setDefault("limitTime", false);
        store.setDefault("invoc_nb", "10000");
        store.setDefault("timeSec", "5");
        store.setDefault("collect_depth", "1");
        store.setDefault("debug", this.getDebugOption());
    }

    private boolean getDebugOption() {
        boolean debugOption = false;
        String value = System.getProperty("hyades.trace.ui.debug");
        if (value != null) {
            debugOption = value.equalsIgnoreCase("true");
        }
        return debugOption;
    }

    public void removeSelectionProvider(ISelectionProvider provider, IWorkbenchPart part) {
        TraceUIManager.getTraceUIManager().removeSelectionProvider(provider, part);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        TraceUIManager.getTraceUIManager().selectionChanged(event);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        TraceUIManager.getTraceUIManager().selectionChanged(part, sel);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.storeFilterSelections();
        this.savePluginPreferences();
        PDPluginImages.shutdown();
        TraceUIManager.getTraceUIManager().dispose();
        this.fResourceBundle = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.restoreFilterSelections();
    }

    public void addProfileEventListener(IProfileEventListener listener) {
        TraceUIManager.getTraceUIManager().addProfileEventListener(listener);
    }

    public void removeProfileEventListener(IProfileEventListener listener) {
        TraceUIManager.getTraceUIManager().removeProfileEventListener(listener);
    }

    public void addDeleteListener(IDeleteListener listener) {
        TraceUIManager.getTraceUIManager().addDeleteListener(listener);
    }

    public void addViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        TraceUIManager.getTraceUIManager().addViewSelectionChangedListener(listener);
    }

    public void addSelectionModel(EObject mofObject, ITraceSelection model) {
        TraceUIManager.getTraceUIManager().addSelectionModel(mofObject, model);
    }

    public ArrayList getDeleteListeners() {
        return TraceUIManager.getTraceUIManager().getDeleteListeners();
    }

    public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
        return TraceUIManager.getTraceUIManager().getViewSelectionChangedEvent();
    }

    public ProfileEvent getProfileEvent() {
        return TraceUIManager.getTraceUIManager().getProfileEvent();
    }

    public ProfileEvent getRefreshViewEvent(Object source) {
        return TraceUIManager.getTraceUIManager().getRefreshViewEvent(source);
    }

    public ITraceSelection getSelectionModel(EObject mofObject) {
        return TraceUIManager.getTraceUIManager().getSelectionModel(mofObject);
    }

    public ProfileEvent getUpdateModelEvent(Object source) {
        return TraceUIManager.getTraceUIManager().getUpdateModelEvent(source);
    }

    public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent event) {
        TraceUIManager.getTraceUIManager().notifyViewSelectionChangedListener(event);
    }

    public void notifyProfileEventListener(ProfileEvent event) {
        TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
    }

    public void removeDeleteListener(IDeleteListener listener) {
        TraceUIManager.getTraceUIManager().removeDeleteListener(listener);
    }

    public void removeViewSelectionChangedListener(IViewSelectionChangedListener listener) {
        TraceUIManager.getTraceUIManager().removeViewSelectionChangedListener(listener);
    }

    public void removeSelectionModel(EObject mofObject) {
        TraceUIManager.getTraceUIManager().removeSelectionModel(mofObject);
    }

    public String getName() {
        return UIPlugin.getPluginId();
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    private void storeFilterSelections() {
        ScopeContainer scopeContainer = ScopeContainer.instance();
        StringBuffer filterSelectionStr = new StringBuffer();
        String[] scopes = scopeContainer.scopes();
        String selectedFilterName = null;
        int i = 0;
        while (i < scopes.length) {
            selectedFilterName = scopeContainer.getSelectedFilterName(scopes[i]);
            if (selectedFilterName != null) {
                filterSelectionStr.append(scopes[i]);
                filterSelectionStr.append(PREFERENCE_STRING_VALUE_SEPARATOR);
                filterSelectionStr.append(selectedFilterName);
                filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
            }
            ++i;
        }
        filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
        String[] viewers = scopeContainer.viewers();
        String selectedScope = null;
        int i2 = 0;
        while (i2 < viewers.length) {
            selectedScope = scopeContainer.getSelectedScope(viewers[i2]);
            if (selectedScope != null) {
                filterSelectionStr.append(viewers[i2]);
                filterSelectionStr.append(PREFERENCE_STRING_VALUE_SEPARATOR);
                filterSelectionStr.append(selectedScope);
                filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
            }
            ++i2;
        }
        this.getPluginPreferences().setValue(PREFERENCE_FILTER_SELECTION_KEY, filterSelectionStr.toString());
    }

    private void restoreFilterSelections() {
        int sIdx;
        String filterSelectionStr = this.getPluginPreferences().getString(PREFERENCE_FILTER_SELECTION_KEY);
        if (filterSelectionStr == null || "".equals(filterSelectionStr)) {
            return;
        }
        ScopeContainer scopeContainer = ScopeContainer.instance();
        int idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        while (idx > 0) {
            String scopeSelectedFilterStr = filterSelectionStr.substring(0, idx);
            sIdx = scopeSelectedFilterStr.indexOf(PREFERENCE_STRING_VALUE_SEPARATOR);
            String scope = scopeSelectedFilterStr.substring(0, sIdx);
            String selectedFilter = scopeSelectedFilterStr.substring(sIdx + 1);
            scopeContainer.setSelectedFilterName(scope, selectedFilter);
            filterSelectionStr = filterSelectionStr.substring(idx + 1);
            idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        }
        filterSelectionStr = filterSelectionStr.substring(1);
        idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        while (idx >= 0) {
            String viewerSelectedScope = filterSelectionStr.substring(0, idx);
            sIdx = viewerSelectedScope.indexOf(PREFERENCE_STRING_VALUE_SEPARATOR);
            String viewer = viewerSelectedScope.substring(0, sIdx);
            String selectedScope = viewerSelectedScope.substring(sIdx + 1);
            scopeContainer.setSelectedScope(viewer, selectedScope);
            filterSelectionStr = filterSelectionStr.substring(idx + 1);
            idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        }
    }

    static {
        PREFERENCE_FILTER_SELECTION_KEY = "filters.filterSelection";
        PREFERENCE_STRING_SEPARATOR = "\n";
        PREFERENCE_STRING_VALUE_SEPARATOR = ";";
    }
}

