/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.filters.internal.util;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.trace.ui.filters.IFilterViewer;
import org.eclipse.hyades.trace.ui.filters.internal.actions.FilterQueryProvider;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.trace.ui.filters.internal.util.ScopeContainer;
import org.eclipse.hyades.trace.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.trace.ui.internal.filters.IFilterType;

public class FilterInformationManager {
    private ScopeContainer _scopeContainer;
    private IFilterViewer _viewer;
    private String[] _scope;
    private FilterResourceHandler _resourceHandler;

    protected FilterInformationManager(IFilterViewer viewer, String[] scope) {
        this._viewer = viewer;
        this._scope = scope;
        Arrays.sort(this._scope, new Comparator(){

            public int compare(Object a, Object b) {
                String str1 = (String)a;
                String str2 = (String)b;
                if (str1 == null) {
                    str1 = "";
                }
                if (str2 == null) {
                    str2 = "";
                }
                return Collator.getInstance().compare(str1, str2);
            }
        });
        this._resourceHandler = FilterResourceHandler.instance();
        this._scopeContainer = ScopeContainer.instance();
        if (this._viewer != null) {
            this._viewer.setFilterQueryProvider(new FilterQueryProvider(this));
            this._scopeContainer.addFilterViewer(this._viewer);
        }
    }

    private String getSelectedScope() {
        String selectedScope = null;
        if (this._viewer != null) {
            selectedScope = this._scopeContainer.getSelectedScope(this._viewer.getClass().getName());
        }
        if (selectedScope == null && this._scope.length > 0) {
            return this._scope[0];
        }
        return selectedScope;
    }

    public static FilterInformationManager instance(IFilterViewer viewer) {
        return new FilterInformationManager(viewer, viewer.getFilterScope());
    }

    public static FilterInformationManager instance(String scope) {
        String[] scopeArray = new String[]{scope};
        return new FilterInformationManager(null, scopeArray);
    }

    public IFilterType[] getFilterTypes() {
        return FilterTypesManager.instance().getFilterTypes(this._scope);
    }

    private void updateViewers() {
        IFilterViewer[] viewers = this._scopeContainer.getFilterViewers(this.getSelectedScope());
        int i = 0;
        while (i < viewers.length) {
            this._scopeContainer.setSelectedScope(viewers[i].getClass().getName(), this.getSelectedScope());
            viewers[i].filterUpdated();
            ++i;
        }
    }

    public FilterQueries selectedFilter() {
        if (this.selectedFilterName() != null) {
            return this.filter(this.selectedFilterName());
        }
        return null;
    }

    public String selectedFilterName() {
        return this._scopeContainer.getSelectedFilterName(this.getSelectedScope());
    }

    public void selectedFilterName(String selectedFilterName) {
        this.selectedFilterName(selectedFilterName, true);
    }

    public void selectedFilterName(String selectedFilterName, boolean updateViewer) {
        if (selectedFilterName != null) {
            String[] scopeApplied = this._scopeContainer.setSelectedFilterName(selectedFilterName);
            String selectedScope = FilterTypesManager.firstScopeIntersection(this._scope, scopeApplied);
            if (this._viewer != null) {
                this._scopeContainer.setSelectedScope(this._viewer.getClass().getName(), selectedScope);
            }
        } else {
            this._scopeContainer.setSelectedFilterName(this.getSelectedScope(), selectedFilterName);
        }
        if (updateViewer) {
            this.updateViewers();
        }
    }

    public int size() {
        return this.getFiltersArray().length;
    }

    public FilterQueries filter(int i) {
        return (FilterQueries)this.getFiltersArray()[i];
    }

    public Object[] getFiltersArray() {
        Object[] filters = this._resourceHandler.toArray();
        Vector<Object> filtersOfTheseTypes = new Vector<Object>();
        int i = 0;
        while (i < filters.length) {
            IFilterType filterType = FilterTypesManager.instance().getFilterType(((FilterQueries)filters[i]).type());
            if (filterType != null && this.hasScope(filterType.scope())) {
                filtersOfTheseTypes.addElement(filters[i]);
            }
            ++i;
        }
        Object[] sortedFilters = filtersOfTheseTypes.toArray();
        this.sortFilters(sortedFilters);
        return sortedFilters;
    }

    public void sortFilters(Object[] filters) {
        Arrays.sort(filters, new Comparator(){

            public int compare(Object a, Object b) {
                String name1 = null;
                if (a instanceof FilterQueries) {
                    name1 = ((FilterQueries)a).name();
                }
                String name2 = null;
                if (b instanceof FilterQueries) {
                    name2 = ((FilterQueries)b).name();
                }
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                return Collator.getInstance().compare(name1, name2);
            }
        });
    }

    public void restore() {
        this._resourceHandler.load();
    }

    public void save() {
        this._resourceHandler.save();
    }

    public FilterQueries createFilterQueries(String type) {
        return this._resourceHandler.createFilterQueries(type);
    }

    public FilterQueries createFilterQueries(String type, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery) {
        return this._resourceHandler.createFilterQueries(type, standardQuery, advancedQuery);
    }

    public void addFilter(FilterQueries fq) {
        this._resourceHandler.addFilter(fq);
    }

    public void removeFilter(FilterQueries fq) {
        this._resourceHandler.removeFilter(fq);
    }

    public void removeFilters(int[] indeces) {
        Object[] filters = this.getFiltersArray();
        FilterQueries[] filterElementsToRemove = new FilterQueries[indeces.length];
        int i = 0;
        while (i < indeces.length) {
            filterElementsToRemove[i] = (FilterQueries)filters[indeces[i]];
            ++i;
        }
        i = 0;
        while (i < filterElementsToRemove.length) {
            this.removeFilter(filterElementsToRemove[i]);
            ++i;
        }
    }

    public FilterQueries filter(String name) {
        return this._resourceHandler.filter(name);
    }

    public boolean filterNameExists(String name) {
        return this.filter(name) != null;
    }

    private boolean hasScope(String[] scope) {
        return FilterTypesManager.scopesHaveIntersection(this._scope, scope);
    }

    public SimpleSearchQuery getCurrentFilter() {
        return this.createCombinedFilter(this.selectedFilter());
    }

    public SimpleSearchQuery createCombinedFilter(FilterQueries fq) {
        if (fq == null) {
            return null;
        }
        Object combinedQuery = fq.standard() instanceof TimeBasedCorrelationQuery ? ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery() : ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        combinedQuery.setName(fq.name());
        if (fq.standard().getOrderByExpresions().size() > 0) {
            combinedQuery.getOrderByExpresions().add((Object)EcoreUtil.copy((EObject)((EObject)fq.standard().getOrderByExpresions().get(0))));
            combinedQuery.setMaxElements(fq.standard().getMaxElements());
        }
        LogicalExpression standardLogicalExpression = null;
        LogicalExpression advancedLogicalExpression = null;
        if (fq.standard().getWhereExpression() != null && ((LogicalExpression)fq.standard().getWhereExpression()).getArguments().size() > 0) {
            standardLogicalExpression = (LogicalExpression)EcoreUtil.copy((EObject)fq.standard().getWhereExpression());
        }
        if (fq.advanced().getWhereExpression() != null && ((LogicalExpression)fq.advanced().getWhereExpression()).getArguments().size() > 0) {
            advancedLogicalExpression = (LogicalExpression)EcoreUtil.copy((EObject)fq.advanced().getWhereExpression());
        }
        if (standardLogicalExpression != null && advancedLogicalExpression != null || standardLogicalExpression == null && advancedLogicalExpression == null) {
            LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
            logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
            if (standardLogicalExpression != null && advancedLogicalExpression != null) {
                logicalExpression.getArguments().add((Object)standardLogicalExpression);
                logicalExpression.getArguments().add((Object)advancedLogicalExpression);
            }
            combinedQuery.setWhereExpression((WhereExpression)logicalExpression);
        } else if (standardLogicalExpression != null) {
            combinedQuery.setWhereExpression((WhereExpression)standardLogicalExpression);
        } else if (advancedLogicalExpression != null) {
            combinedQuery.setWhereExpression(advancedLogicalExpression);
        }
        return combinedQuery;
    }

    public void viewerDisposed() {
        if (this._viewer != null) {
            this._scopeContainer.removeFilterViewer(this._viewer);
        }
    }
}

