/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.filters.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterResourceFileHandler;

public class FilterResourceHandler
extends FilterResourceFileHandler {
    private static String TYPE_DIR = "/filterresources/";
    private static String TYPE_FILE = ".filtxmi";
    private static String FILTERS_FILE_NAME = "filters";
    private static String DEFAULT_FILTER_KEY_PREFIX = "org.eclipse.hyades.trace.ui.filters.internal.defaultFilters.";
    private static FilterResourceHandler _instance = null;
    private static List _filtersToAddOnInstanceLoad = null;

    protected FilterResourceHandler(URI uri) {
        super(uri);
    }

    public static FilterResourceHandler instance() {
        if (_instance == null) {
            _instance = new FilterResourceHandler(FilterResourceHandler.createMasterListFileURI());
            FilterResourceHandler.addFiltersOnInstanceLoad(null);
        }
        return _instance;
    }

    public static URI createMasterListFileURI() {
        String fileName = UIPlugin.getDefault().getStateLocation().toString() + TYPE_DIR + FILTERS_FILE_NAME + TYPE_FILE;
        return URI.createFileURI((String)fileName);
    }

    public FilterQueries createFilterQueries(String type) {
        return this.createFilterQueries(type, null, null);
    }

    public FilterQueries createFilterQueries(String type, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery) {
        return FilterResourceHandler.createFilterQueries(type, this.getNewFilterSetName(), standardQuery, advancedQuery);
    }

    public static FilterQueries createFilterQueries(String type, String name, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery) {
        FilterQueries fq = new FilterQueries();
        fq.type(type);
        fq.name(name);
        if (standardQuery != null) {
            fq.standard(standardQuery);
        } else {
            fq.standard(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());
        }
        if (advancedQuery != null) {
            fq.advanced(advancedQuery);
        } else {
            fq.advanced(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());
        }
        return fq;
    }

    private String getNewFilterSetName() {
        String defaultName = UIPlugin.getResourceString("FILTERS_NEW_BASE_NAME");
        int i = 1;
        String name = defaultName;
        while (this.filter(name) != null) {
            name = defaultName + " (" + i + ")";
            ++i;
        }
        return name;
    }

    public static synchronized void addFiltersOnInstanceLoad(List filters) {
        if (_filtersToAddOnInstanceLoad == null) {
            _filtersToAddOnInstanceLoad = new ArrayList();
        }
        if (filters != null) {
            _filtersToAddOnInstanceLoad.addAll(filters);
        }
        if (_instance == null || _filtersToAddOnInstanceLoad == null) {
            return;
        }
        int i = 0;
        while (i < _filtersToAddOnInstanceLoad.size()) {
            _instance.addFilter((FilterQueries)_filtersToAddOnInstanceLoad.get(i));
            ++i;
        }
        _instance.save();
        _filtersToAddOnInstanceLoad.clear();
    }

    public static boolean isDefaultFiltersAddedForKey(String key) {
        return UIPlugin.getDefault().getPluginPreferences().getBoolean(DEFAULT_FILTER_KEY_PREFIX + key);
    }

    public static void defaultFiltersAddedForKey(String key, boolean added) {
        UIPlugin.getDefault().getPluginPreferences().setValue(DEFAULT_FILTER_KEY_PREFIX + key, added);
    }
}

